/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.Border;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.BorderFormula;
import de.matthiasmann.twlthemeeditor.datamodel.DomXPPParser;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Collection;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    public static int parseInt(String string) throws NumberFormatException {
        if (string.startsWith("0x")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        return Integer.parseInt(string, 10);
    }

    public static int[] parseInts(String string) {
        int n = 1;
        int n2 = -1;
        while ((n2 = string.indexOf(44, n2 + 1)) >= 0) {
            ++n;
        }
        int[] nArray = new int[n];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = string.indexOf(44, n3);
            if (n4 < 0) {
                n4 = string.length();
            }
            String string2 = string.substring(n3, n4);
            nArray[i] = Integer.parseInt(string2.trim());
            n3 = n4 + 1;
        }
        return nArray;
    }

    public static String toString(int[] nArray) {
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : nArray) {
            stringBuilder.append(',').append(n);
        }
        return stringBuilder.substring(1);
    }

    public static Border parseBorder(String string) {
        if (string == null) {
            return null;
        }
        int[] nArray = Utils.parseInts(string);
        if (nArray == null) {
            return null;
        }
        switch (nArray.length) {
            case 1: {
                return new Border(nArray[0]);
            }
            case 2: {
                return new Border(nArray[0], nArray[1]);
            }
            case 4: {
                return new Border(nArray[0], nArray[1], nArray[2], nArray[3]);
            }
        }
        return null;
    }

    public static DialogLayout.Gap parseGap(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new DialogLayout.Gap();
        }
        int[] nArray = Utils.parseInts(string);
        if (nArray == null) {
            return null;
        }
        switch (nArray.length) {
            case 1: {
                return new DialogLayout.Gap(nArray[0]);
            }
            case 2: {
                return new DialogLayout.Gap(nArray[0], nArray[1]);
            }
            case 3: {
                return new DialogLayout.Gap(nArray[0], nArray[1], nArray[2]);
            }
        }
        return null;
    }

    public static Dimension parseDimension(String string) {
        if (string == null) {
            return null;
        }
        int[] nArray = Utils.parseInts(string);
        if (nArray == null) {
            return null;
        }
        switch (nArray.length) {
            case 1: {
                return new Dimension(nArray[0], nArray[0]);
            }
            case 2: {
                return new Dimension(nArray[0], nArray[1]);
            }
        }
        return null;
    }

    public static String toString(Border border, boolean bl) {
        if (border == null) {
            return null;
        }
        if (border instanceof BorderFormula) {
            return border.toString();
        }
        if (border.getBorderTop() == border.getBorderBottom() && border.getBorderLeft() == border.getBorderRight()) {
            if (border.getBorderTop() == border.getBorderLeft()) {
                if (bl && border.getBorderTop() == 0) {
                    return null;
                }
                return Integer.toString(border.getBorderTop());
            }
            return border.getBorderLeft() + "," + border.getBorderTop();
        }
        return border.getBorderTop() + "," + border.getBorderLeft() + "," + border.getBorderBottom() + "," + border.getBorderRight();
    }

    public static String capitalize(String string) {
        if (string.length() > 0) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    public static void addToXPP(DomXPPParser domXPPParser, ThemeTreeNode themeTreeNode) {
        int n = themeTreeNode.getNumChildren();
        for (int i = 0; i < n; ++i) {
            TreeTableNode treeTableNode = themeTreeNode.getChild(i);
            if (!(treeTableNode instanceof ThemeTreeNode)) continue;
            ((ThemeTreeNode)treeTableNode).addToXPP(domXPPParser);
        }
    }

    public static void addToXPP(DomXPPParser domXPPParser, String string, ThemeTreeNode themeTreeNode, Collection<Attribute> collection) {
        domXPPParser.addStartTag((Object)themeTreeNode, string, collection);
        Utils.addToXPP(domXPPParser, themeTreeNode);
        domXPPParser.addEndTag(string);
    }

    public static SAXBuilder createSAXBuilder() {
        SAXBuilder sAXBuilder = new SAXBuilder(false);
        sAXBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        return sAXBuilder;
    }

    public static Document loadDocument(URL uRL) throws IOException {
        try {
            return Utils.createSAXBuilder().build(uRL);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static Document loadDocument(InputStream inputStream) throws IOException {
        try {
            return Utils.createSAXBuilder().build(inputStream);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static Document loadDocument(String string) throws IOException {
        try {
            return Utils.createSAXBuilder().build((Reader)new StringReader(string));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static <T> int find(ListModel<T> listModel, T t) {
        int n = listModel.getNumEntries();
        for (int i = 0; i < n; ++i) {
            if (!Utils.equals(listModel.getEntry(i), t)) continue;
            return i;
        }
        return -1;
    }

    public static boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }
}

