/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel.images;

import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.Image;
import de.matthiasmann.twlthemeeditor.datamodel.Images;
import de.matthiasmann.twlthemeeditor.datamodel.Split;
import de.matthiasmann.twlthemeeditor.properties.AttributeProperty;
import de.matthiasmann.twlthemeeditor.properties.BooleanProperty;
import de.matthiasmann.twlthemeeditor.properties.SplitProperty;
import org.jdom.Element;

public class Area
extends Image {
    protected final Image.ImageRectProperty rectProperty;

    public Area(Images images, TreeTableNode treeTableNode, Element element) {
        super(images, treeTableNode, element);
        this.rectProperty = new Image.ImageRectProperty(element);
        this.addProperty(this.rectProperty);
        this.addProperty(new HSplitProperty());
        this.addProperty(new VSplitProperty());
        this.addProperty(new BooleanProperty((Property<String>)new AttributeProperty(this.element, "nocenter", "No Center", true), false).withTooltip("This parameter is only used when either Split X/Y is enabled"));
        this.addProperty(new BooleanProperty((Property<String>)new AttributeProperty(this.element, "tiled", "Tiled", true), false));
    }

    protected String getIcon() {
        return "image-area";
    }

    protected class HSplitProperty
    extends SplitProperty {
        public HSplitProperty() {
            super((Property<String>)new AttributeProperty(Area.this.element, "splitx", "Split X positions", true), Split.Axis.HORIZONTAL);
        }

        public int getLimit() {
            return Area.this.rectProperty.getPropertyValue().getWidth();
        }
    }

    protected class VSplitProperty
    extends SplitProperty {
        public VSplitProperty() {
            super((Property<String>)new AttributeProperty(Area.this.element, "splity", "Split Y positions", true), Split.Axis.VERTICAL);
        }

        public int getLimit() {
            return Area.this.rectProperty.getPropertyValue().getHeight();
        }
    }
}

