/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel.images;

import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.Images;
import de.matthiasmann.twlthemeeditor.datamodel.NameGenerator;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.Weights;
import de.matthiasmann.twlthemeeditor.datamodel.images.WithSubImages;
import de.matthiasmann.twlthemeeditor.properties.AttributeProperty;
import de.matthiasmann.twlthemeeditor.properties.WeightsProperty;
import java.io.IOException;
import org.jdom.Element;

public class Grid
extends WithSubImages
implements NameGenerator {
    private final WeightsProperty weightsXProperty;
    private final WeightsProperty weightsYProperty;

    public Grid(Images images, ThemeTreeNode themeTreeNode, Element element) throws IOException {
        super(images, (TreeTableNode)themeTreeNode, element);
        this.weightsXProperty = new WeightsProperty((Property<String>)new AttributeProperty(element, "weightsX"));
        this.weightsYProperty = new WeightsProperty((Property<String>)new AttributeProperty(element, "weightsY"));
        this.addProperty(this.weightsXProperty);
        this.addProperty(this.weightsYProperty);
    }

    protected int getRequiredChildren() {
        Weights weights = this.weightsXProperty.getPropertyValue();
        Weights weights2 = this.weightsYProperty.getPropertyValue();
        return weights.getNumWeights() * weights2.getNumWeights();
    }

    public String generateName(ThemeTreeNode themeTreeNode) {
        int n = this.getChildIndex((TreeTableNode)themeTreeNode);
        int n2 = Math.max(1, this.weightsXProperty.getPropertyValue().getNumWeights());
        int n3 = n / n2;
        int n4 = n % n2;
        return "row " + n3 + " col " + n4;
    }

    protected String getIcon() {
        return "image-grid";
    }
}

