/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel.images;

import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.DomWrapper;
import de.matthiasmann.twlthemeeditor.datamodel.DomXPPParser;
import de.matthiasmann.twlthemeeditor.datamodel.Image;
import de.matthiasmann.twlthemeeditor.datamodel.Images;
import de.matthiasmann.twlthemeeditor.datamodel.NameGenerator;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.images.Frame;
import de.matthiasmann.twlthemeeditor.datamodel.images.Frames;
import de.matthiasmann.twlthemeeditor.datamodel.images.WithSubImages;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewArea;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewSimple;
import de.matthiasmann.twlthemeeditor.properties.AttributeProperty;
import de.matthiasmann.twlthemeeditor.properties.IntegerProperty;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repeat
extends WithSubImages
implements NameGenerator {
    Repeat(Images images, TreeTableNode treeTableNode, Element element) throws IOException {
        super(images, treeTableNode, element);
        this.addProperty(new IntegerProperty((Property<String>)new AttributeProperty(element, "count", "Count", true), 0, Short.MAX_VALUE));
    }

    @Override
    protected int getRequiredChildren() {
        return Math.max(1, this.getNumChildren());
    }

    @Override
    public String generateName(ThemeTreeNode themeTreeNode) {
        int n = this.getChildIndex((TreeTableNode)themeTreeNode);
        return "Frame " + (n + 1);
    }

    @Override
    public void addChildren() throws IOException {
        this.addChildren(this.textures.getThemeFile(), this.element, new DomWrapper(){

            public TreeTableNode wrap(ThemeFile themeFile, ThemeTreeNode themeTreeNode, Element element) throws IOException {
                String string = element.getName();
                if ("repeat".equals(string)) {
                    return new Repeat(Repeat.this.textures, (TreeTableNode)themeTreeNode, element);
                }
                if ("frame".equals(string)) {
                    return new Frame(Repeat.this.textures, (TreeTableNode)themeTreeNode, element);
                }
                if ("frames".equals(string)) {
                    Image.convertToXYWH(themeFile, element);
                    return new Frames(Repeat.this.textures, (TreeTableNode)themeTreeNode, element);
                }
                return null;
            }
        });
    }

    @Override
    protected void addMissingChild(DomXPPParser domXPPParser) {
        domXPPParser.addElement(this, new Element("frame").setAttribute("ref", "none").setAttribute("duration", "100"));
    }

    @Override
    protected void addCreateOperations(List<CreateChildOperation> list) {
        list.add(new CreateNewSimple(this, this.element, "repeat", "count", "1"));
        list.add(new CreateNewSimple(this, this.element, "frame", "duration", "100", "ref", "none"));
        list.add(new CreateNewArea(this, this.element, "frames", "duration", "100", "count", "2", "offsetx", "10"));
    }
}

