/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel.operations;

import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.ElementOperation;
import java.io.IOException;
import org.jdom.Content;
import org.jdom.Element;

public class CloneNodeOperation
extends ElementOperation {
    public CloneNodeOperation(Element element, ThemeTreeNode themeTreeNode) {
        super("opCloneNode", element, themeTreeNode);
    }

    public boolean shouldFocusNameFieldAfterExecute() {
        return true;
    }

    public ThemeTreeNode execute(Object[] objectArray) throws IOException {
        int n = this.getElementPosition();
        int n2 = this.getPrevSiblingPosition(n) + 1;
        Element element = null;
        for (int i = n; i >= n2; --i) {
            Content content = this.parent.getContent(i);
            Content content2 = (Content)content.clone();
            if (content2 instanceof Element) {
                element = (Element)content2;
                this.adjustClonedElement(element);
            }
            this.parent.addContent(n + 1, content2);
        }
        this.updateParent();
        return CreateChildOperation.findChildInParent((TreeTableNode)this.getNodeParent(), element);
    }

    protected void adjustClonedElement(Element element) {
        String string = element.getAttributeValue("name");
        if (string != null) {
            String string2 = null;
            Kind kind = this.node.getKind();
            if (kind != Kind.NONE) {
                int n;
                int n2;
                for (n2 = n = string.length(); n2 > 0 && Character.isDigit(string.charAt(n2 - 1)); --n2) {
                }
                if (n2 < n) {
                    String string3 = string.substring(0, n2);
                    try {
                        long l = Long.parseLong(string.substring(n2));
                        for (int i = 1; i < 100; ++i) {
                            String string4 = string3 + (l + (long)i);
                            if (this.node.getThemeTreeModel().findNode(string4, kind) != null) continue;
                            string2 = string4;
                            break;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            if (string2 == null) {
                string2 = string + System.nanoTime();
            }
            element.setAttribute("name", string2);
        }
    }
}

