/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel.operations;

import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.ElementOperation;
import java.io.IOException;
import java.util.Arrays;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public abstract class CreateChildOperation
extends ThemeTreeOperation {
    protected static final int INDENTATION_SIZE = 4;
    protected final ThemeTreeNode parent;
    protected final Element element;
    protected boolean indentChildren = true;

    public CreateChildOperation(String string, ThemeTreeNode themeTreeNode, Element element) {
        super(string);
        this.parent = themeTreeNode;
        this.element = element;
    }

    public boolean shouldFocusNameFieldAfterExecute() {
        return true;
    }

    protected int getBaseIndentation() {
        int n = 0;
        for (Element element = this.element; element != null; element = element.getParentElement()) {
            n += 4;
        }
        return n;
    }

    protected static String createIndentation(int n) {
        char[] cArray = new char[n + 1];
        Arrays.fill(cArray, ' ');
        cArray[0] = 10;
        return new String(cArray);
    }

    public final ThemeTreeNode execute(Object[] objectArray) throws IOException {
        return this.executeAt(objectArray, this.element.getContentSize());
    }

    public abstract ThemeTreeNode executeAt(Object[] var1, int var2) throws IOException;

    protected ThemeTreeNode addChild(Element element, int n) throws IOException {
        int n2 = this.getBaseIndentation();
        if (n <= 0 || !(this.element.getContent(n - 1) instanceof Text)) {
            this.element.addContent(n, (Content)new Text(CreateChildOperation.createIndentation(n2 - 4)));
        }
        int n3 = --n;
        this.element.addContent(n3, (Content)new Text(CreateChildOperation.createIndentation(n2)));
        this.element.addContent(++n, (Content)element);
        if (this.indentChildren) {
            this.addIndentation(element, n2);
        }
        this.parent.addChildren();
        ElementOperation.setModified(this.element);
        return CreateChildOperation.findChildInParent((TreeTableNode)this.parent, element);
    }

    protected static ThemeTreeNode findChildInParent(TreeTableNode treeTableNode, Element element) {
        int n = treeTableNode.getNumChildren();
        for (int i = 0; i < n; ++i) {
            ThemeTreeNode themeTreeNode;
            TreeTableNode treeTableNode2 = treeTableNode.getChild(i);
            if (!(treeTableNode2 instanceof ThemeTreeNode) || (themeTreeNode = (ThemeTreeNode)treeTableNode2).getDOMElement() != element) continue;
            return themeTreeNode;
        }
        return null;
    }

    protected void addIndentation(Element element, int n) {
        boolean bl = false;
        int n2 = element.getContentSize();
        while (n2-- > 0) {
            Text text;
            Content content = element.getContent(n2);
            if (content instanceof Element) {
                this.addIndentation((Element)content, n + 4);
                element.addContent(n2, (Content)new Text(CreateChildOperation.createIndentation(n + 4)));
                bl = true;
                continue;
            }
            if (!(content instanceof Text) || !"\n".equals((text = (Text)content).getText())) continue;
            text.setText(CreateChildOperation.createIndentation(n));
        }
        if (bl) {
            element.addContent(CreateChildOperation.createIndentation(n));
        }
    }

    protected String makeRandomName() {
        return "new" + System.nanoTime();
    }

    protected void addNameAttributeIfNeeded(Element element) {
        if (this.parent.childrenNeedName()) {
            element.setAttribute("name", this.makeRandomName());
        }
    }
}

