/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel.operations;

import de.matthiasmann.twl.Clipboard;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import java.io.IOException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;

public class PasteNodeOperation
extends CreateChildOperation {
    private final Element pasteElement;

    public PasteNodeOperation(ThemeTreeNode themeTreeNode, Element element) {
        super("opPasteNode", themeTreeNode, element);
        this.indentChildren = false;
        this.pasteElement = this.getFromClipboard();
    }

    public boolean shouldFocusNameFieldAfterExecute() {
        return true;
    }

    private Element getFromClipboard() {
        String string = Clipboard.getClipboard();
        if (string == null || string.isEmpty() || !string.startsWith("<")) {
            return null;
        }
        try {
            Document document = Utils.loadDocument(string);
            return document.detachRootElement();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isEnabled() {
        return this.pasteElement != null && this.parent.canPasteElement(this.pasteElement);
    }

    public ThemeTreeNode executeAt(Object[] objectArray, int n) throws IOException {
        if (this.isEnabled()) {
            boolean bl;
            Element element = (Element)this.pasteElement.clone();
            boolean bl2 = bl = element.getAttribute("name") != null;
            if (!this.parent.childrenNeedName()) {
                if (bl) {
                    element.removeAttribute("name");
                }
            } else if (!bl) {
                element.setAttribute("name", this.makeRandomName());
            }
            PasteNodeOperation.adjustIndentation(element, this.getBaseIndentation());
            return this.addChild(element, n);
        }
        return null;
    }

    private static void adjustIndentation(Element element, int n) {
        boolean bl = true;
        int n2 = element.getContentSize();
        while (n2-- > 0) {
            Text text;
            String string;
            Content content = element.getContent(n2);
            if (content instanceof Text && (string = (text = (Text)content).getText()).trim().isEmpty()) {
                int n3 = 0;
                int n4 = -1;
                while ((n4 = string.indexOf(10, n4 + 1)) >= 0) {
                    ++n3;
                }
                String string2 = PasteNodeOperation.createIndentation(n);
                if (n3 > 1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < n3; ++i) {
                        stringBuilder.append(string2);
                    }
                    string2 = stringBuilder.toString();
                }
                text.setText(string2);
            }
            if (bl) {
                n += 4;
                bl = false;
            }
            if (!(content instanceof Element)) continue;
            PasteNodeOperation.adjustIndentation((Element)content, n);
        }
    }
}

