/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntMap<T>
implements Iterable<Entry<T>> {
    private static final int PAGE_SIZE = 256;
    Object[][] pages = new Object[16][];

    public void put(int n, T t) {
        Object[] objectArray;
        int n2 = n / 256;
        int n3 = n % 256;
        if (n2 >= this.pages.length || (objectArray = this.pages[n2]) == null) {
            objectArray = this.newPage(n2);
        }
        objectArray[n3] = t;
    }

    public T get(int n) {
        Object[] objectArray;
        int n2 = n / 256;
        int n3 = n % 256;
        if (n2 < this.pages.length && (objectArray = this.pages[n2]) != null) {
            return (T)objectArray[n3];
        }
        return null;
    }

    @Override
    public Iterator<Entry<T>> iterator() {
        return new Iterator<Entry<T>>(){
            int pageNr;
            int pageIdx;
            Object[] page;
            {
                this.page = IntMap.this.pages[0];
            }

            @Override
            public boolean hasNext() {
                block0: while (true) {
                    if (this.pageIdx == 256) {
                        this.pageIdx = 0;
                        this.page = null;
                    }
                    while (this.page == null) {
                        if (++this.pageNr >= IntMap.this.pages.length) {
                            return false;
                        }
                        this.page = IntMap.this.pages[this.pageNr];
                    }
                    while (true) {
                        if (this.pageIdx >= 256) continue block0;
                        if (this.page[this.pageIdx] != null) {
                            return true;
                        }
                        ++this.pageIdx;
                    }
                    break;
                }
            }

            @Override
            public Entry<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int n = this.pageNr * 256 + this.pageIdx;
                Object object = this.page[this.pageIdx++];
                return new Entry<Object>(n, object);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Object[] newPage(int n) {
        if (n >= this.pages.length) {
            int n2;
            for (n2 = this.pages.length; n2 <= n; n2 *= 2) {
            }
            Object[][] objectArrayArray = new Object[n2][];
            System.arraycopy(this.pages, 0, objectArrayArray, 0, this.pages.length);
            this.pages = objectArrayArray;
        }
        Object[] objectArray = new Object[256];
        this.pages[n] = objectArray;
        return objectArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<T> {
        final int key;
        final T value;

        public Entry(int n, T t) {
            this.key = n;
            this.value = t;
        }
    }
}

