/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen.effects;

import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.SimpleProperty;
import de.matthiasmann.twlthemeeditor.fontgen.Effect;
import de.matthiasmann.twlthemeeditor.fontgen.FontInfo;
import de.matthiasmann.twlthemeeditor.fontgen.GlyphRect;
import de.matthiasmann.twlthemeeditor.fontgen.Padding;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlurShadowEffect
extends Effect {
    static final int NUM_KERNELS = 16;
    static final float[][] GAUSSIAN_BLUR_KERNELS = BlurShadowEffect.generateGaussianBlurKernels(16);
    static final RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    private final SimpleProperty<Float> distance = new SimpleProperty(Float.class, "distance", (Object)Float.valueOf(3.0f));
    private final SimpleProperty<Integer> kernelsize = new SimpleProperty(Integer.class, "kernel size", (Object)3);
    private final SimpleProperty<Integer> passes = new SimpleProperty(Integer.class, "num passes", (Object)1);
    private final SimpleProperty<Color> color = new SimpleProperty(Color.class, "color", (Object)new Color(0, 0, 0, 128));

    @Override
    public Effect.Renderer createRenderer() {
        return new RendererImpl((Integer)this.kernelsize.getPropertyValue(), (Integer)this.passes.getPropertyValue(), (Color)this.color.getPropertyValue(), ((Float)this.distance.getPropertyValue()).floatValue());
    }

    @Override
    public Property<?>[] getProperties() {
        return new Property[]{this.distance, this.kernelsize, this.passes, new Effect.ColorConvertProperty((Property<Color>)this.color)};
    }

    private static float[][] generateGaussianBlurKernels(int n) {
        float[][] fArray = BlurShadowEffect.generatePascalsTriangle(n);
        float[][] fArrayArray = new float[fArray.length][];
        for (int i = 0; i < fArrayArray.length; ++i) {
            float f = 0.0f;
            fArrayArray[i] = new float[fArray[i].length];
            for (int j = 0; j < fArray[i].length; ++j) {
                f += fArray[i][j];
            }
            float f2 = 1.0f / f;
            for (int j = 0; j < fArray[i].length; ++j) {
                fArrayArray[i][j] = f2 * fArray[i][j];
            }
        }
        return fArrayArray;
    }

    private static float[][] generatePascalsTriangle(int n) {
        if (n < 2) {
            n = 2;
        }
        float[][] fArrayArray = new float[n][];
        fArrayArray[0] = new float[]{1.0f};
        fArrayArray[1] = new float[]{1.0f, 1.0f};
        for (int i = 2; i < n; ++i) {
            fArrayArray[i] = new float[i + 1];
            fArrayArray[i][0] = 1.0f;
            fArrayArray[i][i] = 1.0f;
            for (int j = 1; j < fArrayArray[i].length - 1; ++j) {
                fArrayArray[i][j] = fArrayArray[i - 1][j - 1] + fArrayArray[i - 1][j];
            }
        }
        return fArrayArray;
    }

    private static class RendererImpl
    extends Effect.Renderer {
        private final int kernelSize;
        private final int numPasses;
        private final Color color;
        private final float dist;
        private ConvolveOp filterH;
        private ConvolveOp filterV;

        public RendererImpl(int n, int n2, Color color, float f) {
            this.kernelSize = n;
            this.numPasses = n2;
            this.color = color;
            this.dist = f;
        }

        public void prePageRender(Graphics2D graphics2D, FontInfo fontInfo) {
            if (this.kernelSize > 1 && this.numPasses >= 1) {
                float[] fArray = GAUSSIAN_BLUR_KERNELS[Math.min(16, this.kernelSize) - 1];
                Kernel kernel = new Kernel(fArray.length, 1, fArray);
                Kernel kernel2 = new Kernel(1, fArray.length, fArray);
                this.filterH = new ConvolveOp(kernel, 1, hints);
                this.filterV = new ConvolveOp(kernel2, 1, hints);
            } else {
                this.filterH = null;
                this.filterV = null;
            }
        }

        public void preGlyphRender(Graphics2D graphics2D, FontInfo fontInfo, GlyphRect glyphRect) {
            BufferedImage bufferedImage = new BufferedImage(glyphRect.width, glyphRect.height, 2);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            graphics2D2.setColor(this.color);
            graphics2D2.translate((float)glyphRect.xDrawOffset + this.dist, (float)(glyphRect.yDrawOffset - glyphRect.yoffset) + this.dist);
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.fill(glyphRect.glyphShape);
            graphics2D2.dispose();
            if (this.filterH != null && this.filterV != null) {
                BufferedImage bufferedImage2 = new BufferedImage(glyphRect.width, glyphRect.height, 2);
                for (int i = 0; i < this.numPasses; ++i) {
                    this.filterH.filter(bufferedImage, bufferedImage2);
                    this.filterV.filter(bufferedImage2, bufferedImage);
                }
            }
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        }

        public void postPageRender(Graphics2D graphics2D, FontInfo fontInfo) {
            this.filterH = null;
            this.filterV = null;
        }

        public Padding getPadding() {
            int n = Math.round((float)Math.ceil(this.dist));
            return new Padding(0, 0, n, n, 0);
        }
    }
}

