/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen.effects;

import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.SimpleProperty;
import de.matthiasmann.twlthemeeditor.fontgen.Effect;
import de.matthiasmann.twlthemeeditor.fontgen.FontInfo;
import de.matthiasmann.twlthemeeditor.fontgen.GlyphRect;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradientEffect
extends Effect {
    private final SimpleProperty<Color> colorTop = new SimpleProperty(Color.class, "top color", (Object)Color.YELLOW);
    private final SimpleProperty<Color> colorBottom = new SimpleProperty(Color.class, "bottom color", (Object)Color.RED);

    @Override
    public Effect.Renderer createRenderer() {
        return new RendererImpl((Color)this.colorTop.getPropertyValue(), (Color)this.colorBottom.getPropertyValue());
    }

    @Override
    public Property<?>[] getProperties() {
        return new Property[]{new Effect.ColorConvertProperty((Property<Color>)this.colorTop), new Effect.ColorConvertProperty((Property<Color>)this.colorBottom)};
    }

    private static class RendererImpl
    extends Effect.Renderer {
        private final Color colorTop;
        private final Color colorBottom;

        public RendererImpl(Color color, Color color2) {
            this.colorTop = color;
            this.colorBottom = color2;
        }

        public void preGlyphRender(Graphics2D graphics2D, FontInfo fontInfo, GlyphRect glyphRect) {
            graphics2D.setPaint(new GradientPaint(0.0f, -fontInfo.maxGlyphHeight, this.colorTop, 0.0f, fontInfo.maxGlyphDecent, this.colorBottom));
        }
    }
}

