/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen.effects;

import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.SimpleProperty;
import de.matthiasmann.twlthemeeditor.fontgen.Effect;
import de.matthiasmann.twlthemeeditor.fontgen.FontInfo;
import de.matthiasmann.twlthemeeditor.fontgen.GlyphRect;
import de.matthiasmann.twlthemeeditor.fontgen.Padding;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineEffect
extends Effect {
    private final SimpleProperty<Float> width = new SimpleProperty(Float.class, "width", (Object)Float.valueOf(2.0f));
    private final SimpleProperty<Color> color = new SimpleProperty(Color.class, "color", (Object)Color.GRAY);
    private final SimpleProperty<Join> join = new SimpleProperty(Join.class, "join", (Object)Join.BEVEL);

    @Override
    public Effect.Renderer createRenderer() {
        return new RendererImpl(((Float)this.width.getPropertyValue()).floatValue(), ((Join)((Object)this.join.getPropertyValue())).awtJoin, (Color)this.color.getPropertyValue());
    }

    @Override
    public Property<?>[] getProperties() {
        return new Property[]{this.width, this.join, new Effect.ColorConvertProperty((Property<Color>)this.color)};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Join {
        BEVEL(2),
        MITER(0),
        ROUND(1);

        int awtJoin;

        private Join(int n2) {
            this.awtJoin = n2;
        }
    }

    private static class RendererImpl
    extends Effect.Renderer {
        private final float width;
        private final int awtJoin;
        private final Color color;
        private BasicStroke stroke;

        public RendererImpl(float f, int n, Color color) {
            this.width = f;
            this.awtJoin = n;
            this.color = color;
        }

        public void prePageRender(Graphics2D graphics2D, FontInfo fontInfo) {
            this.stroke = new BasicStroke(Math.max(0.001f, this.width), 2, this.awtJoin);
        }

        public void postGlyphRender(Graphics2D graphics2D, FontInfo fontInfo, GlyphRect glyphRect) {
            int n = glyphRect.yDrawOffset - glyphRect.yoffset;
            graphics2D.setColor(this.color);
            graphics2D.setStroke(this.stroke);
            graphics2D.setPaint(null);
            graphics2D.translate(glyphRect.xDrawOffset, n);
            graphics2D.draw(glyphRect.glyphShape);
            graphics2D.translate(-glyphRect.xDrawOffset, -n);
        }

        public Padding getPadding() {
            int n = Math.round(this.width);
            int n2 = Math.round(this.width * 0.5f);
            return new Padding(n2, n2, n2, n2, n);
        }
    }
}

