/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen.gui;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ValueAdjuster;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twlthemeeditor.fontgen.Effect;
import de.matthiasmann.twlthemeeditor.fontgen.gui.EffectPropertyPanel;
import de.matthiasmann.twlthemeeditor.gui.CollapsiblePanel;
import de.matthiasmann.twlthemeeditor.gui.PropertyFactories;
import java.util.ArrayList;
import java.util.Properties;

public class EffectsPanel
extends DialogLayout {
    private final DialogLayout.Group hLabels = this.createParallelGroup();
    private final DialogLayout.Group hControls = this.createParallelGroup();
    private final DialogLayout.Group vRows = this.createSequentialGroup();
    private final PropertyFactories factories = new PropertyFactories();
    private final ArrayList<EffectPropertyPanel> effectPanels = new ArrayList();
    private final ArrayList<CollapsiblePanel> effectCollapsiblePanels = new ArrayList();
    private Runnable[] callbacks;

    public EffectsPanel() {
        this.setIncludeInvisibleWidgets(false);
        this.setHorizontalGroup(this.createParallelGroup().addGroup(this.createSequentialGroup(new DialogLayout.Group[]{this.hLabels, this.hControls})));
        this.setVerticalGroup(this.vRows);
    }

    public void addEffect(String string, Effect effect) {
        EffectPropertyPanel effectPropertyPanel = new EffectPropertyPanel(this.factories, string, effect);
        effectPropertyPanel.addCallback(new Runnable(){

            public void run() {
                EffectsPanel.this.fireCallback();
            }
        });
        this.effectPanels.add(effectPropertyPanel);
        this.effectCollapsiblePanels.add(this.addCollapsible(string, (Widget)effectPropertyPanel, (BooleanModel)effectPropertyPanel.getEffectActive()));
    }

    public CollapsiblePanel addCollapsible(String string, Widget widget, BooleanModel booleanModel) {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel(CollapsiblePanel.Direction.VERTICAL, string, widget, booleanModel);
        this.addControl((Widget)collapsiblePanel);
        return collapsiblePanel;
    }

    public CollapsiblePanel addCollapsible(String string, final ValueAdjuster[] valueAdjusterArray, final BooleanModel booleanModel) {
        DialogLayout dialogLayout = new DialogLayout();
        dialogLayout.setHorizontalGroup(dialogLayout.createParallelGroup((Widget[])valueAdjusterArray));
        dialogLayout.setVerticalGroup(dialogLayout.createSequentialGroup().addWidgetsWithGap("adjuster", (Widget[])valueAdjusterArray));
        if (booleanModel != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    boolean bl = booleanModel.getValue();
                    for (ValueAdjuster valueAdjuster : valueAdjusterArray) {
                        valueAdjuster.setEnabled(bl);
                    }
                }
            };
            booleanModel.addCallback(runnable);
            runnable.run();
        }
        return this.addCollapsible(string, (Widget)dialogLayout, booleanModel);
    }

    public void addControl(String string, Widget widget) {
        Label label = new Label(string);
        label.setLabelFor(widget);
        this.hLabels.addWidget((Widget)label);
        this.hControls.addWidget(widget);
        this.vRows.addGroup(this.createParallelGroup().addWidget((Widget)label).addWidget(widget));
    }

    public void addControl(String string, Widget widget, Button button) {
        Label label = new Label(string);
        label.setLabelFor(widget);
        this.hLabels.addWidget((Widget)label);
        this.hControls.addGroup(this.createSequentialGroup().addWidget(widget).addWidget((Widget)button));
        this.vRows.addGroup(this.createParallelGroup().addWidget((Widget)label).addWidget(widget).addWidget((Widget)button));
    }

    public void addControl(Widget widget) {
        this.getHorizontalGroup().addWidget(widget);
        this.getVerticalGroup().addWidget(widget);
    }

    public void addCallback(Runnable runnable) {
        this.callbacks = (Runnable[])CallbackSupport.addCallbackToList((Object[])this.callbacks, (Object)runnable, Runnable.class);
    }

    public void removeCallback(Runnable runnable) {
        this.callbacks = (Runnable[])CallbackSupport.removeCallbackFromList((Object[])this.callbacks, (Object)runnable);
    }

    public void enableEffectsPanels(boolean bl) {
        for (CollapsiblePanel collapsiblePanel : this.effectCollapsiblePanels) {
            collapsiblePanel.setVisible(bl);
        }
    }

    void fireCallback() {
        CallbackSupport.fireCallbacks((Runnable[])this.callbacks);
    }

    public void save(Properties properties) {
        for (EffectPropertyPanel effectPropertyPanel : this.effectPanels) {
            effectPropertyPanel.save(properties);
        }
    }

    public void load(Properties properties) {
        for (EffectPropertyPanel effectPropertyPanel : this.effectPanels) {
            effectPropertyPanel.load(properties);
        }
    }

    public Effect[] getActiveEffects() {
        ArrayList<Effect> arrayList = new ArrayList<Effect>();
        for (EffectPropertyPanel effectPropertyPanel : this.effectPanels) {
            if (!effectPropertyPanel.getEffectActive().getValue()) continue;
            arrayList.add(effectPropertyPanel.getEffect());
        }
        return arrayList.toArray(new Effect[arrayList.size()]);
    }
}

