/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen.gui;

import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.DynamicImage;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class FontPreview
extends Widget {
    private static final int WIDTH = 1024;
    private static final int HEIGHT = 64;
    private final BufferedImage bi = new BufferedImage(1024, 64, 2);
    private final ByteBuffer bb = ByteBuffer.allocateDirect(262144);
    private final IntBuffer ib = this.bb.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
    private String text = "The quick brown fox jumps over the lazy dog.";
    private Font font;
    private DynamicImage image;
    private boolean imageDirty = true;

    public FontPreview() {
        this.setClip(true);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.imageDirty = true;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.imageDirty = true;
    }

    public int getPreferredInnerWidth() {
        return 1024;
    }

    public int getPreferredInnerHeight() {
        return 64;
    }

    public void destroy() {
        super.destroy();
        if (this.image != null) {
            this.image.destroy();
            this.image = null;
        }
    }

    protected void paintWidget(GUI gUI) {
        if (this.imageDirty) {
            this.updateImage(gUI);
        }
        if (this.image != null) {
            this.image.draw((AnimationState)this.getAnimationState(), this.getInnerX(), this.getInnerY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImage(GUI gUI) {
        this.imageDirty = false;
        if (this.image == null) {
            this.image = gUI.getRenderer().createDynamicImage(1024, 64);
        }
        if (this.image != null) {
            Graphics2D graphics2D = this.bi.createGraphics();
            try {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, 1024, 64);
                if (this.font != null && this.text != null) {
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.setFont(this.font);
                    FontMetrics fontMetrics = graphics2D.getFontMetrics();
                    graphics2D.drawString(this.text, 10, fontMetrics.getAscent() + fontMetrics.getLeading());
                }
            }
            finally {
                graphics2D.dispose();
            }
            this.ib.clear();
            this.ib.put(((DataBufferInt)this.bi.getRaster().getDataBuffer()).getData());
            this.image.update(this.bb, DynamicImage.Format.BGRA);
        }
    }
}

