/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.CallbackWithReason;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Menu;
import de.matthiasmann.twl.MenuAction;
import de.matthiasmann.twl.MenuElement;
import de.matthiasmann.twl.Rect;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.SplitPane;
import de.matthiasmann.twl.Timer;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.EnumModel;
import de.matthiasmann.twl.model.OptionEnumModel;
import de.matthiasmann.twl.model.PersistentEnumModel;
import de.matthiasmann.twl.model.PersistentMRUListModel;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.Texture;
import de.matthiasmann.twlthemeeditor.DelayedAction;
import de.matthiasmann.twlthemeeditor.datamodel.Images;
import de.matthiasmann.twlthemeeditor.datamodel.Split;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeModel;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.gui.Context;
import de.matthiasmann.twlthemeeditor.gui.LoadFileSelector;
import de.matthiasmann.twlthemeeditor.gui.MessageLog;
import de.matthiasmann.twlthemeeditor.gui.NewClasspathDialog;
import de.matthiasmann.twlthemeeditor.gui.PreviewWidget;
import de.matthiasmann.twlthemeeditor.gui.ProgressDialog;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyFactories;
import de.matthiasmann.twlthemeeditor.gui.PropertyPanel;
import de.matthiasmann.twlthemeeditor.gui.TestWidgetManager;
import de.matthiasmann.twlthemeeditor.gui.TextureViewer;
import de.matthiasmann.twlthemeeditor.gui.TextureViewerPane;
import de.matthiasmann.twlthemeeditor.gui.ThemeTreePane;
import de.matthiasmann.twlthemeeditor.gui.WidgetPropertyEditor;
import de.matthiasmann.twlthemeeditor.gui.WidgetTree;
import de.matthiasmann.twlthemeeditor.gui.WidgetTreeModel;
import de.matthiasmann.twlthemeeditor.properties.ColorProperty;
import de.matthiasmann.twlthemeeditor.properties.HasProperties;
import de.matthiasmann.twlthemeeditor.properties.RectProperty;
import de.matthiasmann.twlthemeeditor.properties.SplitProperty;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorArea
extends Widget {
    private static final String KEY_RECENT_CLASSPATHS = "recentClasspaths";
    private static final String KEY_CLASSPATH_FS = "userWidgetJARs";
    private static final String KEY_LAYOUT = "layout";
    private final MessageLog messageLog;
    private final ProgressDialog progressDialog;
    private final TestWidgetManager testWidgetManager;
    private final Menu testWidgetMenu;
    private final ThemeTreePane themeTreePane;
    private final PreviewWidget previewWidget;
    private final TextureViewerPane textureViewerPane;
    private final ScrollPane propertiesScrollPane;
    private final WidgetTreeModel widgetTreeModel;
    private final WidgetTree widgetTree;
    private final WidgetPropertyEditor widgetPropertyEditor;
    private final Preferences prefs;
    private final PersistentMRUListModel<String> recentClasspathsModel;
    private final Menu classpathsMenu;
    private final CallbackWithReason<ThemeTreeModel.CallbackReason> modelChangedCB;
    private final Runnable boundPropertyCB;
    private final EnumModel<Layout> layoutModel;
    private DelayedAction updatePropertyEditors;
    private Timer checkWidgetTreeTimer;
    private Context ctx;
    private PropertyPanel propertyPanel;
    private RectProperty boundRectProperty;
    private ColorProperty boundColorProperty;
    private SplitProperty boundSplitXProperty;
    private SplitProperty boundSplitYProperty;

    public EditorArea(MessageLog messageLog) {
        this.messageLog = messageLog;
        this.progressDialog = new ProgressDialog(this);
        this.progressDialog.setTheme("/progressdialog");
        this.testWidgetManager = new TestWidgetManager(messageLog);
        this.testWidgetMenu = new Menu("Widgets");
        this.themeTreePane = new ThemeTreePane(messageLog);
        this.themeTreePane.setTheme("/themetreepane");
        this.previewWidget = new PreviewWidget(messageLog);
        this.previewWidget.setTheme("/previewwidget");
        this.textureViewerPane = new TextureViewerPane();
        this.textureViewerPane.setTheme("/textureviewerpane");
        this.propertiesScrollPane = new ScrollPane();
        this.propertiesScrollPane.setTheme("/propertyEditor");
        this.propertiesScrollPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.widgetTreeModel = new WidgetTreeModel();
        this.widgetTree = new WidgetTree(this.widgetTreeModel, this.previewWidget);
        this.widgetTree.setTheme("/widgetTree");
        this.widgetPropertyEditor = new WidgetPropertyEditor();
        this.widgetPropertyEditor.setTheme("/propertyEditor");
        this.prefs = Preferences.userNodeForPackage(EditorArea.class);
        this.recentClasspathsModel = new PersistentMRUListModel(5, String.class, this.prefs, KEY_RECENT_CLASSPATHS);
        this.classpathsMenu = new Menu("User widgets");
        this.layoutModel = new PersistentEnumModel(this.prefs, KEY_LAYOUT, (Enum)Layout.SPLIT_HV);
        this.layoutModel.addCallback(new Runnable(){

            public void run() {
                EditorArea.this.recreateLayout();
            }
        });
        this.themeTreePane.setFocusNameFieldCB(new Runnable(){

            public void run() {
                EditorArea.this.focusNameField();
            }
        });
        this.previewWidget.setCallback(new PreviewWidget.Callback(){

            public void testWidgetChanged(Widget widget) {
                EditorArea.this.updateTestWidget(widget);
            }

            public void errorLocationChanged(Object object) {
                EditorArea.this.updateErrorLocation(object);
            }

            public void testGUIChanged(GUI gUI) {
                EditorArea.this.updateTestGUI(gUI);
            }
        });
        this.modelChangedCB = new CallbackWithReason<ThemeTreeModel.CallbackReason>(){

            public void callback(ThemeTreeModel.CallbackReason callbackReason) {
                EditorArea.this.reloadTheme();
            }
        };
        this.boundPropertyCB = new Runnable(){

            public void run() {
                EditorArea.this.updateTextureViewerPane();
            }
        };
        this.widgetTree.addSelectionChangeListener(new Runnable(){

            public void run() {
                EditorArea.this.updateTestWidgetProperties();
            }
        });
        this.widgetTree.addReloadButtenCallback(new Runnable(){

            public void run() {
                EditorArea.this.reloadTestWidget();
            }
        });
        this.testWidgetManager.setProgressDialog(this.progressDialog);
        this.testWidgetManager.setCallback(new TestWidgetManager.Callback(){

            public void testWidgetChanged() {
                EditorArea.this.changeTestWidget();
            }

            public void newWidgetsLoaded() {
                EditorArea.this.updateTestWidgetMenu();
            }
        });
        this.textureViewerPane.setListener(new TextureViewerPane.Listener(){

            public void dragEdgeTop(int n) {
                if (EditorArea.this.boundRectProperty != null) {
                    Dimension dimension = EditorArea.this.boundRectProperty.getLimit();
                    Rect rect = EditorArea.this.boundRectProperty.getPropertyValue();
                    rect.set(rect.getX(), EditorArea.limit(n, 0, Math.min(dimension.getY(), rect.getBottom()) - 1), rect.getRight(), rect.getBottom());
                    EditorArea.this.boundRectProperty.setPropertyValue(rect);
                }
            }

            public void dragEdgeBottom(int n) {
                if (EditorArea.this.boundRectProperty != null) {
                    Dimension dimension = EditorArea.this.boundRectProperty.getLimit();
                    Rect rect = EditorArea.this.boundRectProperty.getPropertyValue();
                    rect.set(rect.getX(), rect.getY(), rect.getRight(), EditorArea.limit(n, Math.max(0, rect.getY()) + 1, dimension.getY()));
                    EditorArea.this.boundRectProperty.setPropertyValue(rect);
                }
            }

            public void dragEdgeLeft(int n) {
                if (EditorArea.this.boundRectProperty != null) {
                    Dimension dimension = EditorArea.this.boundRectProperty.getLimit();
                    Rect rect = EditorArea.this.boundRectProperty.getPropertyValue();
                    rect.set(EditorArea.limit(n, 0, Math.min(dimension.getX(), rect.getRight()) - 1), rect.getY(), rect.getRight(), rect.getBottom());
                    EditorArea.this.boundRectProperty.setPropertyValue(rect);
                }
            }

            public void dragEdgeRight(int n) {
                if (EditorArea.this.boundRectProperty != null) {
                    Dimension dimension = EditorArea.this.boundRectProperty.getLimit();
                    Rect rect = EditorArea.this.boundRectProperty.getPropertyValue();
                    rect.set(rect.getX(), rect.getY(), EditorArea.limit(n, Math.max(0, rect.getX()) + 1, dimension.getX()), rect.getBottom());
                    EditorArea.this.boundRectProperty.setPropertyValue(rect);
                }
            }

            public void dragSplitX(int n, int n2) {
                EditorArea.this.dragSplit(n, n2, EditorArea.this.boundSplitXProperty, true);
            }

            public void dragSplitY(int n, int n2) {
                EditorArea.this.dragSplit(n, n2, EditorArea.this.boundSplitYProperty, false);
            }
        });
        this.textureViewerPane.setTextureLoadedListener(new TextureViewer.TextureLoadedListener(){

            public void textureLoaded(URL uRL, Texture texture) {
                EditorArea.this.textureLoaded(uRL, texture);
            }
        });
        this.recreateLayout();
        this.updateRecentClasspathsMenu();
        this.updateTestWidgetMenu();
        this.changeTestWidget();
    }

    public void setModel(ThemeTreeModel themeTreeModel) {
        if (this.ctx != null) {
            this.ctx.getThemeTreeModel().removeCallbacks(this.modelChangedCB);
        }
        if (themeTreeModel == null) {
            this.ctx = null;
            this.previewWidget.setURL(null, null);
        } else {
            this.ctx = new Context(this.messageLog, themeTreeModel);
            this.ctx.setThemeTreePane(this.themeTreePane);
            themeTreeModel.addCallback(this.modelChangedCB);
            try {
                this.previewWidget.setURL(this.ctx, themeTreeModel.getRootThemeFile().getVirtualURL());
            }
            catch (MalformedURLException malformedURLException) {
                this.previewWidget.setURL(null, null);
            }
        }
        this.textureViewerPane.setUrl(null);
        this.propertiesScrollPane.setContent(null);
        this.themeTreePane.setModel(themeTreeModel);
        this.widgetPropertyEditor.setContext(this.ctx);
    }

    public EnumModel<Layout> getLayoutModel() {
        return this.layoutModel;
    }

    public BooleanModel getLayoutBooleanModel(Layout layout) {
        return new OptionEnumModel(this.layoutModel, (Enum)layout);
    }

    public void addMenus(Menu menu) {
        menu.add((MenuElement)this.testWidgetMenu);
    }

    public void addSettingsMenuItems(Menu menu) {
        this.textureViewerPane.addSettingsMenuItems(menu);
    }

    public void setDemoMode(boolean bl) {
        this.testWidgetManager.setDemoMode(bl);
    }

    public void reloadTheme() {
        this.ctx.getThemeTreeModel().setErrorLocation(null);
        this.previewWidget.reloadTheme();
    }

    void recreateLayout() {
        this.removeAllChildren();
        this.removeFromParent((Widget)this.themeTreePane);
        this.removeFromParent(this.previewWidget);
        this.removeFromParent((Widget)this.textureViewerPane);
        this.removeFromParent((Widget)this.propertiesScrollPane);
        this.removeFromParent((Widget)this.widgetPropertyEditor);
        this.removeFromParent((Widget)this.widgetTree);
        switch ((Layout)this.layoutModel.getValue()) {
            case SPLIT_HV: {
                SplitPane splitPane = new SplitPane();
                SplitPane splitPane2 = new SplitPane();
                SplitPane splitPane3 = new SplitPane();
                SplitPane splitPane4 = new SplitPane();
                SplitPane splitPane5 = new SplitPane();
                splitPane.setSplitPosition(300);
                splitPane.add((Widget)splitPane3);
                splitPane.add((Widget)splitPane2);
                splitPane2.setReverseSplitPosition(true);
                splitPane2.setSplitPosition(300);
                splitPane2.add((Widget)splitPane4);
                splitPane2.add((Widget)splitPane5);
                splitPane3.setDirection(SplitPane.Direction.VERTICAL);
                splitPane3.add((Widget)this.themeTreePane);
                splitPane3.add((Widget)this.propertiesScrollPane);
                splitPane4.setDirection(SplitPane.Direction.VERTICAL);
                splitPane4.add((Widget)this.textureViewerPane);
                splitPane4.add((Widget)this.previewWidget);
                splitPane5.setDirection(SplitPane.Direction.VERTICAL);
                splitPane5.add((Widget)this.widgetTree);
                splitPane5.add((Widget)this.widgetPropertyEditor);
                this.add((Widget)splitPane);
                break;
            }
            case SPLIT_HHV: {
                SplitPane splitPane = new SplitPane();
                SplitPane splitPane6 = new SplitPane();
                SplitPane splitPane7 = new SplitPane();
                SplitPane splitPane8 = new SplitPane();
                SplitPane splitPane9 = new SplitPane();
                splitPane.setSplitPosition(300);
                splitPane.add((Widget)this.themeTreePane);
                splitPane.add((Widget)splitPane6);
                splitPane6.setSplitPosition(300);
                splitPane6.add((Widget)this.propertiesScrollPane);
                splitPane6.add((Widget)splitPane7);
                splitPane7.setReverseSplitPosition(true);
                splitPane7.setSplitPosition(300);
                splitPane7.add((Widget)splitPane8);
                splitPane7.add((Widget)splitPane9);
                splitPane8.setDirection(SplitPane.Direction.VERTICAL);
                splitPane8.add((Widget)this.textureViewerPane);
                splitPane8.add((Widget)this.previewWidget);
                splitPane9.setDirection(SplitPane.Direction.VERTICAL);
                splitPane9.add((Widget)this.widgetTree);
                splitPane9.add((Widget)this.widgetPropertyEditor);
                this.add((Widget)splitPane);
                break;
            }
        }
    }

    void updateProperties() {
        Property<?>[] propertyArray;
        TreeTableNode treeTableNode;
        if (this.boundRectProperty != null) {
            this.boundRectProperty.removeValueChangedCallback(this.boundPropertyCB);
            this.boundRectProperty = null;
        }
        if (this.boundColorProperty != null) {
            this.boundColorProperty.removeCallback(this.boundPropertyCB);
            this.boundColorProperty = null;
        }
        if (this.boundSplitXProperty != null) {
            this.boundSplitXProperty.removeCallback(this.boundPropertyCB);
            this.boundSplitXProperty = null;
        }
        if (this.boundSplitYProperty != null) {
            this.boundSplitYProperty.removeCallback(this.boundPropertyCB);
            this.boundSplitYProperty = null;
        }
        if ((treeTableNode = this.themeTreePane.getSelected()) != null) {
            propertyArray = this.getImages(treeTableNode);
            try {
                this.textureViewerPane.setUrl(propertyArray != null ? propertyArray.getTextureURL() : null);
            }
            catch (MalformedURLException malformedURLException) {
                this.textureViewerPane.setUrl(null);
            }
        }
        if (treeTableNode instanceof HasProperties) {
            propertyArray = ((HasProperties)treeTableNode).getProperties();
            this.propertyPanel = new PropertyPanel((PropertyFactories)this.ctx, propertyArray);
            for (Property<?> property : propertyArray) {
                if (this.boundRectProperty == null && property instanceof RectProperty) {
                    this.boundRectProperty = (RectProperty)property;
                    this.boundRectProperty.addValueChangedCallback(this.boundPropertyCB);
                }
                if (this.boundColorProperty == null && property instanceof ColorProperty) {
                    this.boundColorProperty = (ColorProperty)property;
                    this.boundColorProperty.addValueChangedCallback(this.boundPropertyCB);
                }
                if (!(property instanceof SplitProperty)) continue;
                if (this.boundSplitXProperty == null && property.getName().startsWith("Split X")) {
                    this.boundSplitXProperty = (SplitProperty)property;
                    this.boundSplitXProperty.addValueChangedCallback(this.boundPropertyCB);
                }
                if (this.boundSplitYProperty != null || !property.getName().startsWith("Split Y")) continue;
                this.boundSplitYProperty = (SplitProperty)property;
                this.boundSplitYProperty.addValueChangedCallback(this.boundPropertyCB);
            }
        } else {
            this.propertyPanel = null;
        }
        this.propertiesScrollPane.setContent((Widget)this.propertyPanel);
        this.updateTextureViewerPane();
        this.textureViewerPane.scrollToRect();
    }

    void focusNameField() {
        PropertyAccessor<?, ?> propertyAccessor;
        if (this.propertyPanel != null && (propertyAccessor = this.propertyPanel.getPropertyAccessor("Name")) != null) {
            propertyAccessor.focusWidget();
        }
    }

    void checkWidgetTree() {
        if (this.ctx != null && this.ctx.checkLayoutValidated()) {
            this.widgetTreeModel.refreshTree();
        }
    }

    void updateTextureViewerPane() {
        Color color;
        if (this.boundRectProperty != null) {
            this.textureViewerPane.setRect(this.boundRectProperty.getPropertyValue());
        } else {
            color = null;
            TreeTableNode treeTableNode = this.themeTreePane.getSelected();
            if (treeTableNode instanceof de.matthiasmann.twlthemeeditor.datamodel.Image) {
                de.matthiasmann.twlthemeeditor.datamodel.Image image = (de.matthiasmann.twlthemeeditor.datamodel.Image)treeTableNode;
                String string = image.getName();
                while (string == null && image.getParent() instanceof de.matthiasmann.twlthemeeditor.datamodel.Image) {
                    image = (de.matthiasmann.twlthemeeditor.datamodel.Image)image.getParent();
                    string = image.getName();
                }
                if (string != null) {
                    color = this.previewWidget.getImage(string);
                }
            }
            if (color != null) {
                this.textureViewerPane.setImage((Image)color);
            } else {
                this.textureViewerPane.setRect(null);
            }
        }
        color = this.boundColorProperty != null ? this.boundColorProperty.getPropertyValue() : Color.WHITE;
        this.textureViewerPane.setTintColor(color != null ? color : Color.WHITE);
        this.textureViewerPane.setSplitPositionsX(EditorArea.getSplitPos(this.boundSplitXProperty));
        this.textureViewerPane.setSplitPositionsY(EditorArea.getSplitPos(this.boundSplitYProperty));
    }

    void textureLoaded(URL uRL, Texture texture) {
        Images images;
        TreeTableNode treeTableNode = this.themeTreePane.getSelected();
        if (treeTableNode != null && (images = this.getImages(treeTableNode)) != null) {
            images.updateTextureDimension(uRL, texture.getWidth(), texture.getHeight());
        }
    }

    private static int[] getSplitPos(SplitProperty splitProperty) {
        Split split;
        if (splitProperty != null && (split = splitProperty.getPropertyValue()) != null) {
            int n = splitProperty.getLimit();
            return new int[]{split.getPoint1().convertToPX(n), split.getPoint2().convertToPX(n)};
        }
        return null;
    }

    static int limit(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n, n3));
    }

    void dragSplit(int n, int n2, SplitProperty splitProperty, boolean bl) {
        Split split = splitProperty.getPropertyValue();
        if (split != null) {
            int n3 = splitProperty.getLimit();
            Split.Point point = split.getPoint1();
            Split.Point point2 = split.getPoint2();
            switch (n) {
                case 0: {
                    n2 = EditorArea.limit(n2, 0, point2.convertToPX(n3));
                    point = point.movePX(n2 - point.convertToPX(n3));
                    break;
                }
                case 1: {
                    n2 = EditorArea.limit(n2, point.convertToPX(n3), n3);
                    point2 = point2.movePX(n2 - point2.convertToPX(n3));
                }
            }
            splitProperty.setPropertyValue(new Split(point, point2));
        }
    }

    void updateErrorLocation(Object object) {
        if (this.ctx != null) {
            if (object instanceof ThemeTreeNode) {
                this.ctx.getThemeTreeModel().setErrorLocation((ThemeTreeNode)((Object)object));
            } else {
                this.ctx.getThemeTreeModel().setErrorLocation(null);
            }
        }
    }

    void updateTestGUI(GUI gUI) {
        this.widgetTree.setTestGUI(this.ctx, gUI);
    }

    void updateTestWidget(Widget widget) {
        this.widgetPropertyEditor.setWidget(widget);
    }

    void updateTestWidgetProperties() {
        Widget widget = this.widgetTree.getSelectedWidget();
        this.widgetPropertyEditor.setWidget(widget);
    }

    void reloadTestWidget() {
        this.testWidgetManager.reloadCurrentWidget();
    }

    void changeTestWidget() {
        this.previewWidget.setWidgetFactory(this.testWidgetManager.getCurrentTestWidgetFactory());
    }

    void recreateTestWidgets() {
        this.testWidgetManager.clearCache();
        this.changeTestWidget();
    }

    void loadClasspath() {
        LoadFileSelector loadFileSelector = new LoadFileSelector((Widget)this, this.prefs, KEY_CLASSPATH_FS, "TWL Theme Editor classpath file", ".classpath", new LoadFileSelector.Callback(){

            public void fileSelected(File file) {
                EditorArea.this.loadClasspath(file);
            }

            public void canceled() {
            }
        });
        loadFileSelector.openPopup();
    }

    void createClasspath() {
        NewClasspathDialog newClasspathDialog = new NewClasspathDialog(this, new NewClasspathDialog.Callback(){

            public void classpathCreated(File file) {
                EditorArea.this.loadClasspath(file);
            }
        });
        newClasspathDialog.openPopup();
    }

    void loadClasspath(File file) {
        if (this.testWidgetManager.loadUserWidgets(file)) {
            this.recentClasspathsModel.addEntry((Serializable)((Object)file.toString()));
            this.updateRecentClasspathsMenu();
        } else {
            int n = Utils.find(this.recentClasspathsModel, file.toString());
            if (n >= 0) {
                this.recentClasspathsModel.removeEntry(n);
                this.updateRecentClasspathsMenu();
            }
        }
    }

    void updateRecentClasspathsMenu() {
        MenuAction menuAction = new MenuAction("Load classpath...", new Runnable(){

            public void run() {
                EditorArea.this.loadClasspath();
            }
        });
        menuAction.setTooltipContent((Object)"Load Widgets from an existing classpath file");
        MenuAction menuAction2 = new MenuAction("New classpath...", new Runnable(){

            public void run() {
                EditorArea.this.createClasspath();
            }
        });
        menuAction2.setTooltipContent((Object)"Create a new classpath file containing your Widgets");
        this.classpathsMenu.clear();
        this.classpathsMenu.add((MenuElement)menuAction);
        this.classpathsMenu.add((MenuElement)menuAction2);
        int n = this.recentClasspathsModel.getNumEntries();
        if (n > 0) {
            this.classpathsMenu.addSpacer();
            for (int i = 0; i < n; ++i) {
                final String string = (String)this.recentClasspathsModel.getEntry(i);
                this.classpathsMenu.add(string, new Runnable(){

                    public void run() {
                        EditorArea.this.loadClasspath(new File(string));
                    }
                });
            }
        }
    }

    void updateTestWidgetMenu() {
        MenuAction menuAction = new MenuAction("Recreate widgets", new Runnable(){

            public void run() {
                EditorArea.this.recreateTestWidgets();
            }
        });
        menuAction.setTooltipContent((Object)"Clears widget cache and recreates current widget");
        this.testWidgetMenu.clear();
        this.testWidgetManager.updateMenu(this.testWidgetMenu);
        this.testWidgetMenu.addSpacer();
        this.testWidgetMenu.add((MenuElement)this.classpathsMenu);
        this.testWidgetMenu.add((MenuElement)menuAction);
    }

    private void removeFromParent(Widget widget) {
        if (widget.getParent() != null) {
            widget.getParent().removeChild(widget);
        }
    }

    private Images getImages(Object object) {
        if (object instanceof Images) {
            return (Images)object;
        }
        if (object instanceof de.matthiasmann.twlthemeeditor.datamodel.Image) {
            return ((de.matthiasmann.twlthemeeditor.datamodel.Image)object).getTextures();
        }
        return null;
    }

    protected void layout() {
        this.layoutChildrenFullInnerArea();
    }

    protected void afterAddToGUI(GUI gUI) {
        super.afterAddToGUI(gUI);
        this.updatePropertyEditors = new DelayedAction(gUI, new Runnable(){

            public void run() {
                EditorArea.this.updateProperties();
            }
        });
        this.themeTreePane.addCallback(this.updatePropertyEditors);
        this.checkWidgetTreeTimer = gUI.createTimer();
        this.checkWidgetTreeTimer.setContinuous(true);
        this.checkWidgetTreeTimer.setDelay(250);
        this.checkWidgetTreeTimer.setCallback(new Runnable(){

            public void run() {
                EditorArea.this.checkWidgetTree();
            }
        });
        this.checkWidgetTreeTimer.start();
    }

    protected void beforeRemoveFromGUI(GUI gUI) {
        super.beforeRemoveFromGUI(gUI);
        this.checkWidgetTreeTimer.stop();
        this.checkWidgetTreeTimer = null;
        this.themeTreePane.removeCallback(this.updatePropertyEditors);
        this.updatePropertyEditors = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Layout {
        SPLIT_HV,
        SPLIT_HHV;

    }
}

