/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Clipboard;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.SplitPane;
import de.matthiasmann.twl.Table;
import de.matthiasmann.twl.TableBase;
import de.matthiasmann.twl.TableRowSelectionManager;
import de.matthiasmann.twl.TableSelectionManager;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.AbstractTableModel;
import de.matthiasmann.twl.model.HasCallback;
import de.matthiasmann.twl.model.TableSelectionModel;
import de.matthiasmann.twl.model.TableSingleSelectionModel;
import de.matthiasmann.twl.textarea.Style;
import de.matthiasmann.twl.textarea.StyleAttribute;
import de.matthiasmann.twl.textarea.TextAreaModel;
import de.matthiasmann.twlthemeeditor.datamodel.DecoratedText;
import de.matthiasmann.twlthemeeditor.gui.DecoratedTextRenderer;
import de.matthiasmann.twlthemeeditor.gui.MessageLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;

public class MessageDialog
extends DialogLayout {
    static final DateFormat TIME_FORMAT = DateFormat.getTimeInstance();
    private final MessageLog messageLog;
    private final TableModel tableModel;
    private final TableSelectionModel selectionModel;
    private final Table table;
    private final MessageTextAreaModel textModel;
    private final Button btnDiscard;
    private final Button btnClose;
    private final Button btnCopyToClipboard;
    private MessageLog.Entry[] entries;
    static final String[] TABLE_COLUMN_NAMES = new String[]{"Time", "Category", "Message"};
    private static final Style NORMAL = new Style();
    private static final Style PRE = NORMAL.with(StyleAttribute.PREFORMATTED, (Object)Boolean.TRUE);

    public MessageDialog(MessageLog messageLog, MessageLog.Entry entry) {
        this.messageLog = messageLog;
        this.entries = messageLog.getEntries();
        this.tableModel = new TableModel();
        this.selectionModel = new TableSingleSelectionModel();
        this.table = new Table((de.matthiasmann.twl.model.TableModel)this.tableModel);
        this.textModel = new MessageTextAreaModel();
        ScrollPane scrollPane = new ScrollPane((Widget)this.table);
        scrollPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        scrollPane.setExpandContentSize(true);
        TextArea textArea = new TextArea((TextAreaModel)this.textModel);
        ScrollPane scrollPane2 = new ScrollPane((Widget)textArea);
        scrollPane2.setFixed(ScrollPane.Fixed.HORIZONTAL);
        scrollPane2.setExpandContentSize(true);
        SplitPane splitPane = new SplitPane();
        splitPane.setDirection(SplitPane.Direction.VERTICAL);
        splitPane.add((Widget)scrollPane);
        splitPane.add((Widget)scrollPane2);
        this.btnDiscard = new Button("Discard message");
        this.btnClose = new Button("Close");
        this.btnCopyToClipboard = new Button("Copy to clipboard");
        this.btnDiscard.addCallback(new Runnable(){

            public void run() {
                MessageDialog.this.removeSelectedMsg();
            }
        });
        this.selectionModel.addSelectionChangeListener(new Runnable(){

            public void run() {
                MessageDialog.this.updateText();
            }
        });
        this.btnCopyToClipboard.addCallback(new Runnable(){

            public void run() {
                MessageDialog.this.copyToClipboard();
            }
        });
        DecoratedTextRenderer.install((TableBase)this.table);
        this.table.setSelectionManager((TableSelectionManager)new TableRowSelectionManager(this.selectionModel));
        this.setHorizontalGroup(this.createParallelGroup().addWidget((Widget)splitPane).addGroup(this.createSequentialGroup().addWidget((Widget)this.btnCopyToClipboard).addGap().addWidgets(new Widget[]{this.btnDiscard, this.btnClose})));
        this.setVerticalGroup(this.createSequentialGroup().addWidget((Widget)splitPane).addGroup(this.createParallelGroup().addWidgets(new Widget[]{this.btnCopyToClipboard, this.btnDiscard, this.btnClose})));
        this.updateText();
        this.setSelected(entry);
    }

    public void addCloseCallback(Runnable runnable) {
        this.btnClose.addCallback(runnable);
    }

    void updateText() {
        MessageLog.Entry entry = this.getSelectedEntry();
        if (entry != null) {
            this.textModel.set(entry.getDetailText(), entry.getDetailException());
            this.btnDiscard.setEnabled(true);
            this.btnCopyToClipboard.setEnabled(true);
        } else {
            this.textModel.clear();
            this.btnDiscard.setEnabled(false);
            this.btnCopyToClipboard.setEnabled(false);
        }
    }

    void removeSelectedMsg() {
        MessageLog.Entry entry = this.getSelectedEntry();
        if (entry != null) {
            this.messageLog.remove(entry);
            this.entries = this.messageLog.getEntries();
            if (this.entries.length == 0) {
                this.btnClose.getModel().fireActionCallback();
            }
            this.tableModel.updateTable();
            this.setSelected(null);
        }
    }

    void copyToClipboard() {
        MessageLog.Entry entry = this.getSelectedEntry();
        if (entry != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.print("Time: ");
            printWriter.println(TIME_FORMAT.format(entry.getTime()));
            printWriter.print("Category: ");
            printWriter.println(entry.getCategory());
            printWriter.print("Title: ");
            printWriter.println(entry.getMessage());
            if (entry.getDetailText() != null) {
                printWriter.println();
                printWriter.println(entry.getDetailText());
            }
            if (entry.getDetailException() != null) {
                printWriter.println();
                entry.getDetailException().printStackTrace(printWriter);
            }
            printWriter.flush();
            Clipboard.setClipboard((String)stringWriter.toString());
        }
    }

    private MessageLog.Entry getSelectedEntry() {
        int n = this.selectionModel.getFirstSelected();
        return n < 0 ? null : this.entries[n];
    }

    private void setSelected(MessageLog.Entry entry) {
        int n = this.entries.length - 1;
        int n2 = this.entries.length;
        for (int i = 0; i < n2; ++i) {
            if (this.entries[i] != entry) continue;
            n = i;
            break;
        }
        this.selectionModel.setSelection(n, n);
        this.table.scrollToRow(n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MessageTextAreaModel
    extends HasCallback
    implements TextAreaModel {
        private final ArrayList<TextAreaModel.Element> elements = new ArrayList(2);

        MessageTextAreaModel() {
        }

        public void set(String string, Throwable throwable) {
            this.elements.clear();
            if (string != null && string.length() > 0) {
                this.elements.add((TextAreaModel.Element)new TextAreaModel.TextElement(NORMAL, string));
            }
            if (throwable != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                this.elements.add((TextAreaModel.Element)new TextAreaModel.TextElement(PRE, stringWriter.toString()));
            }
            this.doCallback();
        }

        public void clear() {
            this.elements.clear();
            this.doCallback();
        }

        public Iterator<TextAreaModel.Element> iterator() {
            return this.elements.iterator();
        }
    }

    class TableModel
    extends AbstractTableModel {
        TableModel() {
        }

        public int getNumColumns() {
            return TABLE_COLUMN_NAMES.length;
        }

        public String getColumnHeaderText(int n) {
            return TABLE_COLUMN_NAMES[n];
        }

        public int getNumRows() {
            return MessageDialog.this.entries.length;
        }

        public Object getCell(int n, int n2) {
            String string;
            MessageLog.Entry entry = MessageDialog.this.entries[n];
            switch (n2) {
                case 0: {
                    string = TIME_FORMAT.format(entry.getTime());
                    break;
                }
                case 1: {
                    string = entry.getCategory().toString();
                    break;
                }
                case 2: {
                    string = entry.getMessage();
                    break;
                }
                default: {
                    string = "";
                }
            }
            return DecoratedText.apply(string, entry.getCategory().getFlags());
        }

        void updateTable() {
            this.fireAllChanged();
        }
    }
}

