/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.utils.CallbackSupport;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class MessageLog {
    private static final int MAX_LOG_SIZE = 100;
    private final ArrayList<Entry> entries = new ArrayList();
    private GUI gui;
    private Runnable[] callbacks;
    private boolean callbackPending;

    public synchronized void add(Entry entry) {
        switch (entry.getCategory().getCombineMode()) {
            case REPLACE: {
                this.removeAllImpl(entry.getCategory());
            }
        }
        if (this.entries.size() >= 99) {
            this.entries.remove(0);
        }
        this.entries.add(entry);
        this.fireCallback();
    }

    public synchronized void remove(Entry entry) {
        if (this.entries.remove(entry)) {
            this.fireCallback();
        }
    }

    public synchronized void removeAll(Category category) {
        if (this.removeAllImpl(category)) {
            this.fireCallback();
        }
    }

    public synchronized Entry[] getEntries() {
        return this.entries.toArray(new Entry[this.entries.size()]);
    }

    public synchronized Entry getLatestMessage() {
        if (this.entries.isEmpty()) {
            return null;
        }
        return this.entries.get(this.entries.size() - 1);
    }

    public synchronized void setGUI(GUI gUI) {
        this.gui = gUI;
        if (this.callbackPending) {
            this.fireCallback();
        }
    }

    public void addCallback(Runnable runnable) {
        this.callbacks = (Runnable[])CallbackSupport.addCallbackToList((Object[])this.callbacks, (Object)runnable, Runnable.class);
    }

    public void removeCallback(Runnable runnable) {
        this.callbacks = (Runnable[])CallbackSupport.removeCallbackFromList((Object[])this.callbacks, (Object)runnable);
    }

    private boolean removeAllImpl(Category category) {
        boolean bl = false;
        Iterator<Entry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (entry.getCategory() != category) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    private void fireCallback() {
        if (!this.callbackPending) {
            this.callbackPending = true;
            if (this.gui != null) {
                this.gui.invokeLater(new Runnable(){

                    public void run() {
                        MessageLog.this.executeCallbacks();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeCallbacks() {
        MessageLog messageLog = this;
        synchronized (messageLog) {
            this.callbackPending = false;
        }
        CallbackSupport.fireCallbacks((Runnable[])this.callbacks);
    }

    public static class Category {
        private final String name;
        private final CombineMode combineMode;
        private final int flags;

        public Category(String string, CombineMode combineMode, int n) {
            this.name = string;
            this.combineMode = combineMode;
            this.flags = n;
        }

        public String toString() {
            return this.name;
        }

        public CombineMode getCombineMode() {
            return this.combineMode;
        }

        public int getFlags() {
            return this.flags;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CombineMode {
        NONE,
        REPLACE;

    }

    public static class Entry {
        private final long time;
        private final Category category;
        private final String msg;
        private final String detailText;
        private final Throwable detailException;
        private final EntryAction[] actions;

        public Entry(Category category, String string, String string2, Throwable throwable, EntryAction ... entryActionArray) {
            if (category == null) {
                throw new NullPointerException("category");
            }
            if (string == null) {
                throw new NullPointerException("msg");
            }
            this.time = System.currentTimeMillis();
            this.category = category;
            this.msg = string;
            this.detailText = string2;
            this.detailException = throwable;
            this.actions = entryActionArray;
        }

        public EntryAction[] getActions() {
            return (EntryAction[])this.actions.clone();
        }

        public Category getCategory() {
            return this.category;
        }

        public Throwable getDetailException() {
            return this.detailException;
        }

        public String getDetailText() {
            return this.detailText;
        }

        public String getMessage() {
            return this.msg;
        }

        public Date getTime() {
            return new Date(this.time);
        }
    }

    public static abstract class EntryAction
    implements Runnable {
        private final String name;

        public EntryAction(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }
}

