/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.CallbackWithReason;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.EditFieldAutoCompletionWindow;
import de.matthiasmann.twl.FileSelector;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ListBox;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.TreeComboBox;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.AutoCompletionDataSource;
import de.matthiasmann.twl.model.FileSystemAutoCompletionDataSource;
import de.matthiasmann.twl.model.FileSystemModel;
import de.matthiasmann.twl.model.FileSystemTreeModel;
import de.matthiasmann.twl.model.MRUListModel;
import de.matthiasmann.twl.model.PersistentMRUListModel;
import de.matthiasmann.twl.model.SimpleMRUListModel;
import de.matthiasmann.twl.model.TreeTableModel;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twlthemeeditor.gui.NewProjectSettings;
import java.io.File;
import java.util.Comparator;
import java.util.prefs.Preferences;

public class NewProjectDialog
extends DialogLayout {
    public static final AnimationState.StateKey STATE_ERROR = AnimationState.StateKey.get((String)"error");
    public static final AnimationState.StateKey STATE_WARNING = AnimationState.StateKey.get((String)"warning");
    private final Listener listener;
    private final FileSystemModel fsm;
    private final FileSystemTreeModel model;
    private final MRUListModel<String> folderMRU;
    private final TreeComboBox currentFolder;
    private final Button btnFolderMRU;
    private final EditField efProjectName;
    private final Label labelInfo;
    private final Button btnOk;
    private final Button btnCancel;
    private final EditFieldAutoCompletionWindow autoCompletion;
    private NewProjectSettings settings;

    public NewProjectDialog(FileSystemModel fileSystemModel, Preferences preferences, String string, Listener listener) {
        this.listener = listener;
        this.fsm = fileSystemModel;
        this.model = new FileSystemTreeModel(fileSystemModel);
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (preferences == null != (string == null)) {
            throw new IllegalArgumentException("'prefs' and 'prefsKey' must both be valid or both null");
        }
        this.folderMRU = preferences != null ? new PersistentMRUListModel(10, String.class, preferences, string.concat("_foldersMRU")) : new SimpleMRUListModel(10);
        this.model.setSorter((Comparator)new FileSelector.NameSorter(fileSystemModel));
        this.currentFolder = new TreeComboBox();
        this.currentFolder.setTheme("currentFolder");
        this.btnFolderMRU = new Button();
        this.btnFolderMRU.setTheme("buttonFoldersMRU");
        this.btnFolderMRU.addCallback(new Runnable(){

            public void run() {
                NewProjectDialog.this.showFolderMRU();
            }
        });
        this.efProjectName = new EditField();
        this.efProjectName.setTheme("editfieldProjectName");
        this.efProjectName.addCallback(new EditField.Callback(){

            public void callback(int n) {
                NewProjectDialog.this.handleEditFieldKey(n);
            }
        });
        this.labelInfo = new Label();
        this.labelInfo.setTheme("labelInfo");
        this.btnOk = new Button();
        this.btnOk.setTheme("buttonOk");
        this.btnOk.setEnabled(false);
        this.btnOk.addCallback(new Runnable(){

            public void run() {
                NewProjectDialog.this.acceptSelection();
            }
        });
        this.btnCancel = new Button();
        this.btnCancel.setTheme("buttonCancel");
        this.btnCancel.addCallback(new Runnable(){

            public void run() {
                NewProjectDialog.this.canceled();
            }
        });
        this.autoCompletion = new EditFieldAutoCompletionWindow(this.currentFolder.getEditField());
        this.autoCompletion.setUseInvokeAsync(true);
        this.autoCompletion.setDataSource((AutoCompletionDataSource)new FileSystemAutoCompletionDataSource(fileSystemModel, (FileSystemModel.FileFilter)FileSystemTreeModel.FolderFilter.instance));
        this.currentFolder.setPathResolver(new TreeComboBox.PathResolver(){

            public TreeTableNode resolvePath(TreeTableModel treeTableModel, String string) throws IllegalArgumentException {
                return NewProjectDialog.this.resolvePath(string);
            }
        });
        this.currentFolder.addCallback(new TreeComboBox.Callback(){

            public void selectedNodeChanged(TreeTableNode treeTableNode, TreeTableNode treeTableNode2) {
                NewProjectDialog.this.checkProjectSettings();
                NewProjectDialog.this.setCurrentNode(treeTableNode);
            }
        });
        this.currentFolder.setModel((TreeTableModel)this.model);
        this.currentFolder.setSeparator(fileSystemModel.getSeparator());
        this.currentFolder.getEditField().setAutoCompletionWindow(this.autoCompletion);
        Label label = new Label("Folder");
        label.setLabelFor((Widget)this.currentFolder);
        Label label2 = new Label("Project Name");
        label2.setLabelFor((Widget)this.efProjectName);
        this.add((Widget)label);
        this.add((Widget)this.currentFolder);
        this.add((Widget)this.btnFolderMRU);
        this.add((Widget)this.efProjectName);
        this.add((Widget)this.btnOk);
        this.add((Widget)this.btnCancel);
        DialogLayout.Group group = this.createSequentialGroup().addWidget((Widget)this.currentFolder).addWidget((Widget)this.btnFolderMRU);
        DialogLayout.Group group2 = this.createParallelGroup().addWidget((Widget)label).addWidget((Widget)this.currentFolder).addWidget((Widget)this.btnFolderMRU);
        DialogLayout.Group group3 = this.createParallelGroup().addWidget((Widget)label).addWidget((Widget)label2);
        DialogLayout.Group group4 = this.createParallelGroup().addGroup(group).addWidget((Widget)this.efProjectName);
        DialogLayout.Group group5 = this.createSequentialGroup(new DialogLayout.Group[]{group3, group4});
        DialogLayout.Group group6 = this.createSequentialGroup().addGroup(group2).addGroup(this.createParallelGroup(new Widget[]{label2, this.efProjectName}));
        DialogLayout.Group group7 = this.createSequentialGroup().addGap("buttonBarLeft").addWidget((Widget)this.btnOk).addGap("buttonBarSpacer").addWidget((Widget)this.btnCancel).addGap("buttonBarRight");
        DialogLayout.Group group8 = this.createParallelGroup().addWidget((Widget)this.btnOk).addWidget((Widget)this.btnCancel);
        this.setHorizontalGroup(this.createParallelGroup().addGroup(group5).addWidget((Widget)this.labelInfo).addGroup(group7));
        this.setVerticalGroup(this.createSequentialGroup().addGroup(group6).addGap("settings-info").addWidget((Widget)this.labelInfo).addGroup(group8));
        this.setCurrentNode((TreeTableNode)this.model);
        if (this.folderMRU.getNumEntries() > 0) {
            this.gotoFolderFromMRU(0);
        }
        this.checkProjectSettings();
    }

    final void setCurrentNode(TreeTableNode treeTableNode) {
        this.currentFolder.setCurrentNode(treeTableNode);
    }

    public Object getCurrentFolder() {
        TreeTableNode treeTableNode = this.currentFolder.getCurrentNode();
        if (treeTableNode instanceof FileSystemTreeModel.FolderNode) {
            return ((FileSystemTreeModel.FolderNode)treeTableNode).getFolder();
        }
        return null;
    }

    TreeTableNode resolvePath(String string) throws IllegalArgumentException {
        FileSystemTreeModel.FolderNode folderNode;
        Object object = this.fsm.getFile(string);
        if (object != null && (folderNode = this.model.getNodeForFolder(object)) != null) {
            return folderNode;
        }
        throw new IllegalArgumentException("Could not resolve: " + string);
    }

    void showFolderMRU() {
        final PopupWindow popupWindow = new PopupWindow((Widget)this);
        final ListBox listBox = new ListBox(this.folderMRU);
        popupWindow.setTheme("fileselector-folderMRUpopup");
        popupWindow.add((Widget)listBox);
        if (popupWindow.openPopup()) {
            popupWindow.setInnerSize(this.getInnerWidth() * 2 / 3, this.getInnerHeight() * 2 / 3);
            popupWindow.setPosition(this.btnFolderMRU.getX() - popupWindow.getWidth(), this.btnFolderMRU.getY());
            listBox.addCallback((CallbackWithReason)new CallbackWithReason<ListBox.CallbackReason>(){

                public void callback(ListBox.CallbackReason callbackReason) {
                    if (callbackReason.actionRequested()) {
                        popupWindow.closePopup();
                        int n = listBox.getSelected();
                        if (n >= 0) {
                            NewProjectDialog.this.gotoFolderFromMRU(n);
                        }
                    }
                }
            });
        }
    }

    final void gotoFolderFromMRU(int n) {
        String string = (String)this.folderMRU.getEntry(n);
        try {
            TreeTableNode treeTableNode = this.resolvePath(string);
            this.setCurrentNode(treeTableNode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.folderMRU.removeEntry(n);
        }
    }

    void acceptSelection() {
        if (this.settings != null) {
            this.folderMRU.addEntry((Object)this.settings.getFolder().getPath());
            this.listener.ok(this.settings);
        }
    }

    void canceled() {
        this.listener.canceled();
    }

    void handleEditFieldKey(int n) {
        if (n == 1) {
            this.canceled();
        } else {
            this.checkProjectSettings();
            if (n == 28 && this.btnOk.isEnabled()) {
                this.acceptSelection();
            }
        }
    }

    private boolean checkProjectName(String string) {
        int n = 46;
        int n2 = string.length() - 4;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '.' ? n == 46 : !Character.isLetterOrDigit(c) && c != '_' && c != '-') {
                return false;
            }
            n = c;
        }
        return n != 46;
    }

    private void setMessage(String string) {
        this.labelInfo.setText(string);
        this.labelInfo.getAnimationState().setAnimationState(STATE_ERROR, this.settings == null);
        this.labelInfo.getAnimationState().setAnimationState(STATE_WARNING, string.length() > 0);
        this.btnOk.setEnabled(this.settings != null);
    }

    final void checkProjectSettings() {
        this.settings = null;
        Object object = this.getCurrentFolder();
        if (!(object instanceof File)) {
            this.setMessage("Selected folder is not usable");
            return;
        }
        if (!((File)object).canWrite()) {
            this.setMessage("Selected folder is write protected");
            return;
        }
        String string = this.efProjectName.getText();
        if (string.length() == 0) {
            this.setMessage("Project name required");
            return;
        }
        if (!string.toLowerCase().endsWith(".xml")) {
            string = string.concat(".xml");
        }
        if (!this.checkProjectName(string)) {
            this.setMessage("Invalid project name. Must only contain alpha numeric characters, '-', '_' and single '.'");
            return;
        }
        this.settings = new NewProjectSettings((File)object, string);
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : this.settings.getFileList()) {
            if (!file.exists()) continue;
            if (stringBuilder.length() == 0) {
                stringBuilder.append("The following files already exist and will be overwritten:");
            }
            stringBuilder.append("\n").append(file.getName());
        }
        this.setMessage(stringBuilder.toString());
    }

    public static interface Listener {
        public void ok(NewProjectSettings var1);

        public void canceled();
    }
}

