/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.DebugHook;
import de.matthiasmann.twl.ParameterMap;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreviewDebugHook
extends DebugHook {
    private final IdentityHashMap<Widget, Entry> messages = new IdentityHashMap();
    private Widget applyThemeWidget;
    private DebugHook previous;
    private boolean layoutValidated;

    public void beforeApplyTheme(Widget widget) {
        this.applyThemeWidget = widget;
        this.messages.remove(this.applyThemeWidget);
    }

    public void afterApplyTheme(Widget widget) {
        this.applyThemeWidget = null;
    }

    public void missingTheme(String string) {
        if (this.applyThemeWidget != null) {
            this.getEntryOrCreate((Widget)this.applyThemeWidget).errorMsg.add("Missing theme: " + string);
        }
    }

    public void missingChildTheme(ThemeInfo themeInfo, String string) {
        if (this.applyThemeWidget != null) {
            this.getEntryOrCreate((Widget)this.applyThemeWidget).errorMsg.add("Missing theme: " + string);
        }
    }

    public void missingParameter(ParameterMap parameterMap, String string, String string2, Class<?> clazz) {
        if (this.applyThemeWidget != null) {
            StringBuilder stringBuilder = new StringBuilder("Missing ");
            if (clazz != null) {
                if (clazz == Integer.class) {
                    stringBuilder.append("int");
                } else if (clazz == Float.class) {
                    stringBuilder.append("float");
                } else if (clazz == Boolean.class) {
                    stringBuilder.append("boolean");
                } else if (clazz != null) {
                    stringBuilder.append(clazz.getSimpleName());
                }
                stringBuilder.append(' ');
            }
            stringBuilder.append("parameter: ").append(string).append(string2);
            this.getEntryOrCreate((Widget)this.applyThemeWidget).warningMsg.add(stringBuilder.toString());
        }
    }

    public void wrongParameterType(ParameterMap parameterMap, String string, Class<?> clazz, Class<?> clazz2, String string2) {
        if (this.applyThemeWidget != null) {
            this.getEntryOrCreate((Widget)this.applyThemeWidget).warningMsg.add("Parameter \"" + string + "\" is a " + clazz2.getSimpleName() + " expected a " + clazz.getSimpleName() + string2);
        }
    }

    private Entry getEntryOrCreate(Widget widget) {
        Entry entry = this.messages.get(widget);
        if (entry == null) {
            entry = new Entry(widget);
            this.messages.put(widget, entry);
        }
        return entry;
    }

    public Entry getEntry(Widget widget) {
        return this.messages.get(widget);
    }

    public boolean checkLayoutValidated() {
        boolean bl = this.layoutValidated;
        this.layoutValidated = false;
        return bl;
    }

    public void clear() {
        this.messages.clear();
    }

    public void guiLayoutValidated(int n, Collection<Widget> collection) {
        super.guiLayoutValidated(n, collection);
        this.layoutValidated = true;
    }

    public void install() {
        if (this.previous != null) {
            throw new IllegalStateException("Already installed");
        }
        this.previous = DebugHook.installHook((DebugHook)this);
    }

    public void uninstall() {
        if (this.previous == null) {
            throw new IllegalStateException("Not installed");
        }
        DebugHook.installHook((DebugHook)this.previous);
        this.previous = null;
        this.applyThemeWidget = null;
    }

    public static class Entry {
        public final Widget widget;
        final ArrayList<String> errorMsg;
        final ArrayList<String> warningMsg;

        public Entry(Widget widget) {
            this.widget = widget;
            this.errorMsg = new ArrayList();
            this.warningMsg = new ArrayList();
        }
    }
}

