/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.Alignment;
import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeOperation;
import de.matthiasmann.twlthemeeditor.gui.LoadFileSelector;
import java.io.File;
import java.net.URI;
import java.util.prefs.Preferences;

public class QueryOperationParameter
extends DialogLayout {
    final File startDir;
    Object[] results;

    public QueryOperationParameter(File file) {
        this.startDir = file;
    }

    public Object[] getResults() {
        return (Object[])this.results.clone();
    }

    public void setParameter(ThemeTreeOperation.Parameter ... parameterArray) {
        this.setHorizontalGroup(null);
        this.setVerticalGroup(null);
        super.removeAllChildren();
        this.results = new Object[parameterArray.length];
        DialogLayout.Group group = this.createParallelGroup();
        DialogLayout.Group group2 = this.createParallelGroup();
        DialogLayout.Group group3 = this.createSequentialGroup();
        int n = parameterArray.length;
        for (int i = 0; i < n; ++i) {
            ThemeTreeOperation.Parameter parameter = parameterArray[i];
            Label label = new Label(parameter.name);
            DialogLayout.Group group4 = this.createParallelGroup().addWidget((Widget)label, Alignment.TOPLEFT);
            switch (parameter.type) {
                case FILE_SELECTOR: {
                    this.addFileSelector(group2, group4, i, (ThemeTreeOperation.FileParameter)parameter);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            group3.addGroup(group4);
            group.addWidget((Widget)label);
        }
        this.setHorizontalGroup(this.createSequentialGroup().addGroup(group).addGroup(group2));
        this.setVerticalGroup(group3);
    }

    private void addFileSelector(DialogLayout.Group group, DialogLayout.Group group2, final int n, ThemeTreeOperation.FileParameter fileParameter) {
        final EditField editField = new EditField();
        Button button = new Button();
        final LoadFileSelector loadFileSelector = new LoadFileSelector((Widget)this, Preferences.userNodeForPackage(QueryOperationParameter.class), "fileSelector_".concat(fileParameter.name.replace(' ', '_')), fileParameter.name, fileParameter.fileFilter, new LoadFileSelector.Callback(){

            public void fileSelected(File file) {
                URI uRI = file.toURI();
                if (QueryOperationParameter.this.startDir != null) {
                    uRI = QueryOperationParameter.this.startDir.toURI().relativize(uRI);
                }
                String string = uRI.getPath();
                QueryOperationParameter.this.results[n] = string;
                editField.setText(string);
            }

            public void canceled() {
            }
        });
        editField.setTheme("filename");
        editField.setReadOnly(true);
        button.setTheme("selectFile");
        button.addCallback(new Runnable(){

            public void run() {
                loadFileSelector.openPopup();
            }
        });
        group.addGroup(this.createSequentialGroup().addWidget((Widget)editField).addWidget((Widget)button));
        group2.addWidget((Widget)editField).addWidget((Widget)button);
    }
}

