/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.FileSelector;
import de.matthiasmann.twl.FileTable;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.FileSystemModel;
import de.matthiasmann.twl.model.JavaFileSystemModel;
import de.matthiasmann.twlthemeeditor.gui.MainUI;
import java.io.File;
import java.util.prefs.Preferences;

public class SaveFileSelector {
    final EditField editField;
    final FileSelector fileSelector;
    final PopupWindow popupWindow;
    final Callback callback;
    final String extension;

    public SaveFileSelector(Widget widget, Preferences preferences, String string, String string2, String string3, Callback callback) {
        this.callback = callback;
        this.extension = string3;
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        CB cB = new CB();
        this.editField = new EditField();
        this.editField.addCallback((EditField.Callback)cB);
        FileSelector.NamedFileFilter namedFileFilter = new FileSelector.NamedFileFilter(string2, (FileSystemModel.FileFilter)new MainUI.ExtFilter(string3));
        this.fileSelector = new FileSelector(preferences, string);
        this.fileSelector.setFileSystemModel((FileSystemModel)JavaFileSystemModel.getInstance());
        this.fileSelector.setAllowMultiSelection(false);
        this.fileSelector.setUserWidgetBottom((Widget)this.editField);
        this.fileSelector.addCallback((FileSelector.Callback)cB);
        this.fileSelector.addFileFilter(FileSelector.AllFilesFilter);
        this.fileSelector.addFileFilter(namedFileFilter);
        this.fileSelector.setFileFilter(namedFileFilter);
        this.popupWindow = new PopupWindow(widget);
        this.popupWindow.setTheme("fileselector-popup");
        this.popupWindow.add((Widget)this.fileSelector);
    }

    public void openPopup() {
        if (this.popupWindow.openPopup()) {
            GUI gUI = this.popupWindow.getGUI();
            this.popupWindow.setSize(gUI.getWidth() * 4 / 5, gUI.getHeight() * 4 / 5);
            this.popupWindow.setPosition((gUI.getWidth() - this.popupWindow.getWidth()) / 2, (gUI.getHeight() - this.popupWindow.getHeight()) / 2);
        }
    }

    void checkName() {
        String string = this.editField.getText();
        if (string.length() == 0) {
            this.fileSelector.setOkButtonEnabled(false);
            this.editField.setErrorMessage(null);
            return;
        }
        File file = (File)this.fileSelector.getCurrentFolder();
        if (file == null) {
            this.fileSelector.setOkButtonEnabled(false);
            this.editField.setErrorMessage(null);
            return;
        }
        if (!file.canWrite()) {
            this.fileSelector.setOkButtonEnabled(false);
            this.editField.setErrorMessage((Object)("Can't write to folder " + file));
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        File file2 = new File(file, string);
        for (File file3 : this.callback.getFilesCreatedForFileName(file2)) {
            if (!file3.exists()) continue;
            stringBuilder.append(file3).append(" exists and will be overwritten\n");
        }
        this.fileSelector.setOkButtonEnabled(true);
        if (stringBuilder.length() > 0) {
            this.editField.setErrorMessage((Object)stringBuilder.substring(0, stringBuilder.length() - 1));
        } else {
            this.editField.setErrorMessage(null);
        }
    }

    class CB
    implements FileSelector.Callback2,
    EditField.Callback {
        CB() {
        }

        public void filesSelected(Object[] objectArray) {
            File file = (File)SaveFileSelector.this.fileSelector.getCurrentFolder();
            String string = SaveFileSelector.this.editField.getText();
            if (string.length() > 0 && file != null) {
                File file2 = new File(file, string);
                SaveFileSelector.this.popupWindow.closePopup();
                SaveFileSelector.this.callback.fileNameSelected(file2);
            }
        }

        public void canceled() {
            SaveFileSelector.this.popupWindow.closePopup();
            SaveFileSelector.this.callback.canceled();
        }

        public void folderChanged(Object object) {
            SaveFileSelector.this.checkName();
        }

        public void selectionChanged(FileTable.Entry[] entryArray) {
            if (entryArray.length == 1 && !entryArray[0].isFolder) {
                SaveFileSelector.this.editField.setText(entryArray[0].name);
            }
        }

        public void callback(int n) {
            String string;
            SaveFileSelector.this.checkName();
            if (!SaveFileSelector.this.editField.hasSelection() && SaveFileSelector.this.editField.getCursorPos() == SaveFileSelector.this.editField.getTextLength() && n == 0 && !(string = SaveFileSelector.this.editField.getText()).endsWith(SaveFileSelector.this.extension)) {
                String string2 = string.concat(SaveFileSelector.this.extension);
                SaveFileSelector.this.editField.setText(string2);
                SaveFileSelector.this.editField.setSelection(string.length(), string2.length());
            }
        }
    }

    public static interface Callback {
        public File[] getFilesCreatedForFileName(File var1);

        public void fileNameSelected(File var1);

        public void canceled();
    }
}

