/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twlthemeeditor.gui.DecoratedTextRenderer;
import de.matthiasmann.twlthemeeditor.gui.MessageDialog;
import de.matthiasmann.twlthemeeditor.gui.MessageLog;
import java.text.DateFormat;

public class StatusBar
extends DialogLayout {
    static final DateFormat TIME_FORMAT = DateFormat.getTimeInstance();
    private final MessageLog messageLog;
    private final Button btnDiscard;
    private final Button btnDetails;
    private final Label lTime;
    private final Label lMessage;
    private MessageLog.Entry displayedEntry;

    public StatusBar(MessageLog messageLog) {
        this.messageLog = messageLog;
        messageLog.addCallback(new Runnable(){

            public void run() {
                StatusBar.this.newMessages();
            }
        });
        this.btnDiscard = new Button("Discard");
        this.btnDiscard.setTheme("discardButton");
        this.btnDiscard.addCallback(new Runnable(){

            public void run() {
                StatusBar.this.discardMessage();
            }
        });
        this.btnDetails = new Button("Details");
        this.btnDetails.setTheme("detailsButton");
        this.btnDetails.addCallback(new Runnable(){

            public void run() {
                StatusBar.this.openDetailsDialog();
            }
        });
        this.lTime = new Label();
        this.lTime.setTheme("time");
        this.lMessage = new Label();
        this.lMessage.setTheme("message");
        this.displayedEntry = messageLog.getLatestMessage();
        this.updateStatusBar();
    }

    void newMessages() {
        MessageLog.Entry entry = this.messageLog.getLatestMessage();
        if (this.displayedEntry != entry) {
            this.displayedEntry = entry;
            this.updateStatusBar();
        }
    }

    void discardMessage() {
        this.messageLog.remove(this.displayedEntry);
    }

    private void updateStatusBar() {
        this.setVerticalGroup(null);
        this.removeAllChildren();
        DialogLayout.Group group = this.createSequentialGroup();
        DialogLayout.Group group2 = this.createParallelGroup();
        if (this.displayedEntry != null) {
            this.lTime.setText(TIME_FORMAT.format(this.displayedEntry.getTime()));
            this.lMessage.setText(this.displayedEntry.getMessage());
            this.setAnimState((Widget)this.lTime, this.displayedEntry.getCategory().getFlags());
            this.setAnimState((Widget)this.lMessage, this.displayedEntry.getCategory().getFlags());
            group.addWidget((Widget)this.lTime).addWidget((Widget)this.lMessage).addGap().addWidget((Widget)this.btnDiscard).addWidget((Widget)this.btnDetails);
            group2.addWidget((Widget)this.lTime).addWidget((Widget)this.lMessage).addWidget((Widget)this.btnDiscard).addWidget((Widget)this.btnDetails);
        }
        this.setHorizontalGroup(group);
        this.setVerticalGroup(group2);
    }

    private void setAnimState(Widget widget, int n) {
        DecoratedTextRenderer.setAnimationState(widget.getAnimationState(), n);
    }

    public void openDetailsDialog() {
        MessageDialog messageDialog = new MessageDialog(this.messageLog, this.displayedEntry);
        final PopupWindow popupWindow = new PopupWindow((Widget)this);
        popupWindow.setTheme("messagePopup");
        popupWindow.setCloseOnClickedOutside(false);
        popupWindow.setCloseOnEscape(true);
        popupWindow.add((Widget)messageDialog);
        messageDialog.addCloseCallback(new Runnable(){

            public void run() {
                popupWindow.closePopup();
            }
        });
        GUI gUI = this.getGUI();
        popupWindow.setSize(gUI.getWidth() * 4 / 5, gUI.getHeight() * 4 / 5);
        popupWindow.setPosition((gUI.getWidth() - popupWindow.getWidth()) / 2, (gUI.getHeight() - popupWindow.getHeight()) / 2);
        popupWindow.openPopup();
    }
}

