/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.DraggableButton;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Rect;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.CacheContext;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.MouseCursor;
import de.matthiasmann.twl.renderer.Renderer;
import de.matthiasmann.twl.renderer.Texture;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.EnumMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextureViewer
extends Widget {
    private final EnumMap<Cursors, MouseCursor> cursors;
    private URL url;
    private Rect rect;
    private Color tintColor = Color.WHITE;
    private float zoomX;
    private float zoomY;
    private int[] positionBarsHorz;
    private int[] positionBarsVert;
    private Runnable[] exceptionCallbacks;
    private MouseOverListener mouseOverListener;
    private DraggableButton.DragListener imageDragListener;
    private PositionBarDragListener positionBarDragListener;
    private TextureLoadedListener textureLoadedListener;
    private long lastModified;
    private CacheContext cacheContext;
    private Texture texture;
    private Image image;
    private Image specialImage;
    private IOException loadException;
    private Image imagePositionBarHorz;
    private Image imagePositionBarVert;
    private boolean reloadTexture;
    private boolean changeImage;
    private boolean mouseInside;
    private DragMode dragMode = DragMode.NONE;
    private int dragPosBarHorz;
    private int dragPosBarVert;
    private int dragStartX;
    private int dragStartY;

    public TextureViewer() {
        this.cursors = new EnumMap(Cursors.class);
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        if (!Utils.equals(this.url, uRL) || this.checkModified()) {
            this.url = uRL;
            this.reloadTexture = true;
        }
    }

    public void setRect(Rect rect) {
        this.rect = rect;
        this.specialImage = null;
        this.changeImage = true;
    }

    public void setTintColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.tintColor = color;
        this.changeImage = true;
    }

    public Rect getTextureRect() {
        if (this.texture == null) {
            return new Rect();
        }
        return new Rect(0, 0, this.texture.getWidth(), this.texture.getHeight());
    }

    public void setZoom(float f, float f2) {
        this.zoomX = f;
        this.zoomY = f2;
        this.invalidateLayout();
    }

    public void setPositionBarsHorz(int[] nArray) {
        this.positionBarsHorz = nArray;
    }

    public void setPositionBarsVert(int[] nArray) {
        this.positionBarsVert = nArray;
    }

    public void setImage(Image image) {
        this.specialImage = image;
        this.image = image;
        this.rect = image != null ? new Rect(0, 0, image.getWidth(), image.getHeight()) : null;
    }

    public IOException getLoadException() {
        return this.loadException;
    }

    public void addExceptionCallback(Runnable runnable) {
        this.exceptionCallbacks = (Runnable[])CallbackSupport.addCallbackToList((Object[])this.exceptionCallbacks, (Object)runnable, Runnable.class);
    }

    public void removeExceptionCallback(Runnable runnable) {
        this.exceptionCallbacks = (Runnable[])CallbackSupport.removeCallbackFromList((Object[])this.exceptionCallbacks, (Object)runnable);
    }

    public void setMouseOverListener(MouseOverListener mouseOverListener) {
        this.mouseOverListener = mouseOverListener;
    }

    public void setImageDragListener(DraggableButton.DragListener dragListener) {
        this.imageDragListener = dragListener;
    }

    public void setPositionBarDragListener(PositionBarDragListener positionBarDragListener) {
        this.positionBarDragListener = positionBarDragListener;
    }

    public void setTextureLoadedListener(TextureLoadedListener textureLoadedListener) {
        this.textureLoadedListener = textureLoadedListener;
    }

    public void destroy() {
        super.destroy();
        if (this.texture != null) {
            this.texture.destroy();
            this.texture = null;
        }
        if (this.cacheContext != null) {
            this.cacheContext.destroy();
            this.cacheContext = null;
        }
        this.image = null;
        this.reloadTexture = true;
        this.loadException = null;
    }

    public int getPreferredInnerWidth() {
        return this.image != null ? (int)((float)this.image.getWidth() * this.zoomX) : 0;
    }

    public int getPreferredInnerHeight() {
        return this.image != null ? (int)((float)this.image.getHeight() * this.zoomY) : 0;
    }

    public void validateImage() {
        if (this.reloadTexture) {
            this.destroy();
            GUI gUI = this.getGUI();
            if (this.url != null && gUI != null) {
                try {
                    this.loadTexture(gUI.getRenderer());
                }
                catch (IOException iOException) {
                    this.loadException = iOException;
                }
            }
            this.reloadTexture = false;
            this.changeImage = true;
            CallbackSupport.fireCallbacks((Runnable[])this.exceptionCallbacks);
        }
        if (this.specialImage != null) {
            if (this.image != this.specialImage) {
                this.image = this.specialImage;
                this.invalidateLayout();
            }
        } else if (this.changeImage) {
            if (this.texture != null) {
                if (this.rect == null) {
                    this.rect = this.getTextureRect();
                } else {
                    this.rect = new Rect(this.rect);
                    this.rect.intersect(this.getTextureRect());
                }
                try {
                    this.image = this.texture.getImage(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight(), this.tintColor, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.image = null;
                }
            } else {
                this.image = null;
            }
            this.invalidateLayout();
            this.changeImage = false;
        }
    }

    protected void paintWidget(GUI gUI) {
        Image image = this.image;
        this.validateImage();
        if (image == null) {
            image = this.image;
        }
        if (image != null) {
            image.draw((AnimationState)this.getAnimationState(), this.getInnerX(), this.getInnerY(), this.getInnerWidth(), this.getInnerHeight());
        }
        if (this.positionBarsVert != null && this.imagePositionBarVert != null) {
            for (int n : this.positionBarsVert) {
                this.imagePositionBarVert.draw((AnimationState)this.getAnimationState(), this.getInnerX() + (int)((float)n * this.zoomX), this.getInnerY(), 1, this.getInnerHeight());
            }
        }
        if (this.positionBarsHorz != null && this.imagePositionBarHorz != null) {
            for (int n : this.positionBarsHorz) {
                this.imagePositionBarHorz.draw((AnimationState)this.getAnimationState(), this.getInnerX(), this.getInnerY() + (int)((float)n * this.zoomY), this.getInnerWidth(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadTexture(Renderer renderer) throws IOException {
        try {
            this.lastModified = this.getLastModified();
        }
        catch (IOException iOException) {
            this.lastModified = System.currentTimeMillis();
            Logger.getLogger(TextureViewer.class.getName()).log(Level.SEVERE, "Can't determine last modified date", iOException);
        }
        CacheContext cacheContext = renderer.getActiveCacheContext();
        this.cacheContext = renderer.createNewCacheContext();
        renderer.setActiveCacheContext(this.cacheContext);
        try {
            this.texture = renderer.loadTexture(this.url, "RGBA", "NEAREST");
        }
        finally {
            renderer.setActiveCacheContext(cacheContext);
        }
        if (this.textureLoadedListener != null && this.texture != null) {
            this.textureLoadedListener.textureLoaded(this.url, this.texture);
        }
    }

    protected long getLastModified() throws IOException {
        URLConnection uRLConnection = this.url.openConnection();
        uRLConnection.setAllowUserInteraction(false);
        return uRLConnection.getLastModified();
    }

    protected boolean checkModified() {
        try {
            return this.url != null && this.lastModified != this.getLastModified();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean handleEvent(Event event) {
        if (this.mouseOverListener != null && event.isMouseEvent()) {
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            if (this.image != null && event.getType() != Event.Type.MOUSE_EXITED) {
                int n3 = event.getMouseX() - this.getInnerX();
                int n4 = event.getMouseY() - this.getInnerY();
                if (n3 >= 0 && n4 >= 0) {
                    n = (int)((float)n3 / this.zoomX);
                    n2 = (int)((float)n4 / this.zoomY);
                    boolean bl2 = bl = n >= 0 && n2 >= 0 && n < this.image.getWidth() && n2 < this.image.getHeight();
                }
            }
            if (bl) {
                if (this.rect != null) {
                    n += this.rect.getX();
                    n2 += this.rect.getY();
                }
                this.mouseOverListener.mousePosition(n, n2);
                this.mouseInside = true;
            } else if (this.mouseInside) {
                this.mouseOverListener.mouseExited();
                this.mouseInside = false;
            }
        }
        if (event.isMouseEvent() && this.dragMode != DragMode.NONE) {
            if (event.getType() == Event.Type.MOUSE_DRAGGED) {
                if (this.dragMode == DragMode.IMAGE && this.imageDragListener != null) {
                    this.imageDragListener.dragged(event.getMouseX() - this.dragStartX, event.getMouseY() - this.dragStartY);
                }
                if (this.dragMode == DragMode.BARS && this.positionBarDragListener != null) {
                    this.positionBarDragListener.dragged((int)((float)(event.getMouseX() - this.dragStartX) / this.zoomX), (int)((float)(event.getMouseY() - this.dragStartY) / this.zoomY));
                }
            }
            if (event.isMouseDragEnd()) {
                if (this.dragMode == DragMode.IMAGE && this.imageDragListener != null) {
                    this.imageDragListener.dragStopped();
                }
                if (this.dragMode == DragMode.BARS && this.positionBarDragListener != null) {
                    this.positionBarDragListener.dragStopped();
                }
                this.dragMode = DragMode.NONE;
            }
            return true;
        }
        if (super.handleEvent(event)) {
            return true;
        }
        switch (event.getType()) {
            case MOUSE_BTNDOWN: {
                this.dragStartX = event.getMouseX();
                this.dragStartY = event.getMouseY();
                break;
            }
            case MOUSE_DRAGGED: {
                this.startDrag();
                return true;
            }
            case MOUSE_MOVED: {
                this.setMouseCursor(this.cursors.get((Object)this.selectMouseCursor(event.getMouseX() - this.getInnerX(), event.getMouseY() - this.getInnerY())));
                return true;
            }
        }
        return event.isMouseEventNoWheel();
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.imagePositionBarHorz = themeInfo.getImage("positionBarHorz");
        this.imagePositionBarVert = themeInfo.getImage("positionBarVert");
        for (Cursors cursors : Cursors.values()) {
            this.cursors.put(cursors, themeInfo.getMouseCursor(cursors.cursorName));
        }
    }

    private void startDrag() {
        assert (this.dragMode == DragMode.NONE);
        this.dragPosBarHorz = this.findNearestPosBar(this.positionBarsHorz, this.dragStartY - this.getInnerY(), this.zoomY);
        this.dragPosBarVert = this.findNearestPosBar(this.positionBarsVert, this.dragStartX - this.getInnerX(), this.zoomX);
        if (this.dragPosBarHorz >= 0 || this.dragPosBarVert >= 0) {
            this.dragMode = DragMode.BARS;
            if (this.positionBarDragListener != null) {
                this.positionBarDragListener.dragStarted(this.dragPosBarHorz, this.dragPosBarVert);
            }
        } else {
            this.dragMode = DragMode.IMAGE;
            this.setMouseCursor(this.cursors.get((Object)Cursors.BOTH));
            if (this.imageDragListener != null) {
                this.imageDragListener.dragStarted();
            }
        }
    }

    private Cursors selectMouseCursor(int n, int n2) {
        int n3 = this.findNearestPosBar(this.positionBarsHorz, n2, this.zoomY);
        int n4 = this.findNearestPosBar(this.positionBarsVert, n, this.zoomX);
        if (n3 >= 0 && n4 >= 0) {
            return Cursors.BOTH;
        }
        if (n3 >= 0) {
            return Cursors.HORZ;
        }
        if (n4 >= 0) {
            return Cursors.VERT;
        }
        return Cursors.NONE;
    }

    private int findNearestPosBar(int[] nArray, int n, float f) {
        int n2 = -1;
        int n3 = 10;
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                int n4 = Math.abs((int)((float)nArray[i] * f) - n);
                if (n4 >= n3) continue;
                n3 = n4;
                n2 = i;
            }
        }
        return n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Cursors {
        NONE("mouseCursor"),
        HORZ("mouseCursor.horz"),
        VERT("mouseCursor.vert"),
        BOTH("mouseCursor.both");

        final String cursorName;

        private Cursors(String string2) {
            this.cursorName = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DragMode {
        NONE,
        IMAGE,
        BARS;

    }

    public static interface MouseOverListener {
        public void mousePosition(int var1, int var2);

        public void mouseExited();
    }

    public static interface PositionBarDragListener {
        public void dragStarted(int var1, int var2);

        public void dragged(int var1, int var2);

        public void dragStopped();
    }

    public static interface TextureLoadedListener {
        public void textureLoaded(URL var1, Texture var2);
    }
}

