/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.BoxLayout;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Menu;
import de.matthiasmann.twl.MenuAction;
import de.matthiasmann.twl.MenuElement;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.SimpleDialog;
import de.matthiasmann.twl.Table;
import de.matthiasmann.twl.TableBase;
import de.matthiasmann.twl.TableRowSelectionManager;
import de.matthiasmann.twl.TableSelectionManager;
import de.matthiasmann.twl.TreeTable;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.TableModel;
import de.matthiasmann.twl.model.TableSelectionModel;
import de.matthiasmann.twl.model.TableSingleSelectionModel;
import de.matthiasmann.twl.model.TreeTableModel;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.renderer.MouseCursor;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twlthemeeditor.datamodel.FilteredModel;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeModel;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateAtWrapper;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.MoveNodeOperations;
import de.matthiasmann.twlthemeeditor.gui.CollapsiblePanel;
import de.matthiasmann.twlthemeeditor.gui.IconCellRenderer;
import de.matthiasmann.twlthemeeditor.gui.MessageLog;
import de.matthiasmann.twlthemeeditor.gui.QueryOperationParameter;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeTreePane
extends DialogLayout {
    private final MessageLog messageLog;
    private final TreeTable treeTable;
    private final TableSingleSelectionModel treeTableSelectionModel;
    private final Table table;
    private final TableSingleSelectionModel tableSelectionModel;
    private final ScrollPane scrollPane;
    private final EditField filterEditField;
    private final MyFilter filter;
    private final BoxLayout buttons;
    private FilteredModel filteredModel;
    private TreeTableNode selected;
    private Runnable[] callbacks;
    private Runnable focusNameFieldCB;
    private static final MessageLog.Category CAT_THEME_TREE_OPERATION = new MessageLog.Category("Tree operation", MessageLog.CombineMode.NONE, 1);
    private static final MessageLog.Category CAT_URL_ERROR = new MessageLog.Category("URL", MessageLog.CombineMode.NONE, 1);
    private static final MessageLog.Category CAT_URL_WARNING = new MessageLog.Category("URL", MessageLog.CombineMode.REPLACE, 2);

    public ThemeTreePane(MessageLog messageLog) {
        this.messageLog = messageLog;
        this.treeTable = new TreeTable(){

            protected boolean handleKeyStrokeAction(String string, Event event) {
                if (ThemeTreePane.this.handleOperationKeyStrokeAction(string, event)) {
                    return true;
                }
                return super.handleKeyStrokeAction(string, event);
            }
        };
        this.treeTableSelectionModel = new TableSingleSelectionModel();
        this.table = new Table();
        this.tableSelectionModel = new TableSingleSelectionModel();
        this.scrollPane = new ScrollPane((Widget)this.treeTable);
        this.filterEditField = new EditField();
        this.filter = new MyFilter();
        this.buttons = new BoxLayout(BoxLayout.Direction.HORIZONTAL);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel(CollapsiblePanel.Direction.HORIZONTAL, "", (Widget)this.buttons, null);
        IconCellRenderer.install((TableBase)this.treeTable);
        this.scrollPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.treeTable.setSelectionManager((TableSelectionManager)new TableRowSelectionManager((TableSelectionModel)this.treeTableSelectionModel));
        this.table.setSelectionManager((TableSelectionManager)new TableRowSelectionManager((TableSelectionModel)this.tableSelectionModel));
        this.filterEditField.setTheme("filter");
        this.filterEditField.addCallback(new EditField.Callback(){

            public void callback(int n) {
                ThemeTreePane.this.updateFilter();
            }
        });
        this.treeTableSelectionModel.addSelectionChangeListener(new Runnable(){

            public void run() {
                TreeTableNode treeTableNode = null;
                if (ThemeTreePane.this.treeTableSelectionModel.hasSelection()) {
                    treeTableNode = ThemeTreePane.this.treeTable.getNodeFromRow(ThemeTreePane.this.treeTableSelectionModel.getFirstSelected());
                }
                ThemeTreePane.this.setSelected(treeTableNode);
            }
        });
        this.tableSelectionModel.addSelectionChangeListener(new Runnable(){

            public void run() {
                TreeTableNode treeTableNode = null;
                if (ThemeTreePane.this.tableSelectionModel.hasSelection()) {
                    treeTableNode = ThemeTreePane.this.filteredModel.getRow(ThemeTreePane.this.tableSelectionModel.getFirstSelected());
                }
                ThemeTreePane.this.setSelected(treeTableNode);
            }
        });
        this.treeTable.addCallback(new TableBase.Callback(){

            public void mouseDoubleClicked(int n, int n2) {
                if (n >= 0 && n < ThemeTreePane.this.treeTable.getNumRows()) {
                    ThemeTreePane.this.treeTable.setRowExpanded(n, !ThemeTreePane.this.treeTable.isRowExpanded(n));
                }
            }

            public void mouseRightClick(int n, int n2, Event event) {
                if (n >= 0 && n < ThemeTreePane.this.treeTable.getNumRows()) {
                    ThemeTreePane.this.showTreeTablePopupMenu(n, event);
                }
            }

            public void columnHeaderClicked(int n) {
            }
        });
        this.treeTable.setDragListener(new TableBase.DragListener(){
            TreeTableNode dragParent;
            MoveNodeOperations moveUp;
            MoveNodeOperations moveDown;

            public boolean dragStarted(int n, int n2, Event event) {
                if ((event.getModifiers() & 0x1C0) != 64) {
                    return false;
                }
                if (!(ThemeTreePane.this.selected instanceof ThemeTreeNode)) {
                    return false;
                }
                this.dragParent = ThemeTreePane.this.selected.getParent();
                if (this.dragParent == null) {
                    return false;
                }
                ThemeTreeNode themeTreeNode = (ThemeTreeNode)ThemeTreePane.this.selected;
                this.moveUp = themeTreeNode.getMoveOperation(-1);
                this.moveDown = themeTreeNode.getMoveOperation(1);
                return this.moveUp != null && this.moveDown != null;
            }

            public MouseCursor dragged(Event event) {
                if (!ThemeTreePane.this.treeTable.setDropMarker(event) || this.getNewNodeIndex() < 0) {
                    ThemeTreePane.this.treeTable.clearDropMarker();
                }
                ThemeTreePane.this.scrollPane.checkAutoScroll(event);
                return null;
            }

            public void dragStopped(Event event) {
                int n = this.getNewNodeIndex();
                if (n >= 0) {
                    int n2 = this.dragParent.getChildIndex(ThemeTreePane.this.selected);
                    if (n < n2) {
                        while (this.moveUp.isEnabled() && n < n2) {
                            ThemeTreePane.this.executeOperation(this.moveUp, null);
                            --n2;
                        }
                    } else {
                        --n;
                        while (this.moveDown.isEnabled() && n > n2) {
                            ThemeTreePane.this.executeOperation(this.moveDown, null);
                            ++n2;
                        }
                    }
                }
                this.dragCanceled();
            }

            public void dragCanceled() {
                ThemeTreePane.this.treeTable.clearDropMarker();
                ThemeTreePane.this.scrollPane.stopAutoScroll();
                this.moveUp = null;
                this.moveDown = null;
                this.dragParent = null;
            }

            private int getNewNodeIndex() {
                int n;
                TreeTableNode treeTableNode;
                if (!ThemeTreePane.this.treeTable.isDropMarkerBeforeRow()) {
                    return -1;
                }
                int n2 = ThemeTreePane.this.treeTable.getDropMarkerRow();
                if (n2 < ThemeTreePane.this.treeTable.getNumRows() && (treeTableNode = ThemeTreePane.this.treeTable.getNodeFromRow(n2)).getParent() == this.dragParent) {
                    return this.dragParent.getChildIndex(treeTableNode);
                }
                if (n2 > 0 && (treeTableNode = ThemeTreePane.this.treeTable.getNodeFromRow(n2 - 1)).getParent() == this.dragParent && (n = this.dragParent.getChildIndex(treeTableNode)) == this.dragParent.getNumChildren() - 1) {
                    return n + 1;
                }
                return -1;
            }
        });
        this.table.addCallback(new TableBase.Callback(){

            public void mouseDoubleClicked(int n, int n2) {
                ThemeTreePane.this.clearFilterAndJumpToRow(n);
            }

            public void mouseRightClick(int n, int n2, Event event) {
            }

            public void columnHeaderClicked(int n) {
            }
        });
        this.setHorizontalGroup(this.createParallelGroup().addWidget((Widget)this.scrollPane).addGroup(this.createSequentialGroup().addGap(-4).addWidget((Widget)this.filterEditField).addWidget((Widget)collapsiblePanel)));
        this.setVerticalGroup(this.createSequentialGroup().addWidget((Widget)this.scrollPane).addGroup(this.createParallelGroup(new Widget[]{this.filterEditField, collapsiblePanel})));
    }

    public void addCallback(Runnable runnable) {
        this.callbacks = (Runnable[])CallbackSupport.addCallbackToList((Object[])this.callbacks, (Object)runnable, Runnable.class);
    }

    public void removeCallback(Runnable runnable) {
        this.callbacks = (Runnable[])CallbackSupport.removeCallbackFromList((Object[])this.callbacks, (Object)runnable);
    }

    public void setFocusNameFieldCB(Runnable runnable) {
        this.focusNameFieldCB = runnable;
    }

    void updateFilter() {
        if (this.filter.setString(this.filterEditField.getText())) {
            TreeTableNode treeTableNode = this.selected;
            if (this.filter.hasFilter()) {
                this.scrollPane.setContent((Widget)this.table);
                if (this.filteredModel != null) {
                    this.filteredModel.setFilter(this.filter);
                }
            } else {
                this.scrollPane.setContent((Widget)this.treeTable);
            }
            this.selectNode(treeTableNode);
        }
    }

    void setSelected(TreeTableNode treeTableNode) {
        if (this.selected != treeTableNode) {
            this.selected = treeTableNode;
            CallbackSupport.fireCallbacks((Runnable[])this.callbacks);
            this.updateOperationButtons();
        }
    }

    void updateOperationButtons() {
        this.buttons.removeAllChildren();
        if (this.selected instanceof ThemeTreeNode) {
            ThemeTreeNode themeTreeNode = (ThemeTreeNode)this.selected;
            Menu menu = new Menu();
            this.addButtons(menu, themeTreeNode, themeTreeNode.getOperations());
            this.addCreateSubMenu(menu, themeTreeNode, themeTreeNode.getCreateChildOperations());
            menu.createMenuBar((Widget)this.buttons);
        }
    }

    void showTreeTablePopupMenu(int n, Event event) {
        TreeTableNode treeTableNode = this.treeTable.getNodeFromRow(n);
        if (treeTableNode instanceof ThemeTreeNode) {
            Object object;
            ThemeTreeNode themeTreeNode = (ThemeTreeNode)treeTableNode;
            Menu menu = new Menu();
            if (themeTreeNode.getParent() instanceof ThemeTreeNode) {
                object = (ThemeTreeNode)themeTreeNode.getParent();
                List<CreateChildOperation> list = ((ThemeTreeNode)((Object)object)).getCreateChildOperations();
                this.addCreateAtSubMenu(menu, "opNewNodeBefore", (ThemeTreeNode)((Object)object), list, CreateAtWrapper.Location.BEFORE, themeTreeNode);
                this.addCreateAtSubMenu(menu, "opNewNodeAfter", (ThemeTreeNode)((Object)object), list, CreateAtWrapper.Location.AFTER, themeTreeNode);
            }
            this.addCreateSubMenu(menu, themeTreeNode, themeTreeNode.getCreateChildOperations());
            object = themeTreeNode.getOperations();
            if (!object.isEmpty()) {
                if (menu.getNumElements() > 0) {
                    menu.addSpacer();
                }
                this.addButtons(menu, themeTreeNode, (List<ThemeTreeOperation>)object);
            }
            if (menu.getNumElements() > 0) {
                menu.openPopupMenu((Widget)this.treeTable, event.getMouseX(), event.getMouseY());
            }
        }
    }

    public TreeTableNode getSelected() {
        return this.selected;
    }

    public void setModel(ThemeTreeModel themeTreeModel) {
        this.treeTable.setModel((TreeTableModel)themeTreeModel);
        if (themeTreeModel == null) {
            this.filteredModel = null;
        } else {
            this.treeTable.setRowExpanded(0, true);
            this.filteredModel = new FilteredModel((TreeTableModel)themeTreeModel);
        }
        this.table.setModel((TableModel)this.filteredModel);
        this.updateFilter();
    }

    private void addButtons(Menu menu, ThemeTreeNode themeTreeNode, List<ThemeTreeOperation> list) {
        for (ThemeTreeOperation themeTreeOperation : list) {
            MenuAction menuAction = this.createMenuAction(themeTreeNode, themeTreeOperation);
            menu.add((MenuElement)menuAction);
        }
    }

    private void addCreateSubMenu(Menu menu, ThemeTreeNode themeTreeNode, List<CreateChildOperation> list) {
        if (!list.isEmpty()) {
            Menu menu2 = new Menu();
            menu2.setTheme("opNewNode");
            menu2.setPopupTheme("opNewNode-popupMenu");
            menu.add((MenuElement)menu2);
            for (CreateChildOperation createChildOperation : list) {
                MenuAction menuAction = this.createMenuAction(themeTreeNode, createChildOperation);
                menu2.add((MenuElement)menuAction);
            }
        }
    }

    private void addCreateAtSubMenu(Menu menu, String string, ThemeTreeNode themeTreeNode, List<CreateChildOperation> list, CreateAtWrapper.Location location, ThemeTreeNode themeTreeNode2) {
        if (!list.isEmpty()) {
            Menu menu2 = new Menu();
            menu2.setTheme(string);
            menu2.setPopupTheme("opNewNode-popupMenu");
            menu.add((MenuElement)menu2);
            for (CreateChildOperation createChildOperation : list) {
                MenuAction menuAction = this.createMenuAction(themeTreeNode, new CreateAtWrapper(createChildOperation, location, themeTreeNode2));
                menu2.add((MenuElement)menuAction);
            }
        }
    }

    private MenuAction createMenuAction(final ThemeTreeNode themeTreeNode, final ThemeTreeOperation themeTreeOperation) {
        MenuAction menuAction = new MenuAction();
        menuAction.setTheme(themeTreeOperation.getActionID());
        menuAction.setEnabled(themeTreeOperation.isEnabled());
        menuAction.setCallback(new Runnable(){

            public void run() {
                ThemeTreePane.this.queryOperationParameter(themeTreeNode, themeTreeOperation, false);
            }
        });
        return menuAction;
    }

    void executeOperation(ThemeTreeOperation themeTreeOperation, Object[] objectArray) {
        ThemeTreeNode themeTreeNode = null;
        try {
            themeTreeNode = themeTreeOperation.execute(objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.messageLog.add(new MessageLog.Entry(CAT_THEME_TREE_OPERATION, "Invalid parameters for operation", illegalArgumentException.getMessage(), null, new MessageLog.EntryAction[0]));
        }
        catch (Throwable throwable) {
            this.messageLog.add(new MessageLog.Entry(CAT_THEME_TREE_OPERATION, "Error while executing tree operation", null, throwable, new MessageLog.EntryAction[0]));
        }
        this.selectNode((TreeTableNode)themeTreeNode);
        if (themeTreeNode != null && this.focusNameFieldCB != null && themeTreeOperation.shouldFocusNameFieldAfterExecute()) {
            this.getGUI().invokeLater(this.focusNameFieldCB);
        }
    }

    void selectNode(TreeTableNode treeTableNode) {
        int n = treeTableNode != null ? this.treeTable.getRowFromNodeExpand(treeTableNode) : -1;
        this.treeTableSelectionModel.setSelection(n, n);
        if (n >= 0) {
            this.treeTable.scrollToRow(n);
        }
        n = treeTableNode != null ? this.filteredModel.getRowFromNode(treeTableNode) : -1;
        this.tableSelectionModel.setSelection(n, n);
        if (n >= 0) {
            this.table.scrollToRow(n);
        }
        this.updateOperationButtons();
    }

    void clearFilterAndJumpToRow(int n) {
        if (n >= 0 && n < this.filteredModel.getNumRows()) {
            this.selectNode(this.filteredModel.getRow(n));
            this.filterEditField.setText("");
        }
    }

    void queryOperationParameter(final ThemeTreeNode themeTreeNode, final ThemeTreeOperation themeTreeOperation, boolean bl) {
        ThemeTreeOperation.Parameter[] parameterArray = themeTreeOperation.getParameter();
        if (parameterArray != null && parameterArray.length > 0) {
            Object object;
            File file = null;
            URL uRL = themeTreeNode.getThemeFile().getURL();
            try {
                object = uRL.toURI();
                if ("file".equals(((URI)object).getScheme())) {
                    file = new File((URI)object).getParentFile();
                } else {
                    this.messageLog.add(new MessageLog.Entry(CAT_URL_WARNING, "Can't resolve URI in file system", ((URI)object).toString(), null, new MessageLog.EntryAction[0]));
                }
            }
            catch (Exception exception) {
                this.messageLog.add(new MessageLog.Entry(CAT_URL_ERROR, "Error resolving URL to file system", uRL.toString(), exception, new MessageLog.EntryAction[0]));
            }
            object = new QueryOperationParameter(file);
            ((QueryOperationParameter)((Object)object)).setParameter(parameterArray);
            SimpleDialog simpleDialog = new SimpleDialog();
            simpleDialog.setTheme("parameterDlg-" + themeTreeOperation.getActionID());
            simpleDialog.setTitle(themeTreeOperation.getActionID());
            simpleDialog.setMessage(object);
            simpleDialog.setOkCallback(new Runnable((QueryOperationParameter)((Object)object), bl){
                final /* synthetic */ QueryOperationParameter val$qop;
                final /* synthetic */ boolean val$skipConfirm;
                {
                    this.val$qop = queryOperationParameter;
                    this.val$skipConfirm = bl;
                }

                public void run() {
                    ThemeTreePane.this.maybeConfirmOperation(themeTreeNode, themeTreeOperation, this.val$qop.getResults(), this.val$skipConfirm);
                }
            });
            simpleDialog.showDialog((Widget)this);
        } else {
            this.maybeConfirmOperation(themeTreeNode, themeTreeOperation, null, bl);
        }
    }

    void maybeConfirmOperation(ThemeTreeNode themeTreeNode, ThemeTreeOperation themeTreeOperation, Object[] objectArray, boolean bl) {
        if (!bl && themeTreeOperation.needConfirm()) {
            this.confirmOperation(themeTreeNode, themeTreeOperation, objectArray);
        } else {
            this.executeOperation(themeTreeOperation, objectArray);
        }
    }

    void confirmOperation(ThemeTreeNode themeTreeNode, final ThemeTreeOperation themeTreeOperation, final Object[] objectArray) {
        SimpleDialog simpleDialog = new SimpleDialog();
        simpleDialog.setTheme("confirmationDlg-" + themeTreeOperation.getActionID());
        simpleDialog.setTitle(themeTreeOperation.getActionID());
        simpleDialog.setMessage((Object)themeTreeNode.toString());
        simpleDialog.setOkCallback(new Runnable(){

            public void run() {
                ThemeTreePane.this.executeOperation(themeTreeOperation, objectArray);
            }
        });
        simpleDialog.showDialog((Widget)this);
    }

    boolean handleOperationKeyStrokeAction(String string, Event event) {
        if (event.isKeyPressedEvent() && !event.isKeyRepeated() && this.selected instanceof ThemeTreeNode) {
            ThemeTreeNode themeTreeNode = (ThemeTreeNode)this.selected;
            ThemeTreeOperation themeTreeOperation = this.findOperation(themeTreeNode.getOperations(), string);
            if (themeTreeOperation == null) {
                themeTreeOperation = this.findOperation(themeTreeNode.getCreateChildOperations(), string);
            }
            if (themeTreeOperation != null) {
                this.queryOperationParameter(themeTreeNode, themeTreeOperation, (event.getModifiers() & 9) != 0);
                return true;
            }
        }
        return false;
    }

    private ThemeTreeOperation findOperation(List<? extends ThemeTreeOperation> list, String string) {
        for (ThemeTreeOperation themeTreeOperation : list) {
            if (!themeTreeOperation.getActionID().equals(string)) continue;
            return themeTreeOperation;
        }
        return null;
    }

    static class MyFilter
    implements FilteredModel.Filter {
        private String str = "";

        MyFilter() {
        }

        boolean setString(String string) {
            if (!this.str.equals(string = string.toLowerCase())) {
                this.str = string;
                return true;
            }
            return false;
        }

        boolean hasFilter() {
            return this.str.length() > 0;
        }

        public boolean isVisible(TreeTableNode treeTableNode) {
            if (treeTableNode instanceof ThemeTreeNode) {
                ThemeTreeNode themeTreeNode = (ThemeTreeNode)treeTableNode;
                String string = themeTreeNode.getName();
                return string != null && string.toLowerCase().contains(this.str);
            }
            return false;
        }
    }
}

