/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.Timer;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.AbstractProperty;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.utils.ClassUtils;
import de.matthiasmann.twlthemeeditor.gui.Context;
import de.matthiasmann.twlthemeeditor.gui.PropertyFactories;
import de.matthiasmann.twlthemeeditor.gui.PropertyPanel;
import de.matthiasmann.twlthemeeditor.gui.TestWidgetContainer;
import de.matthiasmann.twlthemeeditor.properties.BoundProperty;
import de.matthiasmann.twlthemeeditor.properties.RectProperty;
import de.matthiasmann.twlthemeeditor.properties.WidgetThemeProperty;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetPropertyEditor
extends ScrollPane {
    private Context ctx;
    private Timer timer;
    private ArrayList<Property<?>> properties;

    public WidgetPropertyEditor() {
        this.setFixed(ScrollPane.Fixed.HORIZONTAL);
    }

    public void setContext(Context context) {
        this.ctx = context;
        this.setContent(null);
    }

    public void setWidget(final Widget widget) {
        if (widget == null || this.ctx == null) {
            this.setContent(null);
            this.properties = null;
            return;
        }
        this.properties = new ArrayList();
        this.properties.add(new WidgetRectProperty(widget));
        this.properties.add((Property<?>)new PolledBoundProperty<Integer>(widget, "Preferred Width", "preferredWidth", Integer.class));
        this.properties.add((Property<?>)new PolledBoundProperty<Integer>(widget, "Preferred Height", "preferredHeight", Integer.class));
        this.properties.add((Property<?>)new WidgetThemeProperty(widget, this.ctx));
        this.properties.add((Property<?>)new AbstractProperty<AnimationState>(){

            public boolean canBeNull() {
                return false;
            }

            public String getName() {
                return "Animation state";
            }

            public AnimationState getPropertyValue() {
                return widget.getAnimationState();
            }

            public Class<AnimationState> getType() {
                return AnimationState.class;
            }

            public boolean isReadOnly() {
                return true;
            }

            public void setPropertyValue(AnimationState animationState) throws IllegalArgumentException {
                throw new UnsupportedOperationException("Not supported");
            }
        });
        this.properties.add((Property<?>)new BoundProperty<Boolean>((Object)widget, "locallyEnabled", BoundProperty.getReadMethod(widget, "locallyEnabled", Boolean.class), BoundProperty.getWriteMethod(widget, "enabled", Boolean.TYPE), Boolean.class){

            @Override
            public String getName() {
                return "Enabled";
            }
        });
        this.addBeanProperties(widget, this.properties);
        PropertyPanel propertyPanel = new PropertyPanel((PropertyFactories)this.ctx, this.properties);
        this.setContent((Widget)propertyPanel);
    }

    private void addBeanProperties(Widget widget, ArrayList<Property<?>> arrayList) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(widget.getClass());
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                if (propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null || propertyDescriptor.getReadMethod().getDeclaringClass() == Widget.class) continue;
                arrayList.add((Property<?>)new BoundProperty((Object)widget, propertyDescriptor, ClassUtils.mapPrimitiveToWrapper(propertyDescriptor.getPropertyType())));
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(WidgetPropertyEditor.class.getName()).log(Level.SEVERE, "can't collect bean properties", throwable);
        }
    }

    protected void afterAddToGUI(GUI gUI) {
        super.afterAddToGUI(gUI);
        this.timer = gUI.createTimer();
        this.timer.setContinuous(true);
        this.timer.setDelay(500);
        this.timer.setCallback(new Runnable(){

            public void run() {
                WidgetPropertyEditor.this.pollProperties();
            }
        });
        this.timer.start();
    }

    protected void beforeRemoveFromGUI(GUI gUI) {
        this.timer.stop();
        this.timer = null;
        super.beforeRemoveFromGUI(gUI);
    }

    void pollProperties() {
        if (this.properties != null) {
            int n = this.properties.size();
            for (int i = 0; i < n; ++i) {
                Property<?> property = this.properties.get(i);
                if (!(property instanceof PolledBoundProperty)) continue;
                ((PolledBoundProperty)property).poll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class BoundIntegerProperty
    extends BoundProperty<Integer>
    implements IntegerModel {
        public BoundIntegerProperty(Object object, String string) {
            super(object, string, Integer.class);
        }

        public void addCallback(Runnable runnable) {
            this.addValueChangedCallback(runnable);
        }

        public void removeCallback(Runnable runnable) {
            this.removeValueChangedCallback(runnable);
        }

        public int getMinValue() {
            return 0;
        }

        public int getValue() {
            return (Integer)this.getPropertyValue();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PolledBoundProperty<T>
    extends BoundProperty<T> {
        private T lastValue;

        public PolledBoundProperty(Object object, String string, Class<T> clazz) {
            super(object, string, clazz);
        }

        public PolledBoundProperty(Object object, String string, String string2, Class<T> clazz) {
            super(object, string, string2, clazz);
        }

        @Override
        public T getPropertyValue() {
            this.updateValue();
            return this.lastValue;
        }

        @Override
        protected void propertyChanged() {
            this.updateValue();
            super.propertyChanged();
        }

        public void poll() {
            Object t = super.getPropertyValue();
            if (t != this.lastValue) {
                boolean bl = t == null || t != null && !t.equals(this.lastValue);
                this.lastValue = t;
                if (bl) {
                    this.fireValueChangedCallback();
                }
            }
        }

        private void updateValue() {
            this.lastValue = super.getPropertyValue();
        }
    }

    static class WidgetRectProperty
    extends RectProperty {
        final Widget widget;

        public WidgetRectProperty(final Widget widget) {
            super(new BoundIntegerProperty((Object)widget, "x"){

                public int getMaxValue() {
                    return widget.getParent().getInnerWidth() - 1;
                }

                public void setValue(int n) {
                    widget.setPosition(n, widget.getY());
                }
            }, new BoundIntegerProperty((Object)widget, "y"){

                public int getMaxValue() {
                    return widget.getParent().getInnerHeight() - 1;
                }

                public void setValue(int n) {
                    widget.setPosition(widget.getX(), n);
                }
            }, new BoundIntegerProperty((Object)widget, "width"){

                public int getMaxValue() {
                    return widget.getParent().getInnerWidth();
                }

                public void setValue(int n) {
                    widget.setSize(n, widget.getHeight());
                }
            }, new BoundIntegerProperty((Object)widget, "height"){

                public int getMaxValue() {
                    return widget.getParent().getInnerHeight();
                }

                public void setValue(int n) {
                    widget.setSize(widget.getWidth(), n);
                }
            }, "Widget position & size");
            this.widget = widget;
        }

        public Dimension getLimit() {
            Widget widget = this.widget.getParent();
            return new Dimension(widget.getInnerWidth(), widget.getInnerHeight());
        }

        public RectProperty.AbstractAction[] getActions() {
            if (this.widget.getParent() instanceof TestWidgetContainer) {
                return new RectProperty.AbstractAction[]{new RectProperty.AbstractAction("Adjust size", "Calls the adjustSize() method"){

                    public void run() {
                        try {
                            WidgetRectProperty.this.widget.adjustSize();
                        }
                        catch (Throwable throwable) {
                            Logger.getLogger(WidgetPropertyEditor.class.getName()).log(Level.SEVERE, "adjusting widget size", throwable);
                        }
                    }
                }, new RectProperty.AbstractAction("Full size"){

                    public void run() {
                        try {
                            Widget widget = WidgetRectProperty.this.widget.getParent();
                            WidgetRectProperty.this.widget.setPosition(0, 0);
                            WidgetRectProperty.this.widget.setSize(widget.getInnerWidth(), widget.getInnerHeight());
                        }
                        catch (Throwable throwable) {
                            Logger.getLogger(WidgetPropertyEditor.class.getName()).log(Level.SEVERE, "changing widget size", throwable);
                        }
                    }
                }};
            }
            return super.getActions();
        }
    }
}

