/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TableBase;
import de.matthiasmann.twl.TableRowSelectionManager;
import de.matthiasmann.twl.TableSelectionManager;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.TreeTable;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.TableSelectionModel;
import de.matthiasmann.twl.model.TableSingleSelectionModel;
import de.matthiasmann.twl.model.TreeTableModel;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.renderer.MouseCursor;
import de.matthiasmann.twlthemeeditor.gui.Context;
import de.matthiasmann.twlthemeeditor.gui.DecoratedTextRenderer;
import de.matthiasmann.twlthemeeditor.gui.PreviewWidget;
import de.matthiasmann.twlthemeeditor.gui.WidgetTreeModel;

public class WidgetTree
extends DialogLayout {
    private final WidgetTreeModel treeModel;
    private final PreviewWidget previewWidget;
    private final TableSingleSelectionModel selectionModel;
    private final TreeTable treeTable;
    private final ScrollPane scrollPane;
    private final Button btnReloadWidget;
    private final Button btnFlashSelectedWidget;
    private final Widget btnSelectWidget;
    private GUI testGUI;

    public WidgetTree(WidgetTreeModel widgetTreeModel, PreviewWidget previewWidget) {
        this.treeModel = widgetTreeModel;
        this.previewWidget = previewWidget;
        this.selectionModel = new TableSingleSelectionModel();
        this.treeTable = new TreeTable((TreeTableModel)widgetTreeModel);
        this.treeTable.setTheme("themetree");
        this.treeTable.setSelectionManager((TableSelectionManager)new TableRowSelectionManager((TableSelectionModel)this.selectionModel));
        DecoratedTextRenderer.install((TableBase)this.treeTable);
        this.scrollPane = new ScrollPane((Widget)this.treeTable);
        this.scrollPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.btnReloadWidget = new Button();
        this.btnReloadWidget.setTheme("btnReloadWidget");
        this.btnReloadWidget.setEnabled(false);
        this.btnFlashSelectedWidget = new Button();
        this.btnFlashSelectedWidget.setTheme("btnFlash");
        this.btnFlashSelectedWidget.setEnabled(false);
        this.btnFlashSelectedWidget.addCallback(new Runnable(){

            public void run() {
                WidgetTree.this.flashSelectedWidget();
            }
        });
        this.btnSelectWidget = new Button(){
            Widget selectedWidget;
            MouseCursor cursorNormal;
            MouseCursor cursorDragging;

            protected boolean handleEvent(Event event) {
                if (event.isMouseEvent() && event.isMouseDragEvent()) {
                    this.selectedWidget = WidgetTree.this.selectWidgetFromMouse(event.getMouseX(), event.getMouseY());
                    WidgetTree.this.flashWidget(this.selectedWidget, false);
                    if (event.isMouseDragEnd()) {
                        this.setMouseCursor(this.cursorNormal);
                        WidgetTree.this.selectWidget(this.selectedWidget);
                        this.selectedWidget = null;
                    } else {
                        this.setMouseCursor(this.cursorDragging);
                        return true;
                    }
                }
                return super.handleEvent(event) || event.isMouseEventNoWheel();
            }

            protected void applyTheme(ThemeInfo themeInfo) {
                super.applyTheme(themeInfo);
                this.cursorNormal = themeInfo.getMouseCursor("mouseCursor");
                this.cursorDragging = themeInfo.getMouseCursor("mouseCursorDragging");
            }
        };
        this.btnSelectWidget.setTheme("btnSelect");
        this.btnSelectWidget.setCanAcceptKeyboardFocus(true);
        this.selectionModel.addSelectionChangeListener(new Runnable(){

            public void run() {
                WidgetTree.this.btnFlashSelectedWidget.setEnabled(WidgetTree.this.selectionModel.hasSelection());
            }
        });
        this.setHorizontalGroup(this.createParallelGroup().addWidget((Widget)this.scrollPane).addGroup(this.createSequentialGroup().addGap("left-reload").addWidget((Widget)this.btnReloadWidget).addGap("reload-select").addWidget(this.btnSelectWidget).addGap("select-flash").addWidget((Widget)this.btnFlashSelectedWidget).addGap("flash-right")));
        this.setVerticalGroup(this.createSequentialGroup().addWidget((Widget)this.scrollPane).addGroup(this.createParallelGroup(new Widget[]{this.btnReloadWidget, this.btnSelectWidget, this.btnFlashSelectedWidget})));
    }

    public void setTestGUI(Context context, GUI gUI) {
        this.testGUI = gUI;
        this.treeModel.createTreeFromWidget(context, gUI);
        if (this.treeModel.getNumChildren() > 0) {
            this.selectionModel.setSelection(0, 0);
            this.treeTable.setRowExpanded(0, true);
        }
        this.btnReloadWidget.setEnabled(gUI != null);
    }

    public void addReloadButtenCallback(Runnable runnable) {
        this.btnReloadWidget.addCallback(runnable);
    }

    public void addSelectionChangeListener(Runnable runnable) {
        this.selectionModel.addSelectionChangeListener(runnable);
    }

    public Widget getSelectedWidget() {
        Widget widget;
        for (Widget widget2 = widget = (var1_1 = this.selectionModel.getFirstSelected()) >= 0 ? this.treeModel.getWidget(this.treeTable.getNodeFromRow(var1_1)) : null; widget2 != null; widget2 = widget2.getParent()) {
            if (widget2 != this.testGUI) continue;
            return widget;
        }
        return null;
    }

    void selectWidget(Widget widget) {
        WidgetTreeModel.Node node = this.treeModel.getNodeForWidget(widget);
        if (node != null) {
            int n = this.treeTable.getRowFromNodeExpand((TreeTableNode)node);
            this.selectionModel.setSelection(n, n);
            this.treeTable.scrollToRow(n);
        }
        this.flashWidget(widget, true);
    }

    Widget selectWidgetFromMouse(int n, int n2) {
        return this.previewWidget.selectWidgetFromMouse(n, n2);
    }

    void flashSelectedWidget() {
        this.flashWidget(this.getSelectedWidget(), true);
    }

    void flashWidget(Widget widget, boolean bl) {
        if (widget != null) {
            this.previewWidget.flashRectangle(widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight(), bl);
        } else {
            this.previewWidget.flashRectangle(0, 0, 0, 0, false);
        }
    }
}

