/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Timer;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.HasCallback;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twlthemeeditor.gui.Context;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.StateEditField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimStateEditorFactory
implements PropertyEditorFactory<AnimationState, Property<AnimationState>> {
    private final Context ctx;

    public AnimStateEditorFactory(Context context) {
        this.ctx = context;
    }

    @Override
    public Widget create(PropertyAccessor<AnimationState, Property<AnimationState>> propertyAccessor) {
        return new AnimStateEditor(this.ctx, propertyAccessor.getProperty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AnimStateEditor
    extends DialogLayout
    implements Runnable,
    EditField.Callback {
        private final AnimationState animationState;
        private final Field stateTableField;
        private final Field parentField;
        private final Field stateKeys;
        private final TreeMap<String, ToggleButton> buttons;
        private final ArrayList<StateBooleanModel> models;
        private final EditField stateNameField;
        private final Button addStateNameButton;
        private Timer timer;

        public AnimStateEditor(Context context, Property<AnimationState> property) {
            this.animationState = (AnimationState)property.getPropertyValue();
            Class<AnimationState> clazz = AnimationState.class;
            this.stateTableField = AnimStateEditor.getField(clazz, "stateTable");
            this.parentField = AnimStateEditor.getField(clazz, "parent");
            this.stateKeys = AnimStateEditor.getField(AnimationState.StateKey.class, "keys");
            this.buttons = new TreeMap();
            this.models = new ArrayList();
            this.stateNameField = new StateEditField();
            this.stateNameField.addCallback((EditField.Callback)this);
            this.stateNameField.setAutoCompletion(context.collectAllStates());
            this.addStateNameButton = new Button();
            this.addStateNameButton.setTheme("addbutton");
            this.addStateNameButton.setEnabled(false);
            this.addStateNameButton.addCallback(new Runnable(){

                public void run() {
                    AnimStateEditor.this.addState();
                }
            });
            this.createStateButtons();
            this.createLayout();
        }

        protected void afterAddToGUI(GUI gUI) {
            super.afterAddToGUI(gUI);
            this.timer = gUI.createTimer();
            this.timer.setCallback((Runnable)this);
            this.timer.setContinuous(true);
            this.timer.setDelay(250);
            this.timer.start();
        }

        protected void beforeRemoveFromGUI(GUI gUI) {
            this.timer.stop();
            super.beforeRemoveFromGUI(gUI);
            this.timer = null;
        }

        protected void paint(GUI gUI) {
            this.updateModels();
            super.paint(gUI);
        }

        @Override
        public void run() {
            if (this.createStateButtons()) {
                this.createLayout();
            }
        }

        public void callback(int n) {
            this.addStateNameButton.setEnabled(this.stateNameField.getTextLength() > 0);
            if (n == 28) {
                this.addState();
            }
        }

        void addState() {
            AnimationState.StateKey stateKey;
            String string = this.stateNameField.getText();
            if (string.length() > 0 && this.createStateButton(stateKey = AnimationState.StateKey.get((String)string))) {
                this.createLayout();
            }
        }

        private void createLayout() {
            this.setHorizontalGroup(null);
            this.removeAllChildren();
            ToggleButton[] toggleButtonArray = this.buttons.values().toArray(new ToggleButton[this.buttons.size()]);
            this.setHorizontalGroup(this.createParallelGroup().addWidgets((Widget[])toggleButtonArray).addGroup(this.createSequentialGroup(new Widget[]{this.stateNameField, this.addStateNameButton})));
            this.setVerticalGroup(this.createSequentialGroup().addWidgetsWithGap("vbutton", (Widget[])toggleButtonArray).addGroup(this.createParallelGroup(new Widget[]{this.stateNameField, this.addStateNameButton})));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean createStateButtons() {
            AnimationState.StateKey[] stateKeyArray;
            Object[] objectArray;
            AnimationState animationState;
            boolean bl = false;
            if (this.stateTableField == null || this.stateKeys == null) return bl;
            try {
                animationState = AnimationState.StateKey.class;
                synchronized (AnimationState.StateKey.class) {
                    objectArray = (Object[])this.stateKeys.get(null);
                    stateKeyArray = new AnimationState.StateKey[objectArray.size()];
                    Iterator iterator = objectArray.values().iterator();
                    while (iterator.hasNext()) {
                        AnimationState.StateKey stateKey;
                        stateKeyArray[stateKey.getID()] = stateKey = (AnimationState.StateKey)iterator.next();
                    }
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                }
            }
            catch (Throwable throwable) {
                Logger.getLogger(AnimStateEditorFactory.class.getName()).log(Level.SEVERE, "Can't access state table", throwable);
                return false;
            }
            {
                animationState = this.animationState;
                do {
                    try {
                        objectArray = (Object[])this.stateTableField.get(animationState);
                        int n = objectArray.length;
                        for (int i = 0; i < n; ++i) {
                            if (objectArray[i] == null) continue;
                            bl |= this.createStateButton(stateKeyArray[i]);
                        }
                    }
                    catch (Throwable throwable) {
                        Logger.getLogger(AnimStateEditorFactory.class.getName()).log(Level.SEVERE, "Can't access state table", throwable);
                    }
                    if (this.parentField == null) return bl;
                    try {
                        animationState = (AnimationState)this.parentField.get(animationState);
                    }
                    catch (Throwable throwable) {
                        Logger.getLogger(AnimStateEditorFactory.class.getName()).log(Level.SEVERE, "Can't access parent field", throwable);
                        return bl;
                    }
                } while (animationState != null);
                return bl;
            }
        }

        private boolean createStateButton(AnimationState.StateKey stateKey) {
            ToggleButton toggleButton = this.buttons.get(stateKey.getName());
            if (toggleButton == null) {
                StateBooleanModel stateBooleanModel = new StateBooleanModel(this.animationState, stateKey);
                toggleButton = new ToggleButton((BooleanModel)stateBooleanModel);
                toggleButton.setTheme("statebutton");
                toggleButton.setText(stateKey.getName());
                this.buttons.put(stateKey.getName(), toggleButton);
                this.models.add(stateBooleanModel);
                return true;
            }
            return false;
        }

        private void updateModels() {
            int n = this.models.size();
            for (int i = 0; i < n; ++i) {
                this.models.get(i).update();
            }
        }

        private static Field getField(Class<?> clazz, String string) {
            try {
                Field field = clazz.getDeclaredField(string);
                field.setAccessible(true);
                return field;
            }
            catch (Throwable throwable) {
                Logger.getLogger(AnimStateEditorFactory.class.getName()).log(Level.SEVERE, "Can't access field", throwable);
                return null;
            }
        }

        static class StateBooleanModel
        extends HasCallback
        implements BooleanModel {
            private final AnimationState animationState;
            private final AnimationState.StateKey stateKey;
            private boolean lastState;

            public StateBooleanModel(AnimationState animationState, AnimationState.StateKey stateKey) {
                this.animationState = animationState;
                this.stateKey = stateKey;
            }

            public boolean getValue() {
                return this.lastState;
            }

            public void setValue(boolean bl) {
                this.animationState.setAnimationState(this.stateKey, bl);
            }

            public void update() {
                boolean bl = this.animationState.getAnimationState(this.stateKey);
                if (this.lastState != bl) {
                    this.lastState = bl;
                    this.doCallback();
                }
            }
        }
    }
}

