/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.Border;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.ValueAdjusterInt;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.SimpleBooleanModel;
import de.matthiasmann.twl.model.SimpleIntegerModel;
import de.matthiasmann.twlthemeeditor.datamodel.BorderFormula;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.properties.BorderProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BorderEditorFactory
implements PropertyEditorFactory<Border, BorderProperty> {
    @Override
    public Widget create(PropertyAccessor<Border, BorderProperty> propertyAccessor) {
        return new BorderEditor(propertyAccessor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BorderEditor
    extends DialogLayout
    implements Runnable,
    EditField.Callback {
        private final PropertyAccessor<Border, BorderProperty> pa;
        private final SimpleBooleanModel useFormula;
        private final SimpleIntegerModel modelTop;
        private final SimpleIntegerModel modelLeft;
        private final SimpleIntegerModel modelBottom;
        private final SimpleIntegerModel modelRight;
        private final EditField efFormula;
        private final ValueAdjusterInt[] adjusters;
        boolean inSetProperty;
        private static final int MAX_BORDER_SIZE = 1000;

        public BorderEditor(PropertyAccessor<Border, BorderProperty> propertyAccessor) {
            this.pa = propertyAccessor;
            Border border = propertyAccessor.getValue(Border.ZERO);
            int n = propertyAccessor.getProperty().getMinValue();
            boolean bl = propertyAccessor.getProperty().isAllowFormula();
            this.useFormula = new SimpleBooleanModel(border instanceof BorderFormula);
            this.modelTop = new SimpleIntegerModel(n, 1000, border.getBorderTop());
            this.modelLeft = new SimpleIntegerModel(n, 1000, border.getBorderLeft());
            this.modelBottom = new SimpleIntegerModel(n, 1000, border.getBorderBottom());
            this.modelRight = new SimpleIntegerModel(n, 1000, border.getBorderRight());
            this.adjusters = new ValueAdjusterInt[]{new ValueAdjusterInt((IntegerModel)this.modelTop), new ValueAdjusterInt((IntegerModel)this.modelLeft), new ValueAdjusterInt((IntegerModel)this.modelBottom), new ValueAdjusterInt((IntegerModel)this.modelRight)};
            this.adjusters[0].setDisplayPrefix("T: ");
            this.adjusters[1].setDisplayPrefix("L: ");
            this.adjusters[2].setDisplayPrefix("B: ");
            this.adjusters[3].setDisplayPrefix("R: ");
            this.modelTop.addCallback((Runnable)this);
            this.modelLeft.addCallback((Runnable)this);
            this.modelBottom.addCallback((Runnable)this);
            this.modelRight.addCallback((Runnable)this);
            this.useFormula.addCallback(new Runnable(){

                public void run() {
                    BorderEditor.this.setEnabled();
                    BorderEditor.this.setProperty();
                }
            });
            DialogLayout.Group group = this.createParallelGroup();
            DialogLayout.Group group2 = this.createSequentialGroup();
            if (bl) {
                ToggleButton toggleButton = new ToggleButton((BooleanModel)this.useFormula);
                toggleButton.setTheme("btnUseFormula");
                this.efFormula = new EditField();
                this.efFormula.setText(Utils.toString(border, false));
                this.efFormula.addCallback((EditField.Callback)this);
                group.addGroup(this.createSequentialGroup().addWidget((Widget)toggleButton).addWidget((Widget)this.efFormula));
                group2.addGroup(this.createParallelGroup().addWidget((Widget)toggleButton).addWidget((Widget)this.efFormula));
            } else {
                this.efFormula = null;
            }
            group.addWidgets((Widget[])this.adjusters);
            group2.addWidgetsWithGap("adjuster", (Widget[])this.adjusters);
            this.setHorizontalGroup(group);
            this.setVerticalGroup(group2);
            this.setEnabled();
        }

        @Override
        public void run() {
            this.setProperty();
        }

        public void callback(int n) {
            if (!this.inSetProperty) {
                this.setProperty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setProperty() {
            try {
                BorderFormula borderFormula;
                this.inSetProperty = true;
                if (this.useFormula.getValue()) {
                    String string = this.efFormula.getText();
                    borderFormula = new BorderFormula(string);
                    try {
                        Border border = Utils.parseBorder(string);
                        if (border != null) {
                            this.modelTop.setValue(border.getBorderTop());
                            this.modelLeft.setValue(border.getBorderLeft());
                            this.modelBottom.setValue(border.getBorderBottom());
                            this.modelRight.setValue(border.getBorderRight());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    borderFormula = new Border(this.modelTop.getValue(), this.modelLeft.getValue(), this.modelBottom.getValue(), this.modelRight.getValue());
                    if (this.efFormula != null) {
                        try {
                            if (Utils.parseBorder(this.efFormula.getText()) != null) {
                                this.efFormula.setText(Utils.toString(borderFormula, false));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                this.pa.setValue(borderFormula);
            }
            finally {
                this.inSetProperty = false;
            }
        }

        void setEnabled() {
            if (this.efFormula != null) {
                this.efFormula.setEnabled(this.useFormula.getValue());
            }
            for (ValueAdjusterInt valueAdjusterInt : this.adjusters) {
                valueAdjusterInt.setEnabled(!this.useFormula.getValue());
            }
        }
    }
}

