/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.Alignment;
import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.InfoWindow;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ValueAdjusterInt;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.AbstractIntegerModel;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.renderer.AnimationState;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class IntegerArrayEditor
extends DialogLayout {
    public static final AnimationState.StateKey STATE_ADJUSTER_NOT_FIRST = AnimationState.StateKey.get((String)"adjusterNotFirst");
    public static final AnimationState.StateKey STATE_ADJUSTER_NOT_LAST = AnimationState.StateKey.get((String)"adjusterNotLast");
    public static final AnimationState.StateKey STATE_VBUTTON_NOT_FIRST = AnimationState.StateKey.get((String)"vbuttonNotFirst");
    public static final AnimationState.StateKey STATE_VBUTTON_NOT_LAST = AnimationState.StateKey.get((String)"vbuttonNotLast");
    private final InfoWindow errorInfoWindow;
    private final Label errorInfoLabel;
    private final AddButton addButton = new AddButton();
    private ValueAdjusterInt[] adjusters;
    private RemoveButton[] removeButtons;
    protected String errorMessage;
    protected int[] array;

    protected IntegerArrayEditor() {
        this.errorInfoLabel = new Label();
        this.errorInfoWindow = new InfoWindow((Widget)this);
        this.errorInfoWindow.setTheme("editfield-errorinfowindow");
        this.errorInfoWindow.add((Widget)this.errorInfoLabel);
    }

    protected void init(int[] nArray) {
        this.array = nArray;
        this.buildControlls();
    }

    protected void buildControlls() {
        this.setVerticalGroup(null);
        this.removeAllChildren();
        DialogLayout.Group group = this.createParallelGroup();
        DialogLayout.Group group2 = this.createParallelGroup();
        DialogLayout.Group group3 = this.createSequentialGroup();
        this.adjusters = new ValueAdjusterInt[this.array.length];
        this.removeButtons = new RemoveButton[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            this.adjusters[i] = new ValueAdjusterInt((IntegerModel)new ArrayElementModel(i));
            this.adjusters[i].getAnimationState().setAnimationState(STATE_ADJUSTER_NOT_FIRST, i > 0);
            this.adjusters[i].getAnimationState().setAnimationState(STATE_ADJUSTER_NOT_LAST, i < this.array.length - 1);
            this.removeButtons[i] = new RemoveButton(i);
            this.removeButtons[i].getAnimationState().setAnimationState(STATE_VBUTTON_NOT_FIRST, i > 0);
            this.removeButtons[i].getAnimationState().setAnimationState(STATE_VBUTTON_NOT_LAST, i < this.array.length - 1);
            group.addWidget((Widget)this.adjusters[i]);
            group2.addWidget((Widget)this.removeButtons[i]);
            if (i > 0) {
                group3.addGap("adjuster");
            }
            group3.addGroup(this.createParallelGroup().addWidget((Widget)this.adjusters[i]).addWidget((Widget)this.removeButtons[i]));
        }
        this.setHorizontalGroup(this.createParallelGroup().addGroup(this.createSequentialGroup().addGroup(group).addGroup(group2)).addWidget((Widget)this.addButton, Alignment.LEFT));
        this.setVerticalGroup(this.createSequentialGroup().addGroup(group3).addWidget((Widget)this.addButton));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(this.adjusters));
        arrayList.addAll(Arrays.asList(this.removeButtons));
        arrayList.add(this.addButton);
        this.setWidgetsToEnable(arrayList.toArray(new Widget[arrayList.size()]));
        this.updateButtonEnabled();
    }

    public abstract void setWidgetsToEnable(Widget ... var1);

    protected boolean isValid(int[] nArray) {
        return nArray.length > 0;
    }

    protected int getMinValue(int n) {
        return 0;
    }

    protected int getMaxValue(int n) {
        return Short.MAX_VALUE;
    }

    protected void setValue(int n, int n2) {
        this.array[n] = n2;
        this.updatePropertyCheck();
    }

    protected void setValue(int[] nArray) {
        this.array = nArray;
        this.buildControlls();
        this.updatePropertyCheck();
    }

    protected void updateButtonEnabled() {
        if (this.removeButtons != null) {
            for (RemoveButton removeButton : this.removeButtons) {
                removeButton.updateButtonEnabled();
            }
        }
        this.addButton.updateButtonEnabled();
    }

    protected void updatePropertyCheck() {
        this.updateButtonEnabled();
        if (this.isValid(this.array)) {
            this.errorInfoWindow.closeInfo();
            this.updateProperty();
        } else {
            this.openErrorInfoWindow();
        }
    }

    public void layout() {
        super.layout();
        this.layoutErrorInfoWindow();
    }

    protected void positionChanged() {
        super.positionChanged();
        this.layoutErrorInfoWindow();
    }

    protected void keyboardFocusGained() {
        super.keyboardFocusGained();
        this.openErrorInfoWindow();
    }

    protected void keyboardFocusLost() {
        super.keyboardFocusLost();
        this.errorInfoWindow.closeInfo();
    }

    protected void openErrorInfoWindow() {
        if (this.errorMessage != null && this.hasKeyboardFocus()) {
            this.errorInfoLabel.setText(this.errorMessage);
            this.errorInfoWindow.openInfo();
            this.layoutErrorInfoWindow();
        }
    }

    protected void layoutErrorInfoWindow() {
        this.errorInfoWindow.setSize(this.getWidth(), this.errorInfoWindow.getPreferredHeight());
        this.errorInfoWindow.setPosition(this.getX(), this.getBottom());
    }

    protected abstract void updateProperty();

    protected abstract int getNewValueForAppend(int[] var1);

    class AddButton
    extends ModifyArrayLength {
        AddButton() {
        }

        protected int[] createNewArray() {
            int[] nArray = Arrays.copyOf(IntegerArrayEditor.this.array, IntegerArrayEditor.this.array.length + 1);
            nArray[nArray.length - 1] = IntegerArrayEditor.this.getNewValueForAppend(IntegerArrayEditor.this.array);
            return nArray;
        }
    }

    class ArrayElementModel
    extends AbstractIntegerModel {
        private final int idx;

        public ArrayElementModel(int n) {
            this.idx = n;
        }

        public int getMaxValue() {
            return IntegerArrayEditor.this.getMaxValue(this.idx);
        }

        public int getMinValue() {
            return IntegerArrayEditor.this.getMinValue(this.idx);
        }

        public int getValue() {
            return IntegerArrayEditor.this.array[this.idx];
        }

        public void setValue(int n) {
            IntegerArrayEditor.this.setValue(this.idx, n);
        }
    }

    abstract class ModifyArrayLength
    extends Button
    implements Runnable {
        public ModifyArrayLength() {
            this.addCallback(this);
        }

        protected abstract int[] createNewArray();

        public void run() {
            int[] nArray = this.createNewArray();
            if (IntegerArrayEditor.this.isValid(nArray)) {
                IntegerArrayEditor.this.setValue(nArray);
            }
        }

        public void updateButtonEnabled() {
            this.setEnabled(IntegerArrayEditor.this.isValid(this.createNewArray()));
        }
    }

    class RemoveButton
    extends ModifyArrayLength {
        private final int idx;

        public RemoveButton(int n) {
            this.idx = n;
        }

        protected int[] createNewArray() {
            int[] nArray = new int[IntegerArrayEditor.this.array.length - 1];
            System.arraycopy(IntegerArrayEditor.this.array, 0, nArray, 0, this.idx);
            System.arraycopy(IntegerArrayEditor.this.array, this.idx + 1, nArray, this.idx, nArray.length - this.idx);
            return nArray;
        }
    }
}

