/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.KeyStroke;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStrokeEditorFactory
implements PropertyEditorFactory<KeyStroke, Property<KeyStroke>> {
    public static final AnimationState.StateKey STATE_ERROR = AnimationState.StateKey.get((String)"error");

    @Override
    public Widget create(PropertyAccessor<KeyStroke, Property<KeyStroke>> propertyAccessor) {
        KeyStrokeEditor keyStrokeEditor = new KeyStrokeEditor(propertyAccessor);
        return keyStrokeEditor.button;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class KeyStrokeEditor {
        final PropertyAccessor<KeyStroke, Property<KeyStroke>> pa;
        final Button button;

        public KeyStrokeEditor(PropertyAccessor<KeyStroke, Property<KeyStroke>> propertyAccessor) {
            this.pa = propertyAccessor;
            this.button = new Button();
            this.button.setTheme("keyStrokeEditor");
            this.button.addCallback(new Runnable(){

                public void run() {
                    KeyStrokeEditor.this.editKeyStroke();
                }
            });
            propertyAccessor.getProperty().addValueChangedCallback(new Runnable(){

                public void run() {
                    KeyStrokeEditor.this.valueChanged();
                }
            });
            this.valueChanged();
        }

        void valueChanged() {
            KeyStroke keyStroke = (KeyStroke)this.pa.getProperty().getPropertyValue();
            if (keyStroke == null) {
                this.button.setText("INVALID");
                this.button.getAnimationState().setAnimationState(STATE_ERROR, true);
            } else {
                this.button.setText(keyStroke.getStroke());
                this.button.getAnimationState().setAnimationState(STATE_ERROR, false);
            }
        }

        void editKeyStroke() {
            KeyStroke keyStroke = (KeyStroke)this.pa.getProperty().getPropertyValue();
            final KeyStrokePopup keyStrokePopup = new KeyStrokePopup((Widget)this.button, keyStroke != null ? keyStroke.getAction() : "dummy");
            keyStrokePopup.setKeyStroke(keyStroke);
            keyStrokePopup.btnOk.addCallback(new Runnable(){

                public void run() {
                    keyStrokePopup.closePopup();
                    KeyStrokeEditor.this.pa.setValue(keyStrokePopup.keyStroke);
                }
            });
            keyStrokePopup.btnCancel.addCallback(new Runnable(){

                public void run() {
                    keyStrokePopup.closePopup();
                }
            });
            keyStrokePopup.openPopupCentered();
            keyStrokePopup.currentStrokeLabel.requestKeyboardFocus();
        }
    }

    static final class KeyStrokePopup
    extends PopupWindow {
        final Button btnOk;
        final Button btnCancel;
        final Label currentStrokeLabel;
        final String action;
        KeyStroke keyStroke;

        public KeyStrokePopup(Widget widget, String string) {
            super(widget);
            this.action = string;
            this.btnOk = new Button("Ok");
            this.btnCancel = new Button("Cancel");
            this.currentStrokeLabel = new Label();
            Label label = new Label("Press the desired keystroke");
            label.setTheme("title");
            label.setLabelFor((Widget)this.currentStrokeLabel);
            DialogLayout dialogLayout = new DialogLayout();
            dialogLayout.setTheme("content");
            dialogLayout.setHorizontalGroup(dialogLayout.createParallelGroup().addWidget((Widget)label).addGroup(dialogLayout.createSequentialGroup().addGap("left-msg").addWidget((Widget)this.currentStrokeLabel).addGap("msg-right")).addGroup(dialogLayout.createSequentialGroup().addGap("left-btnOk").addWidget((Widget)this.btnOk).addGap("btnOk-btnCancel").addWidget((Widget)this.btnCancel).addGap("btnCancel-right")));
            dialogLayout.setVerticalGroup(dialogLayout.createSequentialGroup().addWidget((Widget)label).addGap("title-msg").addWidget((Widget)this.currentStrokeLabel).addGap("msg-buttons").addGroup(dialogLayout.createParallelGroup(new Widget[]{this.btnOk, this.btnCancel})));
            this.add((Widget)dialogLayout);
            this.setCanAcceptKeyboardFocus(true);
            this.setCloseOnEscape(false);
        }

        protected boolean handleEventPopup(Event event) {
            if (event.isKeyPressedEvent() && !this.isModifierKey(event.getKeyCode())) {
                this.setKeyStroke(KeyStroke.fromEvent((Event)event, (String)this.action));
            }
            return super.handleEventPopup(event);
        }

        void setKeyStroke(KeyStroke keyStroke) {
            this.keyStroke = keyStroke;
            this.currentStrokeLabel.setText(keyStroke != null ? keyStroke.getStroke() : "INVALID");
        }

        private boolean isModifierKey(int n) {
            switch (n) {
                case 29: 
                case 42: 
                case 54: 
                case 56: 
                case 157: 
                case 184: 
                case 219: 
                case 220: {
                    return true;
                }
            }
            return false;
        }
    }
}

