/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.properties.NameProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameEditorFactory
implements PropertyEditorFactory<String, NameProperty> {
    @Override
    public Widget create(final PropertyAccessor<String, NameProperty> propertyAccessor) {
        final Button button = new Button();
        final EditField editField = new EditField();
        final Runnable runnable = new Runnable(){

            public void run() {
                try {
                    propertyAccessor.setValue(editField.getText());
                    editField.setErrorMessage(null);
                    button.setEnabled(false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    editField.setErrorMessage((Object)illegalArgumentException.getMessage());
                }
            }
        };
        button.setTheme("applybutton");
        button.addCallback(runnable);
        button.setEnabled(false);
        editField.setText(propertyAccessor.getValue(""));
        editField.addCallback(new EditField.Callback(){

            public void callback(int n) {
                if (n == 28) {
                    if (button.isEnabled()) {
                        runnable.run();
                    }
                } else {
                    String string = editField.getText();
                    try {
                        ((NameProperty)propertyAccessor.getProperty()).validateName(string);
                        editField.setErrorMessage(null);
                        button.setEnabled(!propertyAccessor.getValue("").equals(string));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        editField.setErrorMessage((Object)illegalArgumentException.getMessage());
                        button.setEnabled(false);
                    }
                }
            }
        });
        propertyAccessor.setFocusWidgetCB(new Runnable(){

            public void run() {
                if (!editField.hasKeyboardFocus() && editField.requestKeyboardFocus()) {
                    editField.selectAll();
                }
            }
        });
        DialogLayout dialogLayout = new DialogLayout();
        dialogLayout.setTheme("nameeditor");
        dialogLayout.setHorizontalGroup(dialogLayout.createSequentialGroup(new Widget[]{editField, button}));
        dialogLayout.setVerticalGroup(dialogLayout.createParallelGroup(new Widget[]{editField, button}));
        return dialogLayout;
    }
}

