/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.ComboBox;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Menu;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.AutoCompletionDataSource;
import de.matthiasmann.twl.model.AutoCompletionResult;
import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.model.SimpleAutoCompletionResult;
import de.matthiasmann.twl.utils.NaturalSortComparator;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.NodeReference;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.gui.Context;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.properties.NodeReferenceProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeReferenceEditorFactory
implements PropertyEditorFactory<NodeReference, NodeReferenceProperty> {
    private final Context ctx;

    public NodeReferenceEditorFactory(Context context) {
        this.ctx = context;
    }

    @Override
    public Widget create(final PropertyAccessor<NodeReference, NodeReferenceProperty> propertyAccessor) {
        ThemeTreeNode themeTreeNode = propertyAccessor.getProperty().getLimit();
        NodeReference nodeReference = propertyAccessor.getValue(null);
        final Kind kind = propertyAccessor.getProperty().getKind();
        final ListModel<String> listModel = this.ctx.getRefableNodes(themeTreeNode, kind);
        final Button button = new Button();
        button.setTheme("jumpbutton");
        button.setEnabled(nodeReference != null && !nodeReference.isNone());
        button.addCallback(new Runnable(){

            public void run() {
                NodeReference nodeReference = propertyAccessor.getValue(null);
                if (nodeReference != null && !nodeReference.isNone()) {
                    if (nodeReference.isWildcard()) {
                        ArrayList<ThemeTreeNode> arrayList = new ArrayList<ThemeTreeNode>();
                        NodeReferenceEditorFactory.this.ctx.resolveReference(nodeReference, arrayList);
                        Menu menu = new Menu();
                        if (arrayList.isEmpty()) {
                            menu.add("No target found", (Runnable)null);
                        } else {
                            for (final ThemeTreeNode themeTreeNode : arrayList) {
                                menu.add(themeTreeNode.getName(), new Runnable(){

                                    public void run() {
                                        NodeReferenceEditorFactory.this.ctx.selectTarget(themeTreeNode);
                                    }
                                });
                            }
                        }
                        menu.openPopupMenu((Widget)button);
                    } else {
                        NodeReferenceEditorFactory.this.ctx.selectTarget(nodeReference);
                    }
                }
            }
        });
        DialogLayout dialogLayout = new DialogLayout();
        dialogLayout.setTheme("nodereferenceeditor");
        if (propertyAccessor.getProperty().isSupportsWildcard()) {
            final Button button2 = new Button();
            final EditField editField = new EditField();
            final Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        NodeReference nodeReference = NodeReferenceEditorFactory.this.makeReference(editField.getText(), kind);
                        propertyAccessor.setValue(nodeReference);
                        editField.setErrorMessage(null);
                        button2.setEnabled(false);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        editField.setErrorMessage((Object)illegalArgumentException.getMessage());
                    }
                }
            };
            button2.setTheme("applybutton");
            button2.addCallback(runnable);
            button2.setEnabled(false);
            editField.setText(nodeReference != null ? nodeReference.toString() : "none");
            editField.addCallback(new EditField.Callback(){
                boolean lastKeyWasEscape;

                public void callback(int n) {
                    if (n == 28) {
                        if (button2.isEnabled()) {
                            runnable.run();
                        }
                    } else if (n == 1) {
                        if (this.lastKeyWasEscape) {
                            NodeReference nodeReference = propertyAccessor.getValue(null);
                            editField.setText(nodeReference != null ? nodeReference.toString() : "none");
                            editField.setErrorMessage(null);
                            button.setEnabled(NodeReferenceEditorFactory.this.targetExists(nodeReference));
                            button2.setEnabled(false);
                        }
                    } else {
                        String string = null;
                        boolean bl = false;
                        boolean bl2 = false;
                        if (editField.getTextLength() > 0) {
                            try {
                                NodeReference nodeReference = NodeReferenceEditorFactory.this.makeReference(editField.getText(), kind);
                                bl2 = bl = NodeReferenceEditorFactory.this.targetExists(nodeReference);
                                if (!bl) {
                                    if (!nodeReference.isWildcard()) {
                                        string = "Referenced " + kind.toString().toLowerCase() + " not found";
                                    } else {
                                        bl2 = true;
                                    }
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                string = illegalArgumentException.getMessage();
                            }
                        }
                        editField.setErrorMessage(string);
                        button.setEnabled(bl);
                        button2.setEnabled(bl2);
                    }
                    this.lastKeyWasEscape = n == 1;
                }
            });
            editField.setAutoCompletion(new AutoCompletionDataSource(){

                public AutoCompletionResult collectSuggestions(String string, int n, AutoCompletionResult autoCompletionResult) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    HashSet<String> hashSet = new HashSet<String>();
                    int n2 = listModel.getNumEntries();
                    for (int i = 0; i < n2; ++i) {
                        String string2 = (String)listModel.getEntry(i);
                        if (!string2.startsWith(string)) continue;
                        arrayList.add(string2);
                        int n3 = string2.indexOf(46, string.length());
                        if (n3 < 0) continue;
                        hashSet.add(string2.substring(0, n3).concat(".*"));
                    }
                    if (string.endsWith(".")) {
                        arrayList.add(string.concat("*"));
                    }
                    if (arrayList.isEmpty() && hashSet.isEmpty()) {
                        return null;
                    }
                    arrayList.addAll(hashSet);
                    Collections.sort(arrayList, NaturalSortComparator.stringComparator);
                    return new SimpleAutoCompletionResult(string, n, arrayList);
                }
            });
            dialogLayout.setHorizontalGroup(dialogLayout.createSequentialGroup(new Widget[]{editField, button2, button}));
            dialogLayout.setVerticalGroup(dialogLayout.createParallelGroup(new Widget[]{editField, button2, button}));
        } else {
            final ComboBox comboBox = new ComboBox(listModel);
            int n = -1;
            if (nodeReference != null && (n = Utils.find(listModel, nodeReference.getName())) < 0) {
                comboBox.setDisplayTextNoSelection(nodeReference.getName());
                comboBox.setNoSelectionIsError(true);
            }
            comboBox.setSelected(n);
            comboBox.addCallback(new Runnable(){

                public void run() {
                    int n = comboBox.getSelected();
                    if (n >= 0) {
                        NodeReference nodeReference = new NodeReference((String)listModel.getEntry(n), kind);
                        propertyAccessor.setValue(nodeReference);
                        button.setEnabled(!nodeReference.isNone());
                    }
                }
            });
            dialogLayout.setHorizontalGroup(dialogLayout.createSequentialGroup(new Widget[]{comboBox, button}));
            dialogLayout.setVerticalGroup(dialogLayout.createParallelGroup(new Widget[]{comboBox, button}));
        }
        return dialogLayout;
    }

    NodeReference makeReference(String string, Kind kind) {
        int n = 46;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                if (i == 0) {
                    throw new IllegalArgumentException("reference can't start with a '.'");
                }
                if (n == 46) {
                    throw new IllegalArgumentException("reference must not contain \"..\"");
                }
            } else if (c == '*') {
                if (i != string.length() - 1 || i == 0) {
                    throw new IllegalArgumentException("wildcard may only appear at the end");
                }
                if (n != 46) {
                    throw new IllegalArgumentException("wildcard must follow a '.'");
                }
            } else if (!Character.isJavaIdentifierPart(c) && c != '-') {
                throw new IllegalArgumentException("reference contains invalid character: " + c);
            }
            n = c;
        }
        if (n == 46) {
            throw new IllegalArgumentException("reference can't end with '.'");
        }
        return new NodeReference(string, kind);
    }

    boolean targetExists(NodeReference nodeReference) {
        if (nodeReference.isNone()) {
            return true;
        }
        ArrayList<ThemeTreeNode> arrayList = new ArrayList<ThemeTreeNode>();
        this.ctx.resolveReference(nodeReference, arrayList);
        return !arrayList.isEmpty();
    }
}

