/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.ValueAdjusterInt;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twlthemeeditor.datamodel.Split;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.properties.SplitProperty;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitEditorFactory
implements PropertyEditorFactory<Split, SplitProperty> {
    public static final AnimationState.StateKey STATE_ADJUSTER_NOT_FIRST = AnimationState.StateKey.get((String)"adjusterNotFirst");
    public static final AnimationState.StateKey STATE_ADJUSTER_NOT_LAST = AnimationState.StateKey.get((String)"adjusterNotLast");
    public static final AnimationState.StateKey STATE_RADIOBUTTON_NOT_FIRST = AnimationState.StateKey.get((String)"radiobuttonNotFirst");
    public static final AnimationState.StateKey STATE_RADIOBUTTON_NOT_LAST = AnimationState.StateKey.get((String)"radiobuttonNotLast");

    @Override
    public Widget create(PropertyAccessor<Split, SplitProperty> propertyAccessor) {
        return new SplitEditor(propertyAccessor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SplitEditor
    extends DialogLayout {
        private static final Split DEFAULT_SPLIT = new Split(new Split.Point(0, false), new Split.Point(0, true));
        private final PropertyAccessor<Split, SplitProperty> pa;

        public SplitEditor(PropertyAccessor<Split, SplitProperty> propertyAccessor) {
            String string;
            String string2;
            this.pa = propertyAccessor;
            DialogLayout.Group group = this.createParallelGroup();
            DialogLayout.Group group2 = this.createParallelGroup();
            DialogLayout.Group group3 = this.createParallelGroup();
            DialogLayout.Group group4 = this.createSequentialGroup();
            if (propertyAccessor.getProperty().getName().startsWith("Split X")) {
                string2 = "btnRelativeLeft";
                string = "btnRelativeRight";
            } else {
                string2 = "btnRelativeTop";
                string = "btnRelativeBottom";
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(6);
            for (int i = 0; i < 2; ++i) {
                ValueAdjusterInt valueAdjusterInt = new ValueAdjusterInt((IntegerModel)new SplitIntegerModel(i));
                valueAdjusterInt.getAnimationState().setAnimationState(STATE_ADJUSTER_NOT_FIRST, i == 1);
                valueAdjusterInt.getAnimationState().setAnimationState(STATE_ADJUSTER_NOT_LAST, i == 0);
                ToggleButton toggleButton = new ToggleButton((BooleanModel)new EdgeBooleanModel(i, false));
                ToggleButton toggleButton2 = new ToggleButton((BooleanModel)new EdgeBooleanModel(i, true));
                toggleButton.setTheme(string2);
                toggleButton2.setTheme(string);
                toggleButton.getAnimationState().setAnimationState(STATE_RADIOBUTTON_NOT_LAST, true);
                toggleButton2.getAnimationState().setAnimationState(STATE_RADIOBUTTON_NOT_FIRST, true);
                if (i > 0) {
                    group4.addGap("adjuster");
                }
                group.addWidget((Widget)valueAdjusterInt);
                group2.addWidget((Widget)toggleButton);
                group3.addWidget((Widget)toggleButton2);
                group4.addGroup(this.createParallelGroup().addWidget((Widget)valueAdjusterInt).addWidget((Widget)toggleButton).addWidget((Widget)toggleButton2));
                arrayList.add(valueAdjusterInt);
                arrayList.add(toggleButton);
                arrayList.add(toggleButton2);
            }
            propertyAccessor.setWidgetsToEnable(arrayList.toArray(new Widget[arrayList.size()]));
            this.setHorizontalGroup(this.createSequentialGroup().addGroup(group).addGroup(group2).addGap("radiobutton").addGroup(group3));
            this.setVerticalGroup(group4);
        }

        Split getSplit() {
            return this.pa.getValue(DEFAULT_SPLIT);
        }

        Split getSplitDirect() {
            Split split = this.pa.getProperty().getPropertyValue();
            return split != null ? split : DEFAULT_SPLIT;
        }

        class EdgeBooleanModel
        implements BooleanModel {
            final int idx;
            final boolean thisEdge;

            public EdgeBooleanModel(int n, boolean bl) {
                this.idx = n;
                this.thisEdge = bl;
            }

            public boolean getValue() {
                return SplitEditor.this.getSplit().getPoint(this.idx).isOtherEdge() == this.thisEdge;
            }

            public void setValue(boolean bl) {
                if (bl) {
                    int n = ((SplitProperty)SplitEditor.this.pa.getProperty()).getLimit();
                    Split split = SplitEditor.this.getSplitDirect();
                    Split.Point point = split.getPoint(this.idx);
                    Split.Point point2 = point.setOtherEdge(this.thisEdge, n);
                    SplitEditor.this.pa.setValue(split.setPoint(this.idx, point2));
                }
            }

            public void addCallback(Runnable runnable) {
                ((SplitProperty)SplitEditor.this.pa.getProperty()).addCallback(runnable);
            }

            public void removeCallback(Runnable runnable) {
                ((SplitProperty)SplitEditor.this.pa.getProperty()).removeCallback(runnable);
            }
        }

        class SplitIntegerModel
        implements IntegerModel {
            final int idx;

            public SplitIntegerModel(int n) {
                this.idx = n;
            }

            public int getMaxValue() {
                return ((SplitProperty)SplitEditor.this.pa.getProperty()).getLimit();
            }

            public int getMinValue() {
                return 0;
            }

            public int getValue() {
                return SplitEditor.this.getSplit().getPoint(this.idx).getPos();
            }

            public void setValue(int n) {
                Split split = SplitEditor.this.getSplitDirect();
                SplitEditor.this.pa.setValue(split.setPoint(this.idx, split.getPoint(this.idx).setPos(n)));
            }

            public void addCallback(Runnable runnable) {
                ((SplitProperty)SplitEditor.this.pa.getProperty()).addCallback(runnable);
            }

            public void removeCallback(Runnable runnable) {
                ((SplitProperty)SplitEditor.this.pa.getProperty()).removeCallback(runnable);
            }
        }
    }
}

