/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.Widget;
import de.matthiasmann.twlthemeeditor.datamodel.Weights;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.IntegerArrayEditor;
import de.matthiasmann.twlthemeeditor.properties.WeightsProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightsEditorFactory
implements PropertyEditorFactory<Weights, WeightsProperty> {
    @Override
    public Widget create(PropertyAccessor<Weights, WeightsProperty> propertyAccessor) {
        return new WeightsEditor(propertyAccessor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WeightsEditor
    extends IntegerArrayEditor {
        private final PropertyAccessor<Weights, WeightsProperty> pa;
        private static final Weights DEFAULT_WEIGHTS = new Weights(1);

        public WeightsEditor(PropertyAccessor<Weights, WeightsProperty> propertyAccessor) {
            this.pa = propertyAccessor;
            this.init(propertyAccessor.getValue(DEFAULT_WEIGHTS).getWeights());
        }

        @Override
        protected void updateProperty() {
            this.pa.setValue(new Weights(this.array));
        }

        @Override
        protected boolean isValid(int[] nArray) {
            int n = 0;
            for (int n2 : nArray) {
                if (n2 < 0) {
                    this.errorMessage = "No negative weights allowed";
                    return false;
                }
                n += n2;
            }
            if (n > 0) {
                this.errorMessage = null;
                return true;
            }
            this.errorMessage = "Sum of all weights must be >= 1";
            return false;
        }

        @Override
        protected int getNewValueForAppend(int[] nArray) {
            return 1;
        }

        @Override
        public void setWidgetsToEnable(Widget ... widgetArray) {
            this.pa.setWidgetsToEnable(widgetArray);
        }
    }
}

