/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.imgconv;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.ComboBox;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.SplitPane;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.model.SimpleBooleanModel;
import de.matthiasmann.twl.model.SimpleChangableListModel;
import de.matthiasmann.twlthemeeditor.fontgen.gui.EffectsPanel;
import de.matthiasmann.twlthemeeditor.fontgen.gui.FontGenDialog;
import de.matthiasmann.twlthemeeditor.gui.DecoratedTextRenderer;
import de.matthiasmann.twlthemeeditor.gui.SaveFileSelector;
import de.matthiasmann.twlthemeeditor.imgconv.ImageData;
import de.matthiasmann.twlthemeeditor.imgconv.ImageDisplay;
import de.matthiasmann.twlthemeeditor.imgconv.ImageGenerator;
import de.matthiasmann.twlthemeeditor.imgconv.ImageSelectPopup;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public final class ConvertImageDialog
extends PopupWindow {
    private static final String IMAGECONV_FILE_SELECTOR_KEY = "saveImage";
    private final EditField imagePathEF = new EditField();
    private final Button selectImageBtn;
    private final SimpleBooleanModel excludeZeroDelayFramesModel;
    private final ToggleButton excludeZeroDelayFramesBtn;
    private final ComboBox<ImageDisplayBG> imageDisplayBgCB;
    private final ImageDisplay imageDisplay;
    private final Label statusBar;
    private final Button saveImageButton;
    private final Button closeButton;
    private String imagePath;
    private ImageData imageData;

    public ConvertImageDialog(Widget widget) {
        super(widget);
        this.imagePathEF.setReadOnly(true);
        this.selectImageBtn = new Button();
        this.selectImageBtn.setTheme("selectImageBtn");
        this.selectImageBtn.addCallback(new Runnable(){

            public void run() {
                ConvertImageDialog.this.selectImage();
            }
        });
        this.excludeZeroDelayFramesModel = new SimpleBooleanModel(true);
        this.excludeZeroDelayFramesModel.addCallback(new Runnable(){

            public void run() {
                ConvertImageDialog.this.updateExcludeZeroDelayFrames();
            }
        });
        this.excludeZeroDelayFramesBtn = new ToggleButton((BooleanModel)this.excludeZeroDelayFramesModel);
        this.excludeZeroDelayFramesBtn.setTheme("checkbox");
        this.excludeZeroDelayFramesBtn.setText("Exclude frames with 0 delay");
        this.imageDisplayBgCB = new ComboBox((ListModel)new SimpleChangableListModel((Object[])ImageDisplayBG.values()));
        this.imageDisplayBgCB.setSelected(0);
        this.imageDisplayBgCB.addCallback(new Runnable(){

            public void run() {
                ConvertImageDialog.this.setImageDisplayTheme();
            }
        });
        EffectsPanel effectsPanel = new EffectsPanel();
        ScrollPane scrollPane = new ScrollPane((Widget)effectsPanel);
        scrollPane.setTheme("effectsPanel");
        scrollPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        scrollPane.setExpandContentSize(true);
        effectsPanel.addControl("Image", (Widget)this.imagePathEF, this.selectImageBtn);
        effectsPanel.addControl((Widget)this.excludeZeroDelayFramesBtn);
        this.imageDisplay = new ImageDisplay(new Runnable(){

            public void run() {
                ConvertImageDialog.this.updateStatusBar();
            }
        });
        ScrollPane scrollPane2 = new ScrollPane((Widget)this.imageDisplay);
        scrollPane2.setTheme("imageDisplay");
        this.saveImageButton = new Button("Save Image");
        this.saveImageButton.addCallback(new Runnable(){

            public void run() {
                ConvertImageDialog.this.saveImage();
            }
        });
        this.closeButton = new Button("Close");
        this.closeButton.addCallback(new Runnable(){

            public void run() {
                ConvertImageDialog.this.closePopup();
            }
        });
        this.statusBar = new Label();
        this.statusBar.setTheme("statusBar");
        SplitPane splitPane = new SplitPane();
        splitPane.setDirection(SplitPane.Direction.HORIZONTAL);
        splitPane.setSplitPosition(370);
        splitPane.add((Widget)scrollPane);
        splitPane.add((Widget)scrollPane2);
        effectsPanel.addControl("Preview BG", (Widget)this.imageDisplayBgCB);
        DialogLayout dialogLayout = new DialogLayout();
        DialogLayout.Group group = dialogLayout.createSequentialGroup().addWidget((Widget)this.statusBar).addWidget((Widget)this.saveImageButton).addWidget((Widget)this.closeButton);
        DialogLayout.Group group2 = dialogLayout.createParallelGroup().addWidget((Widget)this.statusBar).addWidget((Widget)this.saveImageButton).addWidget((Widget)this.closeButton);
        dialogLayout.setHorizontalGroup(dialogLayout.createParallelGroup().addWidget((Widget)splitPane).addGroup(group));
        dialogLayout.setVerticalGroup(dialogLayout.createSequentialGroup().addWidget((Widget)splitPane).addGroup(group2));
        this.add((Widget)dialogLayout);
        this.setCloseOnClickedOutside(false);
        this.setImageDisplayTheme();
        this.updateExcludeZeroDelayFrames();
        this.updateStatusBar();
    }

    public boolean openPopup() {
        if (super.openPopup()) {
            int n = this.getGUI().getInnerWidth();
            int n2 = this.getGUI().getInnerHeight();
            this.setSize(n * 4 / 5, n2 * 4 / 5);
            this.setPosition(n / 2 - this.getWidth() / 2, n2 / 2 - this.getHeight() / 2);
            return true;
        }
        return false;
    }

    void setImageDisplayTheme() {
        ImageDisplayBG imageDisplayBG = (ImageDisplayBG)((Object)this.imageDisplayBgCB.getModel().getEntry(this.imageDisplayBgCB.getSelected()));
        this.imageDisplay.setTheme(imageDisplayBG.theme);
        this.imageDisplay.reapplyTheme();
    }

    void selectImage() {
        ImageSelectPopup imageSelectPopup = new ImageSelectPopup((Widget)this.selectImageBtn);
        imageSelectPopup.addCallback(new ImageSelectPopup.Callback(){

            public void imageSelected(String string, ImageData imageData) {
                ConvertImageDialog.this.imageSelected(string, imageData);
            }
        });
        imageSelectPopup.openPopup();
    }

    void imageSelected(String string, ImageData imageData) {
        this.imagePath = string;
        this.imageData = imageData;
        this.imagePathEF.setText(string);
        this.imageDisplay.setImageData(imageData);
    }

    void updateExcludeZeroDelayFrames() {
        this.imageDisplay.setSkipZeroDelayFrames(this.excludeZeroDelayFramesModel.getValue());
    }

    void saveImage() {
        final ImageGenerator imageGenerator = this.imageDisplay.getLastImageGen();
        if (imageGenerator == null) {
            return;
        }
        SaveFileSelector saveFileSelector = new SaveFileSelector((Widget)this.saveImageButton, Preferences.userNodeForPackage(ConvertImageDialog.class), IMAGECONV_FILE_SELECTOR_KEY, "PNG files", ".png", new SaveFileSelector.Callback(){

            public File[] getFilesCreatedForFileName(File file) {
                return imageGenerator.getFilesCreatedForName(file);
            }

            public void fileNameSelected(File file) {
                try {
                    imageGenerator.write(file);
                }
                catch (IOException iOException) {
                    Logger.getLogger(FontGenDialog.class.getName()).log(Level.SEVERE, "Cound not save image", iOException);
                }
            }

            public void canceled() {
            }
        });
        saveFileSelector.openPopup();
    }

    void updateStatusBar() {
        ImageGenerator imageGenerator = this.imageDisplay.getLastImageGen();
        if (imageGenerator == null) {
            this.setStatusBar("Select an image", 1);
            return;
        }
        if (imageGenerator.getNumFrames() == 0) {
            this.setStatusBar("No frames found in selected image", 1);
            return;
        }
        if (imageGenerator.isCutoff()) {
            this.setStatusBar("Not all frames could fit onto the maximum texture size of 4096", 2);
        }
        this.setStatusBar("Used texture size is " + imageGenerator.getWidth() + "x" + imageGenerator.getHeight(), 0);
    }

    private void setStatusBar(String string, int n) {
        this.statusBar.setText(string);
        DecoratedTextRenderer.setAnimationState(this.statusBar.getAnimationState(), n);
        this.saveImageButton.setEnabled((n & 1) == 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ImageDisplayBG {
        BLACK("Black", "imagedisplay-black"),
        WHITE("White", "imagedisplay-white"),
        CHECKERBOARD("Checker board", "imagedisplay-checkerboard");

        final String text;
        final String theme;

        private ImageDisplayBG(String string2, String string3) {
            this.text = string2;
            this.theme = string3;
        }

        public String toString() {
            return this.text;
        }
    }
}

