/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.imgconv;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageData {
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private final ImageReader imageReader;
    private final int numImages;
    private final BufferedImage[] images;
    private final GIFImageMetadata[] gifImagesMetadata;
    private int backgroundColorIndex;
    private Node globalColorTable;
    private BufferedImage backgroundForNext;
    private Rectangle eraseForNext;
    private int lastImgNr;

    private ImageData(ImageReader imageReader, int n) throws IOException {
        this.imageReader = imageReader;
        this.numImages = n;
        this.images = new BufferedImage[n];
        IIOMetadata iIOMetadata = imageReader.getStreamMetadata();
        Node node = ImageData.getMetaDataTree(iIOMetadata, "javax_imageio_gif_stream_1.0");
        if (node != null) {
            this.gifImagesMetadata = new GIFImageMetadata[n];
            Node node2 = ImageData.getChildNode(node, "LogicalScreenDescriptor");
            int n2 = ImageData.getInt(node2, "logicalScreenWidth", 0);
            int n3 = ImageData.getInt(node2, "logicalScreenHeight", 0);
            if (n2 <= 0 || n3 <= 0) {
                for (int i = 0; i < n; ++i) {
                    GIFImageMetadata gIFImageMetadata = this.getGIFImageMetadata(i);
                    n2 = Math.max(n2, gIFImageMetadata.imageLeftPosition + gIFImageMetadata.imageWidth);
                    n3 = Math.max(n3, gIFImageMetadata.imageTopPosition + gIFImageMetadata.imageHeight);
                }
            }
            this.backgroundForNext = new BufferedImage(n2, n3, 2);
            this.globalColorTable = ImageData.getChildNode(node, "GlobalColorTable");
            this.backgroundColorIndex = ImageData.getInt(this.globalColorTable, "backgroundColorIndex", -1);
            this.eraseForNext = new Rectangle(0, 0, n2, n3);
        } else {
            this.gifImagesMetadata = null;
        }
    }

    public int getNumImages() {
        return this.numImages;
    }

    public BufferedImage getImage(int n) {
        this.decodeTo(n);
        return this.images[n];
    }

    public int getDelayMS(int n) {
        if (this.gifImagesMetadata != null) {
            GIFImageMetadata gIFImageMetadata = this.getGIFImageMetadata(n);
            return gIFImageMetadata.delayTimeMS;
        }
        return 100;
    }

    public static ImageData create(File file) {
        try {
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            if (imageInputStream != null) {
                Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                while (iterator.hasNext()) {
                    ImageReader imageReader = iterator.next();
                    imageReader.setInput(imageInputStream);
                    try {
                        int n = imageReader.getNumImages(true);
                        if (n < 1) continue;
                        return new ImageData(imageReader, n);
                    }
                    catch (IOException iOException) {
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private GIFImageMetadata getGIFImageMetadata(int n) {
        GIFImageMetadata gIFImageMetadata = this.gifImagesMetadata[n];
        if (gIFImageMetadata == null) {
            Node node;
            try {
                IIOMetadata iIOMetadata = this.imageReader.getImageMetadata(n);
                node = ImageData.getMetaDataTree(iIOMetadata, "javax_imageio_gif_image_1.0");
            }
            catch (IOException iOException) {
                node = null;
            }
            this.gifImagesMetadata[n] = gIFImageMetadata = new GIFImageMetadata(node);
        }
        return gIFImageMetadata;
    }

    private void decodeTo(int n) {
        while (this.lastImgNr <= n) {
            this.decodeNextImage();
        }
    }

    private void decodeNextImage() {
        BufferedImage bufferedImage;
        try {
            bufferedImage = this.imageReader.read(this.lastImgNr);
            if (this.gifImagesMetadata != null) {
                bufferedImage = this.postProcessGIF(this.lastImgNr, bufferedImage);
            }
        }
        catch (IOException iOException) {
            bufferedImage = new BufferedImage(1, 1, 2);
        }
        this.images[this.lastImgNr++] = bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage postProcessGIF(int n, BufferedImage bufferedImage) {
        GIFImageMetadata gIFImageMetadata = this.getGIFImageMetadata(n);
        BufferedImage bufferedImage2 = new BufferedImage(this.backgroundForNext.getWidth(), this.backgroundForNext.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage((Image)this.backgroundForNext, 0, 0, null);
            if (this.eraseForNext != null) {
                Color color;
                if (gIFImageMetadata.transparentColorFlag && gIFImageMetadata.transparentColorIndex == this.backgroundColorIndex) {
                    color = TRANSPARENT;
                } else {
                    Node node = ImageData.getChildNodeWithIndex(gIFImageMetadata.localColorTable, "ColorTableEntry", this.backgroundColorIndex);
                    if (node == null) {
                        node = ImageData.getChildNodeWithIndex(this.globalColorTable, "ColorTableEntry", this.backgroundColorIndex);
                    }
                    int n2 = ImageData.getInt(node, "red", 0);
                    int n3 = ImageData.getInt(node, "green", 0);
                    int n4 = ImageData.getInt(node, "blue", 0);
                    color = new Color(n2, n3, n4);
                }
                graphics2D.setColor(color);
                graphics2D.fillRect(this.eraseForNext.x, this.eraseForNext.y, this.eraseForNext.width, this.eraseForNext.height);
            }
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.drawImage((Image)bufferedImage, gIFImageMetadata.imageLeftPosition, gIFImageMetadata.imageTopPosition, null);
        }
        finally {
            graphics2D.dispose();
        }
        bufferedImage = bufferedImage2;
        this.eraseForNext = null;
        if ("doNotDispose".equals(gIFImageMetadata.disposalMethod) || "none".equals(gIFImageMetadata.disposalMethod)) {
            this.backgroundForNext = bufferedImage;
        } else if ("restoreToBackgroundColor".equals(gIFImageMetadata.disposalMethod)) {
            this.eraseForNext = new Rectangle(gIFImageMetadata.imageLeftPosition, gIFImageMetadata.imageTopPosition, gIFImageMetadata.imageWidth, gIFImageMetadata.imageHeight);
        }
        return bufferedImage;
    }

    static Node getMetaDataTree(IIOMetadata iIOMetadata, String string) {
        if (iIOMetadata != null) {
            try {
                return iIOMetadata.getAsTree(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    static Node getChildNode(Node node, String string) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!string.equals(node2.getNodeName())) continue;
                return node2;
            }
        }
        return null;
    }

    static Node getChildNodeWithIndex(Node node, String string, int n) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                int n2;
                Node node2 = nodeList.item(i);
                if (!string.equals(node2.getNodeName()) || (n2 = ImageData.getInt(node2, "index", -1)) != n) continue;
                return node2;
            }
        }
        return null;
    }

    static String getStr(Node node, String string, String string2) {
        Node node2;
        if (node != null && (node2 = node.getAttributes().getNamedItem(string)) != null) {
            return node2.getNodeValue();
        }
        return string2;
    }

    static int getInt(Node node, String string, int n) {
        String string2 = ImageData.getStr(node, string, null);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return n;
    }

    static class GIFImageMetadata {
        final int imageLeftPosition;
        final int imageTopPosition;
        final int imageWidth;
        final int imageHeight;
        final int delayTimeMS;
        final String disposalMethod;
        final int transparentColorIndex;
        final boolean transparentColorFlag;
        final Node localColorTable;

        public GIFImageMetadata(Node node) {
            Node node2 = ImageData.getChildNode(node, "ImageDescriptor");
            this.imageLeftPosition = ImageData.getInt(node2, "imageLeftPosition", 0);
            this.imageTopPosition = ImageData.getInt(node2, "imageTopPosition", 0);
            this.imageWidth = ImageData.getInt(node2, "imageWidth", 1);
            this.imageHeight = ImageData.getInt(node2, "imageHeight", 1);
            Node node3 = ImageData.getChildNode(node, "GraphicControlExtension");
            this.delayTimeMS = ImageData.getInt(node3, "delayTime", 10) * 10;
            this.disposalMethod = ImageData.getStr(node3, "disposalMethod", "none");
            this.transparentColorIndex = ImageData.getInt(node3, "transparentColorIndex", 255);
            this.transparentColorFlag = Boolean.parseBoolean(ImageData.getStr(node3, "transparentColorFlag", "false"));
            this.localColorTable = ImageData.getChildNode(node, "LocalColorTable");
        }
    }
}

