/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.imgconv;

import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.DynamicImage;
import de.matthiasmann.twlthemeeditor.imgconv.ImageData;
import de.matthiasmann.twlthemeeditor.imgconv.ImageGenerator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImageDisplay
extends Widget {
    private final Runnable callback;
    private final GUI.AsyncCompletionListener<ImageGenerator> completionHandler;
    private ImageData imageData;
    private boolean skipZeroDelayFrames;
    private boolean pendingUpdate;
    private boolean updateRunning;
    private ByteBuffer buffer;
    private DynamicImage image;
    private ImageGenerator lastImageGen;

    public ImageDisplay(Runnable runnable) {
        this.callback = runnable;
        this.completionHandler = new GUI.AsyncCompletionListener<ImageGenerator>(){

            public void completed(ImageGenerator imageGenerator) {
                ImageDisplay.this.updateImage(imageGenerator);
            }

            public void failed(Exception exception) {
                ImageDisplay.this.updateDone();
            }
        };
    }

    public void setImageData(ImageData imageData) {
        this.imageData = imageData;
        this.update();
    }

    public void setSkipZeroDelayFrames(boolean bl) {
        this.skipZeroDelayFrames = bl;
        this.update();
    }

    public ImageGenerator getLastImageGen() {
        return this.lastImageGen;
    }

    private void update() {
        GUI gUI = this.getGUI();
        if (gUI != null && this.imageData != null) {
            if (this.updateRunning) {
                this.pendingUpdate = true;
            } else {
                gUI.invokeAsync((Callable)new GenImage(this.imageData, this.skipZeroDelayFrames), this.completionHandler);
                this.updateRunning = true;
            }
        }
    }

    public void destroy() {
        super.destroy();
        this.destroyImage();
    }

    public int getPreferredInnerWidth() {
        return this.image != null ? this.image.getWidth() : 0;
    }

    public int getPreferredInnerHeight() {
        return this.image != null ? this.image.getHeight() : 0;
    }

    protected void paintWidget(GUI gUI) {
        if (this.image != null) {
            this.image.draw((AnimationState)this.getAnimationState(), this.getInnerX(), this.getInnerY());
        }
    }

    private void destroyImage() {
        if (this.image != null) {
            this.image.destroy();
            this.image = null;
        }
    }

    private ByteBuffer getBuffer(int n) {
        if (this.buffer == null || this.buffer.capacity() < n) {
            this.buffer = ByteBuffer.allocateDirect(n);
        }
        this.buffer.clear().limit(n);
        return this.buffer;
    }

    void updateImage(ImageGenerator imageGenerator) {
        Object object;
        this.lastImageGen = imageGenerator;
        if (this.image == null || this.image.getWidth() != imageGenerator.getWidth() || this.image.getHeight() != imageGenerator.getHeight()) {
            this.destroyImage();
            object = this.getGUI();
            if (object != null) {
                this.image = object.getRenderer().createDynamicImage(imageGenerator.getWidth(), imageGenerator.getHeight());
            }
        }
        if (this.image != null) {
            try {
                object = this.getBuffer(imageGenerator.getWidth() * imageGenerator.getHeight() * 4);
                IntBuffer intBuffer = ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
                imageGenerator.getTextureData(intBuffer);
                this.image.update((ByteBuffer)object, DynamicImage.Format.BGRA);
            }
            catch (Throwable throwable) {
                Logger.getLogger(ImageDisplay.class.getName()).log(Level.SEVERE, "Unable to update image", throwable);
            }
            this.invalidateLayout();
        }
        this.updateDone();
    }

    void updateDone() {
        this.updateRunning = false;
        if (this.pendingUpdate) {
            this.pendingUpdate = false;
            this.update();
        }
        this.callback.run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class GenImage
    implements Callable<ImageGenerator> {
        private final ImageData imageData;
        private final boolean skipZeroDelayFrames;

        public GenImage(ImageData imageData, boolean bl) {
            this.imageData = imageData;
            this.skipZeroDelayFrames = bl;
        }

        @Override
        public ImageGenerator call() throws Exception {
            return new ImageGenerator(this.imageData, this.skipZeroDelayFrames);
        }
    }
}

