/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.imgconv;

import de.matthiasmann.twlthemeeditor.fontgen.PNGWriter;
import de.matthiasmann.twlthemeeditor.imgconv.ImageData;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.IntBuffer;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class ImageGenerator {
    public static final int MAX_TEXTURE_SIZE = 4096;
    private final BufferedImage texture;
    private final Frame[] frames;
    private final boolean cutoff;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageGenerator(ImageData imageData, boolean bl) {
        int n;
        int n2;
        int n3 = imageData.getNumImages();
        if (bl) {
            int n4 = n3;
            while (n4-- > 0) {
                if (imageData.getDelayMS(n4) != 0) continue;
                --n3;
            }
        }
        BufferedImage bufferedImage = imageData.getImage(0);
        int n5 = bufferedImage.getWidth() + 1;
        int n6 = bufferedImage.getHeight() + 1;
        for (int i = ImageGenerator.nextPOT(n5); (n2 = (i + 1) / n5) * (n = (i + 1) / n6) < n3 && i != 4096; i <<= 1) {
        }
        n = Math.min(n, (n3 + n2 - 1) / n2);
        int n7 = n2 * n5 - 1;
        int n8 = n * n6 - 1;
        this.frames = new Frame[Math.min(n3, n2 * n)];
        this.cutoff = this.frames.length < n3;
        this.texture = new BufferedImage(n7, n8, 2);
        Graphics2D graphics2D = this.texture.createGraphics();
        try {
            graphics2D.setComposite(AlphaComposite.Src);
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            for (int i = 0; i < imageData.getNumImages() && n11 < n; ++i) {
                int n12 = imageData.getDelayMS(i);
                if (bl && n12 == 0) continue;
                Frame frame = new Frame(n10 * n5, n11 * n6, n5 - 1, n6 - 1, n12);
                this.frames[n9++] = frame;
                graphics2D.drawImage((Image)imageData.getImage(i), frame.x, frame.y, null);
                if (++n10 != n2) continue;
                n10 = 0;
                ++n11;
            }
        }
        finally {
            graphics2D.dispose();
        }
    }

    public boolean isCutoff() {
        return this.cutoff;
    }

    public int getNumFrames() {
        return this.frames.length;
    }

    public int getWidth() {
        return this.texture.getWidth();
    }

    public int getHeight() {
        return this.texture.getHeight();
    }

    public boolean getTextureData(IntBuffer intBuffer) {
        if (this.texture != null) {
            intBuffer.put(((DataBufferInt)this.texture.getRaster().getDataBuffer()).getData());
            return true;
        }
        return false;
    }

    public File[] getFilesCreatedForName(File file) {
        File file2 = file.getParentFile();
        String string = ImageGenerator.getBaseName(file);
        return new File[]{file, new File(file2, string.concat(".xml"))};
    }

    public void write(File file) throws IOException {
        this.writePNG(file);
        this.writeXML(file);
    }

    private void writePNG(File file) throws IOException {
        PNGWriter.write(file, this.texture, this.texture.getHeight());
    }

    private void writeXML(File file) throws IOException {
        File file2 = file.getParentFile();
        String string = ImageGenerator.getBaseName(file);
        File file3 = new File(file2, string.concat(".xml"));
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        try {
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(false);
            XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
            xmlSerializer.setOutput(fileOutputStream, "UTF8");
            xmlSerializer.startDocument("UTF8", true);
            xmlSerializer.text("\n");
            xmlSerializer.startTag(null, "themes");
            xmlSerializer.text("\n  ");
            xmlSerializer.startTag(null, "images");
            xmlSerializer.attribute(null, "file", file.getName());
            xmlSerializer.attribute(null, "format", "COLOR");
            if (this.frames.length > 1) {
                int n;
                for (n = 0; n < this.frames.length; ++n) {
                    xmlSerializer.text("\n    ");
                    xmlSerializer.startTag(null, "area");
                    xmlSerializer.attribute(null, "name", string + "-" + n);
                    xmlSerializer.attribute(null, "xywh", this.frames[n].getXYWH());
                    xmlSerializer.endTag(null, "area");
                }
                xmlSerializer.text("\n    \n    ");
                xmlSerializer.startTag(null, "animation");
                xmlSerializer.attribute(null, "name", string);
                xmlSerializer.attribute(null, "timeSource", "hover");
                for (n = 0; n < this.frames.length; ++n) {
                    xmlSerializer.text("\n      ");
                    xmlSerializer.startTag(null, "frame");
                    xmlSerializer.attribute(null, "duration", Integer.toString(this.frames[n].delayMS));
                    xmlSerializer.attribute(null, "ref", string + "-" + n);
                    xmlSerializer.endTag(null, "frame");
                }
                xmlSerializer.text("\n    ");
                xmlSerializer.endTag(null, "animation");
            } else if (this.frames.length == 1) {
                xmlSerializer.text("\n    ");
                xmlSerializer.startTag(null, "area");
                xmlSerializer.attribute(null, "name", string);
                xmlSerializer.attribute(null, "xywh", this.frames[0].getXYWH());
                xmlSerializer.endTag(null, "area");
            }
            xmlSerializer.text("\n  ");
            xmlSerializer.endTag(null, "images");
            xmlSerializer.text("\n");
            xmlSerializer.endTag(null, "themes");
            xmlSerializer.endDocument();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw (IOException)new IOException().initCause(xmlPullParserException);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    private static String getBaseName(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static int nextPOT(int n) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    public static class Frame {
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public final int delayMS;

        public Frame(int n, int n2, int n3, int n4, int n5) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.delayMS = n5;
        }

        public String getXYWH() {
            return this.x + "," + this.y + "," + this.width + "," + this.height;
        }
    }
}

