/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.imgconv;

import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Timer;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.DynamicImage;
import de.matthiasmann.twlthemeeditor.imgconv.ImageData;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class ImagePreview
extends Widget {
    private static final int WIDTH = 256;
    private static final int HEIGHT = 256;
    private final BufferedImage bi = new BufferedImage(256, 256, 2);
    private final ByteBuffer bb = ByteBuffer.allocateDirect(262144);
    private final IntBuffer ib = this.bb.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
    private boolean imageDirty = true;
    private ImageData imgData;
    private DynamicImage image;
    private Timer timer;
    private int curFrame;

    public ImagePreview() {
        this.setClip(true);
    }

    public void setImageData(ImageData imageData) {
        this.imgData = imageData;
        this.curFrame = 0;
        this.imageDirty = true;
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public int getPreferredInnerWidth() {
        return 256;
    }

    public int getPreferredInnerHeight() {
        return 256;
    }

    public void destroy() {
        super.destroy();
        if (this.image != null) {
            this.image.destroy();
            this.image = null;
        }
    }

    protected void paintWidget(GUI gUI) {
        if (this.imageDirty) {
            this.imageDirty = false;
            this.updateImage(gUI);
        }
        if (this.image != null) {
            this.image.draw((AnimationState)this.getAnimationState(), this.getInnerX(), this.getInnerY());
        }
    }

    protected void afterAddToGUI(GUI gUI) {
        super.afterAddToGUI(gUI);
        this.timer = gUI.createTimer();
        this.timer.setDelay(100);
        this.timer.setCallback(new Runnable(){

            public void run() {
                ImagePreview.this.nextFrame();
            }
        });
        this.startTimer();
    }

    protected void beforeRemoveFromGUI(GUI gUI) {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        super.beforeRemoveFromGUI(gUI);
    }

    void nextFrame() {
        if (this.imgData != null) {
            this.curFrame = (this.curFrame + 1) % this.imgData.getNumImages();
            this.imageDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImage(GUI gUI) {
        if (this.image == null) {
            this.image = gUI.getRenderer().createDynamicImage(256, 256);
        }
        if (this.image != null) {
            Graphics2D graphics2D = this.bi.createGraphics();
            try {
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.setColor(new Color(0, 0, 0, 0));
                graphics2D.fillRect(0, 0, 256, 256);
                if (this.imgData != null) {
                    BufferedImage bufferedImage = this.imgData.getImage(this.curFrame);
                    int n = bufferedImage.getWidth();
                    int n2 = bufferedImage.getHeight();
                    if (n > 256 || n2 > 256) {
                        int n3 = n * 256 / n2;
                        int n4 = n2 * 256 / n;
                        if (n3 > 256) {
                            n = 256;
                            n2 = n4;
                        } else {
                            n = n3;
                            n2 = 256;
                        }
                    }
                    graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
                }
            }
            finally {
                graphics2D.dispose();
            }
            this.ib.clear();
            this.ib.put(((DataBufferInt)this.bi.getRaster().getDataBuffer()).getData());
            this.image.update(this.bb, DynamicImage.Format.BGRA);
        }
        this.startTimer();
    }

    private void startTimer() {
        if (this.imgData != null && this.imgData.getNumImages() > 1 && this.timer != null) {
            int n = Math.max(10, this.imgData.getDelayMS(this.curFrame));
            this.timer.setDelay(n);
            this.timer.start();
        }
    }
}

