/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.imgconv;

import de.matthiasmann.twl.FileSelector;
import de.matthiasmann.twl.FileTable;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.FileSystemModel;
import de.matthiasmann.twl.model.JavaFileSystemModel;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twlthemeeditor.imgconv.ImageData;
import de.matthiasmann.twlthemeeditor.imgconv.ImagePreview;
import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageReaderSpi;

public class ImageSelectPopup
extends PopupWindow {
    private static final String PREF_FS = "imageSelector";
    private final FileSelector fileSelector = new FileSelector(Preferences.userNodeForPackage(ImageSelectPopup.class), "imageSelector");
    private final ImagePreview preview = new ImagePreview();
    private String imagePath;
    private ImageData imageData;
    private Callback[] callbacks;

    public ImageSelectPopup(Widget widget) {
        super(widget);
        HashSet<ImageReaderSpi> hashSet = new HashSet<ImageReaderSpi>();
        for (String object : ImageIO.getReaderFormatNames()) {
            String[] stringArray = ImageIO.getImageReadersByFormatName(object);
            while (stringArray.hasNext()) {
                hashSet.add(stringArray.next().getOriginatingProvider());
            }
        }
        MultiExtFilter multiExtFilter = new MultiExtFilter();
        this.fileSelector.addFileFilter(new FileSelector.NamedFileFilter("All image formats", (FileSystemModel.FileFilter)multiExtFilter));
        for (ImageReaderSpi imageReaderSpi : hashSet) {
            MultiExtFilter multiExtFilter2 = new MultiExtFilter();
            for (String string : imageReaderSpi.getFileSuffixes()) {
                string = string.toLowerCase();
                multiExtFilter2.addExtension(string);
                multiExtFilter.addExtension(string);
            }
            if (multiExtFilter2.isEmpty()) continue;
            this.fileSelector.addFileFilter(new FileSelector.NamedFileFilter(imageReaderSpi.getDescription(Locale.getDefault()), (FileSystemModel.FileFilter)multiExtFilter2));
        }
        this.fileSelector.setFileSystemModel((FileSystemModel)JavaFileSystemModel.getInstance());
        this.fileSelector.setAllowMultiSelection(false);
        this.fileSelector.setUserWidgetRight((Widget)this.preview);
        this.fileSelector.getFileTable().addCallback(new FileTable.Callback(){

            public void selectionChanged() {
                ImageSelectPopup.this.updatePreview();
            }

            public void sortingChanged() {
            }
        });
        this.fileSelector.addCallback(new FileSelector.Callback(){

            public void filesSelected(Object[] objectArray) {
                ImageSelectPopup.this.fireAcceptImage();
            }

            public void canceled() {
                ImageSelectPopup.this.closePopup();
            }
        });
        this.add((Widget)this.fileSelector);
        this.setCloseOnClickedOutside(false);
    }

    public void addCallback(Callback callback) {
        this.callbacks = (Callback[])CallbackSupport.addCallbackToList((Object[])this.callbacks, (Object)callback, Callback.class);
    }

    public void removeCallback(Callback callback) {
        this.callbacks = (Callback[])CallbackSupport.removeCallbackFromList((Object[])this.callbacks, (Object)callback);
    }

    public boolean openPopup() {
        if (super.openPopup()) {
            int n = this.getGUI().getInnerWidth();
            int n2 = this.getGUI().getInnerHeight();
            this.setSize(n * 4 / 5, n2 * 4 / 5);
            this.setPosition(n / 2 - this.getWidth() / 2, n2 / 2 - this.getHeight() / 2);
            return true;
        }
        return false;
    }

    void updatePreview() {
        this.imagePath = null;
        this.imageData = null;
        FileTable.Entry[] entryArray = this.fileSelector.getFileTable().getSelection();
        if (entryArray.length > 0) {
            FileTable.Entry entry = entryArray[0];
            if (!entry.isFolder && entry.obj instanceof File) {
                this.imageData = ImageData.create((File)entry.obj);
                this.imagePath = entry.getPath();
            }
        }
        if (this.imageData != null) {
            this.fileSelector.setOkButtonEnabled(true);
            this.preview.setImageData(this.imageData);
            this.preview.setTooltipContent(this.imagePath);
        } else {
            this.fileSelector.setOkButtonEnabled(false);
            this.preview.setImageData(null);
            this.preview.setTooltipContent(null);
        }
    }

    void fireAcceptImage() {
        if (this.imageData != null) {
            if (this.callbacks != null) {
                for (Callback callback : this.callbacks) {
                    callback.imageSelected(this.imagePath, this.imageData);
                }
            }
            this.closePopup();
        }
    }

    public static interface Callback {
        public void imageSelected(String var1, ImageData var2);
    }

    static class MultiExtFilter
    implements FileSystemModel.FileFilter {
        private final HashSet<String> extensions = new HashSet();

        public boolean addExtension(String string) {
            return this.extensions.add(string);
        }

        public boolean isEmpty() {
            return this.extensions.isEmpty();
        }

        public boolean accept(FileSystemModel fileSystemModel, Object object) {
            String string = fileSystemModel.getName(object).toLowerCase();
            for (String string2 : this.extensions) {
                if (!string.endsWith(string2)) continue;
                return true;
            }
            return false;
        }
    }
}

