/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.properties;

import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twlthemeeditor.datamodel.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionProperty
implements Property<Condition> {
    private final Property<String> baseIf;
    private final Property<String> baseUnless;
    private final String name;
    private String prevCondition;

    public ConditionProperty(Property<String> property, Property<String> property2, String string) {
        if (!property.canBeNull()) {
            throw new IllegalArgumentException("baseIf must be nullable");
        }
        if (!property2.canBeNull()) {
            throw new IllegalArgumentException("baseIf must be nullable");
        }
        this.baseIf = property;
        this.baseUnless = property2;
        this.name = string;
        this.prevCondition = "";
    }

    public String getName() {
        return this.name;
    }

    public Class<Condition> getType() {
        return Condition.class;
    }

    public boolean canBeNull() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Condition getPropertyValue() {
        String string = (String)this.baseIf.getPropertyValue();
        if (string != null) {
            return new Condition(Condition.Type.IF, string);
        }
        string = (String)this.baseUnless.getPropertyValue();
        if (string != null) {
            return new Condition(Condition.Type.UNLESS, string);
        }
        return new Condition(Condition.Type.NONE, this.prevCondition);
    }

    public void setPropertyValue(Condition condition) throws IllegalArgumentException {
        this.prevCondition = condition.getCondition();
        this.baseIf.setPropertyValue((Object)(condition.getType() == Condition.Type.IF ? condition.getCondition() : null));
        this.baseUnless.setPropertyValue((Object)(condition.getType() == Condition.Type.UNLESS ? condition.getCondition() : null));
    }

    public void addValueChangedCallback(Runnable runnable) {
        this.baseIf.addValueChangedCallback(runnable);
        this.baseUnless.addValueChangedCallback(runnable);
    }

    public void removeValueChangedCallback(Runnable runnable) {
        this.baseIf.removeValueChangedCallback(runnable);
        this.baseUnless.removeValueChangedCallback(runnable);
    }
}

