/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.properties;

import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twlthemeeditor.properties.DerivedProperty;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumProperty<T extends Enum<T>>
extends DerivedProperty<T> {
    public EnumProperty(Property<String> property, Class<T> clazz) {
        super(property, clazz);
    }

    public static <T extends Enum<T>> EnumProperty<T> create(Property<String> property, Class<T> clazz) {
        return new EnumProperty<T>(property, clazz);
    }

    public T getPropertyValue() {
        try {
            String string = (String)this.base.getPropertyValue();
            if (string == null) {
                return null;
            }
            string = string.toUpperCase(Locale.ENGLISH);
            return Enum.valueOf(this.getType(), string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public void setPropertyValue(T t) throws IllegalArgumentException {
        if (t == null) {
            this.base.setPropertyValue(null);
        } else {
            this.base.setPropertyValue((Object)((Enum)t).name());
        }
    }
}

