/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.properties;

import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twlthemeeditor.datamodel.HotSpot;
import de.matthiasmann.twlthemeeditor.properties.IntegerProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HotSpotProperty
implements Property<HotSpot> {
    private final IntegerProperty baseX;
    private final IntegerProperty baseY;
    private final String name;

    public HotSpotProperty(Property<String> property, Property<String> property2, String string) {
        this.baseX = new IntegerProperty(property, 0, 0){

            public int getMaxValue() {
                return HotSpotProperty.this.getLimit().getX();
            }
        };
        this.baseY = new IntegerProperty(property2, 0, 0){

            public int getMaxValue() {
                return HotSpotProperty.this.getLimit().getY();
            }
        };
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Class<HotSpot> getType() {
        return HotSpot.class;
    }

    public boolean canBeNull() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public HotSpot getPropertyValue() {
        return new HotSpot(this.baseX.getValue(), this.baseY.getValue());
    }

    public void setPropertyValue(HotSpot hotSpot) throws IllegalArgumentException {
        this.baseX.setValue(hotSpot.getX());
        this.baseY.setValue(hotSpot.getY());
    }

    public void addValueChangedCallback(Runnable runnable) {
        this.baseX.addValueChangedCallback(runnable);
        this.baseY.addValueChangedCallback(runnable);
    }

    public void removeValueChangedCallback(Runnable runnable) {
        this.baseX.removeValueChangedCallback(runnable);
        this.baseY.removeValueChangedCallback(runnable);
    }

    public abstract Dimension getLimit();
}

