/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.properties;

import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twlthemeeditor.datamodel.IntegerFormula;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.properties.DerivedProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerFormulaProperty
extends DerivedProperty<IntegerFormula>
implements IntegerModel {
    private final int minValue;
    private final int maxValue;
    private IntegerFormula prevValue;

    public IntegerFormulaProperty(Property<String> property, int n, int n2) {
        super(property, IntegerFormula.class);
        this.minValue = n;
        this.maxValue = n2;
        this.prevValue = new IntegerFormula(n < 0 && n2 >= 0 ? 0 : n);
    }

    public IntegerFormula getPropertyValue() {
        String string = (String)this.base.getPropertyValue();
        if (string == null && this.canBeNull()) {
            return null;
        }
        try {
            return new IntegerFormula(Utils.parseInt(string));
        }
        catch (Throwable throwable) {
            return new IntegerFormula(this.prevValue.getValue(), string);
        }
    }

    public void setPropertyValue(IntegerFormula integerFormula) throws IllegalArgumentException {
        if (this.canBeNull() && integerFormula == null) {
            this.base.setPropertyValue(null);
        } else {
            this.prevValue = integerFormula;
            this.base.setPropertyValue((Object)integerFormula.toString());
        }
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setValue(int n) {
        this.setPropertyValue(new IntegerFormula(n));
    }

    public int getValue() {
        IntegerFormula integerFormula = this.getPropertyValue();
        return (integerFormula != null ? integerFormula : this.prevValue).getValue();
    }
}

