/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.properties;

import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.AbstractProperty;
import de.matthiasmann.twlthemeeditor.gui.Context;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetThemeProperty
extends AbstractProperty<String> {
    private final Widget widget;
    private final Context ctx;

    public WidgetThemeProperty(Widget widget, Context context) {
        this.widget = widget;
        this.ctx = context;
    }

    public boolean canBeNull() {
        return false;
    }

    public String getName() {
        return "Theme name";
    }

    public String getPropertyValue() {
        return this.widget.getTheme();
    }

    public Class<String> getType() {
        return String.class;
    }

    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyValue(String string) throws IllegalArgumentException {
        this.ctx.installDebugHook();
        try {
            this.widget.setTheme(string);
            this.widget.reapplyTheme();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            this.ctx.uninstallDebugHook();
        }
    }

    public String getThemePath() {
        return this.widget.getThemePath();
    }

    public String[] getThemePathElements(int n) {
        Widget widget;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (widget = this.widget; n > 0 && widget != null; widget = widget.getParent(), --n) {
        }
        while (widget != null) {
            String string = widget.getTheme();
            if (!string.isEmpty()) {
                if (Widget.isAbsoluteTheme((String)string)) {
                    arrayList.add(string.substring(1));
                    break;
                }
                arrayList.add(string);
            }
            widget = widget.getParent();
        }
        Collections.reverse(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

