/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SolidFile
extends URLStreamHandler {
    File file = File.createTempFile("SFD", ".bin");
    Thread shutdownHook;
    final RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
    final HashMap<String, Entry> entries = new HashMap();

    SolidFile() throws IOException {
        this.shutdownHook = new Thread(){

            public void run() {
                SolidFile.this.shutdownHook = null;
                try {
                    SolidFile.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public Entry getEntry(String string) {
        return this.entries.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readEntry(Entry entry) throws IOException {
        byte[] byArray = new byte[(int)entry.size];
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            int n;
            this.raf.seek(entry.offset);
            for (int i = 0; i < byArray.length; i += n) {
                n = this.raf.read(byArray, i, byArray.length - i);
                if (n > 0) continue;
                throw new EOFException();
            }
        }
        return byArray;
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        return new URLConnection(uRL){
            Entry entry;

            public void connect() throws IOException {
                if (this.entry == null) {
                    this.entry = this.openEntry();
                }
            }

            private Entry openEntry() throws IOException {
                int n;
                String string = this.url.getPath();
                if (!string.startsWith("/")) {
                    throw new FileNotFoundException(string);
                }
                Entry entry = SolidFile.this.getEntry(string.substring(1));
                for (n = this.url.getPort(); n > 0 && entry != null; --n) {
                    entry = entry.next;
                }
                if (n != 0 || entry == null) {
                    throw new FileNotFoundException(string);
                }
                return entry;
            }

            public int getContentLength() {
                if (this.entry == null) {
                    return -1;
                }
                return (int)Math.min(Integer.MAX_VALUE, this.entry.size);
            }

            public InputStream getInputStream() throws IOException {
                this.connect();
                return SolidFile.this.getInputStream(this.entry);
            }
        };
    }

    public URL makeURL(final String string, final int n) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                try {
                    return new URL("solid", "localhost", n, "/".concat(string), SolidFile.this);
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.getLogger(SolidFile.class.getName()).log(Level.SEVERE, "Can't create URL", malformedURLException);
                    return null;
                }
            }
        });
    }

    public InputStream getInputStream(Entry entry) {
        return new EntryInputStream(this.raf, entry.offset, entry.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.close();
        }
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
    }

    void addEntry(String string, long l, long l2) {
        Entry entry = new Entry(l, l2);
        Entry entry2 = this.entries.get(string);
        if (entry2 != null) {
            while (entry2.next != null) {
                entry2 = entry2.next;
            }
            entry2.next = entry;
        } else {
            this.entries.put(string, entry);
        }
    }

    public static class Entry {
        final long offset;
        final long size;
        Entry next;

        public Entry(long l, long l2) {
            this.offset = l;
            this.size = l2;
        }

        public Entry getNext() {
            return this.next;
        }
    }

    private static class EntryInputStream
    extends InputStream {
        private final RandomAccessFile raf;
        private final long base;
        private final long size;
        private long pos;
        private long mark;

        public EntryInputStream(RandomAccessFile randomAccessFile, long l, long l2) {
            this.raf = randomAccessFile;
            this.base = l;
            this.size = l2;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) != 1) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }

        public int available() throws IOException {
            return (int)Math.min(Integer.MAX_VALUE, this.size - this.pos);
        }

        public synchronized void mark(int n) {
            this.mark = this.pos;
        }

        public boolean markSupported() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (n2 <= 0) {
                return 0;
            }
            int n4 = this.available();
            if (n4 == 0) {
                return -1;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                this.raf.seek(this.base + this.pos);
                n3 = this.raf.read(byArray, n, n2);
            }
            if (n3 > 0) {
                this.pos += (long)n3;
            }
            return n3;
        }

        public synchronized void reset() throws IOException {
            this.pos = this.mark;
        }

        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            long l2 = this.size - this.pos;
            if (l > l2) {
                l = l2;
            }
            this.pos += l;
            return l;
        }
    }
}

