/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.util;

import de.matthiasmann.twlthemeeditor.util.SolidFile;
import de.matthiasmann.twlthemeeditor.util.SolidFileInspector;
import de.matthiasmann.twlthemeeditor.util.SolidFileWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolidFileClassLoader
extends ClassLoader {
    private final SolidFile solidFile;

    public SolidFileClassLoader(ClassLoader classLoader, SolidFile solidFile) {
        super(classLoader);
        this.solidFile = solidFile;
    }

    public void close() {
        try {
            this.solidFile.close();
        }
        catch (IOException iOException) {
            SolidFileClassLoader.getLogger().log(Level.SEVERE, "Can't close SolidFile", iOException);
        }
    }

    @Override
    protected URL findResource(String string) {
        if (this.solidFile.getEntry(string) != null) {
            return this.solidFile.makeURL(string, 0);
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String string) throws IOException {
        ArrayList<URL> arrayList = Collections.list(this.getParent().getResources(string));
        int n = 0;
        for (SolidFile.Entry entry = this.solidFile.getEntry(string); entry != null; entry = entry.getNext()) {
            URL uRL = this.solidFile.makeURL(string, n);
            if (uRL != null) {
                arrayList.add(uRL);
            }
            ++n;
        }
        return Collections.enumeration(arrayList);
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        String string2 = string.replace('.', '/') + ".class";
        SolidFile.Entry entry = this.solidFile.getEntry(string2);
        if (entry != null) {
            try {
                byte[] byArray = this.solidFile.readEntry(entry);
                return this.defineClass(string, byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string, iOException);
            }
        }
        throw new ClassNotFoundException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SolidFileClassLoader create(ClassLoader classLoader, SolidFileInspector solidFileInspector, File ... fileArray) throws IOException {
        SolidFileWriter solidFileWriter = new SolidFileWriter();
        try {
            for (File file : fileArray) {
                if (solidFileInspector != null) {
                    solidFileInspector.processingRoot(file);
                }
                try {
                    if (file.isDirectory()) {
                        SolidFileClassLoader.collectFolder(solidFileWriter, file, solidFileInspector, "");
                        continue;
                    }
                    if (!file.isFile()) continue;
                    SolidFileClassLoader.collectJAR(solidFileWriter, file, solidFileInspector);
                }
                catch (IOException iOException) {
                    SolidFileClassLoader.getLogger().log(Level.SEVERE, "Can't process root: " + file, iOException);
                }
            }
            SolidFileClassLoader solidFileClassLoader = new SolidFileClassLoader(classLoader, solidFileWriter.finish());
            return solidFileClassLoader;
        }
        finally {
            solidFileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectFolder(SolidFileWriter solidFileWriter, File file, SolidFileInspector solidFileInspector, String string) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                SolidFileClassLoader.collectFolder(solidFileWriter, file2, solidFileInspector, string + file2.getName() + "/");
                continue;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                try {
                    SolidFileClassLoader.collectFile(solidFileWriter, solidFileInspector, string.concat(file2.getName()), fileInputStream);
                }
                finally {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                SolidFileClassLoader.getLogger().log(Level.SEVERE, "Can't read file", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectJAR(SolidFileWriter solidFileWriter, File file, SolidFileInspector solidFileInspector) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            try {
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    SolidFileClassLoader.collectFile(solidFileWriter, solidFileInspector, zipEntry.getName(), zipInputStream);
                }
            }
            finally {
                zipInputStream.close();
            }
        }
        finally {
            fileInputStream.close();
        }
    }

    private static void collectFile(SolidFileWriter solidFileWriter, SolidFileInspector solidFileInspector, String string, InputStream inputStream) throws IOException {
        if (solidFileInspector != null && solidFileInspector.shouldInspectFile(string)) {
            solidFileInspector.inspectFile(solidFileWriter, string, inputStream);
        } else {
            solidFileWriter.addEntry(string, inputStream);
        }
    }

    private static Logger getLogger() {
        return Logger.getLogger(SolidFileClassLoader.class.getName());
    }
}

