/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.util;

import de.matthiasmann.twlthemeeditor.util.SolidFile;
import java.io.IOException;
import java.io.InputStream;

public class SolidFileWriter {
    SolidFile solidFile = new SolidFile();
    final byte[] buffer = new byte[65536];
    int bufferPosition;
    long filePosition = 0L;

    public void addEntry(String string, InputStream inputStream) throws IOException {
        int n;
        this.ensureOpen();
        long l = this.getFilePosition();
        long l2 = 0L;
        while ((n = inputStream.read(this.buffer, this.bufferPosition, this.buffer.length - this.bufferPosition)) > 0) {
            this.bufferPosition += n;
            if (this.bufferPosition * 3 > this.buffer.length * 2) {
                this.flush();
            }
            l2 += (long)n;
        }
        this.solidFile.addEntry(string, l, l2);
    }

    public void addEntry(String string, byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        long l = this.getFilePosition();
        if (this.buffer.length - this.bufferPosition >= n2) {
            System.arraycopy(byArray, n, this.buffer, this.bufferPosition, n2);
            this.bufferPosition += n2;
        } else {
            this.flush();
            this.solidFile.raf.write(byArray, n, n2);
            this.filePosition += (long)n2;
        }
        this.solidFile.addEntry(string, l, n2);
    }

    public SolidFile finish() throws IOException {
        this.ensureOpen();
        this.flush();
        SolidFile solidFile = this.solidFile;
        this.solidFile = null;
        return solidFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.solidFile != null) {
            try {
                this.solidFile.close();
            }
            finally {
                this.solidFile = null;
            }
        }
    }

    private void ensureOpen() {
        if (this.solidFile == null) {
            throw new IllegalStateException("already finished");
        }
    }

    private long getFilePosition() {
        return this.filePosition + (long)this.bufferPosition;
    }

    private void flush() throws IOException {
        if (this.bufferPosition > 0) {
            this.solidFile.raf.write(this.buffer, 0, this.bufferPosition);
            this.filePosition += (long)this.bufferPosition;
            this.bufferPosition = 0;
        }
    }
}

