/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.mxp1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MXParser
implements XmlPullParser {
    protected static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    protected static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    protected static final String FEATURE_XML_ROUNDTRIP = "http://xmlpull.org/v1/doc/features.html#xml-roundtrip";
    protected static final String FEATURE_NAMES_INTERNED = "http://xmlpull.org/v1/doc/features.html#names-interned";
    protected static final String PROPERTY_XMLDECL_VERSION = "http://xmlpull.org/v1/doc/properties.html#xmldecl-version";
    protected static final String PROPERTY_XMLDECL_STANDALONE = "http://xmlpull.org/v1/doc/properties.html#xmldecl-standalone";
    protected static final String PROPERTY_XMLDECL_CONTENT = "http://xmlpull.org/v1/doc/properties.html#xmldecl-content";
    protected static final String PROPERTY_LOCATION = "http://xmlpull.org/v1/doc/properties.html#location";
    protected boolean allStringsInterned;
    private static final boolean TRACE_SIZING = false;
    protected boolean processNamespaces;
    protected boolean roundtripSupported;
    protected String location;
    protected int lineNumber;
    protected int columnNumber;
    protected boolean seenRoot;
    protected boolean reachedEnd;
    protected int eventType;
    protected boolean emptyElementTag;
    protected int depth;
    protected char[][] elRawName;
    protected int[] elRawNameEnd;
    protected int[] elRawNameLine;
    protected String[] elName;
    protected String[] elPrefix;
    protected String[] elUri;
    protected int[] elNamespaceCount;
    protected int attributeCount;
    protected String[] attributeName;
    protected int[] attributeNameHash;
    protected String[] attributePrefix;
    protected String[] attributeUri;
    protected String[] attributeValue;
    protected int namespaceEnd;
    protected String[] namespacePrefix;
    protected int[] namespacePrefixHash;
    protected String[] namespaceUri;
    protected int entityEnd;
    protected String[] entityName;
    protected char[][] entityNameBuf;
    protected String[] entityReplacement;
    protected char[][] entityReplacementBuf;
    protected int[] entityNameHash;
    protected static final int READ_CHUNK_SIZE = 8192;
    protected Reader reader;
    protected String inputEncoding;
    protected InputStream inputStream;
    protected int bufLoadFactor = 95;
    protected char[] buf = new char[Runtime.getRuntime().freeMemory() > 1000000L ? 8192 : 256];
    protected int bufSoftLimit = this.bufLoadFactor * this.buf.length / 100;
    protected boolean preventBufferCompaction;
    protected int bufAbsoluteStart;
    protected int bufStart;
    protected int bufEnd;
    protected int pos;
    protected int posStart;
    protected int posEnd;
    protected char[] pc = new char[Runtime.getRuntime().freeMemory() > 1000000L ? 8192 : 64];
    protected int pcStart;
    protected int pcEnd;
    protected boolean usePC;
    protected boolean seenStartTag;
    protected boolean seenEndTag;
    protected boolean pastEndTag;
    protected boolean seenAmpersand;
    protected boolean seenMarkup;
    protected boolean seenDocdecl;
    protected boolean tokenize;
    protected String text;
    protected String entityRefName;
    protected String xmlDeclVersion;
    protected Boolean xmlDeclStandalone;
    protected String xmlDeclContent;
    protected char[] charRefOneCharBuf = new char[1];
    protected static final char[] VERSION;
    protected static final char[] NCODING;
    protected static final char[] TANDALONE;
    protected static final char[] YES;
    protected static final char[] NO;
    protected static final int LOOKUP_MAX = 1024;
    protected static final char LOOKUP_MAX_CHAR = '\u0400';
    protected static boolean[] lookupNameStartChar;
    protected static boolean[] lookupNameChar;

    protected void resetStringCache() {
    }

    protected String newString(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    protected String newStringIntern(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2).intern();
    }

    protected void ensureElementsCapacity() {
        int n;
        int n2 = n = this.elName != null ? this.elName.length : 0;
        if (this.depth + 1 >= n) {
            int n3 = (this.depth >= 7 ? 2 * this.depth : 8) + 2;
            boolean bl = n > 0;
            String[] stringArray = null;
            stringArray = new String[n3];
            if (bl) {
                System.arraycopy(this.elName, 0, stringArray, 0, n);
            }
            this.elName = stringArray;
            stringArray = new String[n3];
            if (bl) {
                System.arraycopy(this.elPrefix, 0, stringArray, 0, n);
            }
            this.elPrefix = stringArray;
            stringArray = new String[n3];
            if (bl) {
                System.arraycopy(this.elUri, 0, stringArray, 0, n);
            }
            this.elUri = stringArray;
            int[] nArray = new int[n3];
            if (bl) {
                System.arraycopy(this.elNamespaceCount, 0, nArray, 0, n);
            } else {
                nArray[0] = 0;
            }
            this.elNamespaceCount = nArray;
            nArray = new int[n3];
            if (bl) {
                System.arraycopy(this.elRawNameEnd, 0, nArray, 0, n);
            }
            this.elRawNameEnd = nArray;
            nArray = new int[n3];
            if (bl) {
                System.arraycopy(this.elRawNameLine, 0, nArray, 0, n);
            }
            this.elRawNameLine = nArray;
            char[][] cArrayArray = new char[n3][];
            if (bl) {
                System.arraycopy(this.elRawName, 0, cArrayArray, 0, n);
            }
            this.elRawName = cArrayArray;
        }
    }

    protected void ensureAttributesCapacity(int n) {
        int n2;
        int n3 = n2 = this.attributeName != null ? this.attributeName.length : 0;
        if (n >= n2) {
            int n4 = n > 7 ? 2 * n : 8;
            boolean bl = n2 > 0;
            String[] stringArray = null;
            stringArray = new String[n4];
            if (bl) {
                System.arraycopy(this.attributeName, 0, stringArray, 0, n2);
            }
            this.attributeName = stringArray;
            stringArray = new String[n4];
            if (bl) {
                System.arraycopy(this.attributePrefix, 0, stringArray, 0, n2);
            }
            this.attributePrefix = stringArray;
            stringArray = new String[n4];
            if (bl) {
                System.arraycopy(this.attributeUri, 0, stringArray, 0, n2);
            }
            this.attributeUri = stringArray;
            stringArray = new String[n4];
            if (bl) {
                System.arraycopy(this.attributeValue, 0, stringArray, 0, n2);
            }
            this.attributeValue = stringArray;
            if (!this.allStringsInterned) {
                int[] nArray = new int[n4];
                if (bl) {
                    System.arraycopy(this.attributeNameHash, 0, nArray, 0, n2);
                }
                this.attributeNameHash = nArray;
            }
            stringArray = null;
        }
    }

    protected void ensureNamespacesCapacity(int n) {
        int n2;
        int n3 = n2 = this.namespacePrefix != null ? this.namespacePrefix.length : 0;
        if (n >= n2) {
            int n4 = n > 7 ? 2 * n : 8;
            String[] stringArray = new String[n4];
            String[] stringArray2 = new String[n4];
            if (this.namespacePrefix != null) {
                System.arraycopy(this.namespacePrefix, 0, stringArray, 0, this.namespaceEnd);
                System.arraycopy(this.namespaceUri, 0, stringArray2, 0, this.namespaceEnd);
            }
            this.namespacePrefix = stringArray;
            this.namespaceUri = stringArray2;
            if (!this.allStringsInterned) {
                int[] nArray = new int[n4];
                if (this.namespacePrefixHash != null) {
                    System.arraycopy(this.namespacePrefixHash, 0, nArray, 0, this.namespaceEnd);
                }
                this.namespacePrefixHash = nArray;
            }
        }
    }

    protected static final int fastHash(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = cArray[n];
        n3 = (n3 << 7) + cArray[n + n2 - 1];
        if (n2 > 16) {
            n3 = (n3 << 7) + cArray[n + n2 / 4];
        }
        if (n2 > 8) {
            n3 = (n3 << 7) + cArray[n + n2 / 2];
        }
        return n3;
    }

    protected void ensureEntityCapacity() {
        int n;
        int n2 = n = this.entityReplacementBuf != null ? this.entityReplacementBuf.length : 0;
        if (this.entityEnd >= n) {
            int n3 = this.entityEnd > 7 ? 2 * this.entityEnd : 8;
            String[] stringArray = new String[n3];
            char[][] cArrayArray = new char[n3][];
            String[] stringArray2 = new String[n3];
            char[][] cArrayArray2 = new char[n3][];
            if (this.entityName != null) {
                System.arraycopy(this.entityName, 0, stringArray, 0, this.entityEnd);
                System.arraycopy(this.entityNameBuf, 0, cArrayArray, 0, this.entityEnd);
                System.arraycopy(this.entityReplacement, 0, stringArray2, 0, this.entityEnd);
                System.arraycopy(this.entityReplacementBuf, 0, cArrayArray2, 0, this.entityEnd);
            }
            this.entityName = stringArray;
            this.entityNameBuf = cArrayArray;
            this.entityReplacement = stringArray2;
            this.entityReplacementBuf = cArrayArray2;
            if (!this.allStringsInterned) {
                int[] nArray = new int[n3];
                if (this.entityNameHash != null) {
                    System.arraycopy(this.entityNameHash, 0, nArray, 0, this.entityEnd);
                }
                this.entityNameHash = nArray;
            }
        }
    }

    protected void reset() {
        this.location = null;
        this.lineNumber = 1;
        this.columnNumber = 0;
        this.seenRoot = false;
        this.reachedEnd = false;
        this.eventType = 0;
        this.emptyElementTag = false;
        this.depth = 0;
        this.attributeCount = 0;
        this.namespaceEnd = 0;
        this.entityEnd = 0;
        this.reader = null;
        this.inputEncoding = null;
        this.preventBufferCompaction = false;
        this.bufAbsoluteStart = 0;
        this.bufStart = 0;
        this.bufEnd = 0;
        this.posEnd = 0;
        this.posStart = 0;
        this.pos = 0;
        this.pcStart = 0;
        this.pcEnd = 0;
        this.usePC = false;
        this.seenStartTag = false;
        this.seenEndTag = false;
        this.pastEndTag = false;
        this.seenAmpersand = false;
        this.seenMarkup = false;
        this.seenDocdecl = false;
        this.xmlDeclVersion = null;
        this.xmlDeclStandalone = null;
        this.xmlDeclContent = null;
        this.resetStringCache();
    }

    public void setFeature(String string, boolean bl) throws XmlPullParserException {
        if (string == null) {
            throw new IllegalArgumentException("feature name should not be null");
        }
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string)) {
            if (this.eventType != 0) {
                throw new XmlPullParserException("namespace processing feature can only be changed before parsing", this, null);
            }
            this.processNamespaces = bl;
        } else if (FEATURE_NAMES_INTERNED.equals(string)) {
            if (bl) {
                throw new XmlPullParserException("interning names in this implementation is not supported");
            }
        } else if ("http://xmlpull.org/v1/doc/features.html#process-docdecl".equals(string)) {
            if (bl) {
                throw new XmlPullParserException("processing DOCDECL is not supported");
            }
        } else if (FEATURE_XML_ROUNDTRIP.equals(string)) {
            this.roundtripSupported = bl;
        } else {
            throw new XmlPullParserException("unsupported feature " + string);
        }
    }

    public boolean getFeature(String string) {
        if (string == null) {
            throw new IllegalArgumentException("feature name should not be null");
        }
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string)) {
            return this.processNamespaces;
        }
        if (FEATURE_NAMES_INTERNED.equals(string)) {
            return false;
        }
        if ("http://xmlpull.org/v1/doc/features.html#process-docdecl".equals(string)) {
            return false;
        }
        if (FEATURE_XML_ROUNDTRIP.equals(string)) {
            return this.roundtripSupported;
        }
        return false;
    }

    public void setProperty(String string, Object object) throws XmlPullParserException {
        if (!PROPERTY_LOCATION.equals(string)) {
            throw new XmlPullParserException("unsupported property: '" + string + "'");
        }
        this.location = (String)object;
    }

    public Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("property name should not be null");
        }
        if (PROPERTY_XMLDECL_VERSION.equals(string)) {
            return this.xmlDeclVersion;
        }
        if (PROPERTY_XMLDECL_STANDALONE.equals(string)) {
            return this.xmlDeclStandalone;
        }
        if (PROPERTY_XMLDECL_CONTENT.equals(string)) {
            return this.xmlDeclContent;
        }
        if (PROPERTY_LOCATION.equals(string)) {
            return this.location;
        }
        return null;
    }

    public void setInput(Reader reader) throws XmlPullParserException {
        this.reset();
        this.reader = reader;
    }

    public void setInput(InputStream inputStream, String string) throws XmlPullParserException {
        InputStreamReader inputStreamReader;
        if (inputStream == null) {
            throw new IllegalArgumentException("input stream can not be null");
        }
        this.inputStream = inputStream;
        try {
            inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XmlPullParserException("could not create reader for encoding " + string + " : " + unsupportedEncodingException, this, unsupportedEncodingException);
        }
        this.setInput(inputStreamReader);
        this.inputEncoding = string;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void defineEntityReplacementText(String string, String string2) throws XmlPullParserException {
        this.ensureEntityCapacity();
        this.entityName[this.entityEnd] = this.newString(string.toCharArray(), 0, string.length());
        this.entityNameBuf[this.entityEnd] = string.toCharArray();
        this.entityReplacement[this.entityEnd] = string2;
        this.entityReplacementBuf[this.entityEnd] = string2.toCharArray();
        if (!this.allStringsInterned) {
            this.entityNameHash[this.entityEnd] = MXParser.fastHash(this.entityNameBuf[this.entityEnd], 0, this.entityNameBuf[this.entityEnd].length);
        }
        ++this.entityEnd;
    }

    public int getNamespaceCount(int n) throws XmlPullParserException {
        if (!this.processNamespaces || n == 0) {
            return 0;
        }
        if (n < 0 || n > this.depth) {
            throw new IllegalArgumentException("allowed namespace depth 0.." + this.depth + " not " + n);
        }
        return this.elNamespaceCount[n];
    }

    public String getNamespacePrefix(int n) throws XmlPullParserException {
        if (n < this.namespaceEnd) {
            return this.namespacePrefix[n];
        }
        throw new XmlPullParserException("position " + n + " exceeded number of available namespaces " + this.namespaceEnd);
    }

    public String getNamespaceUri(int n) throws XmlPullParserException {
        if (n < this.namespaceEnd) {
            return this.namespaceUri[n];
        }
        throw new XmlPullParserException("position " + n + " exceeded number of available namespaces " + this.namespaceEnd);
    }

    public String getNamespace(String string) {
        if (string != null) {
            for (int i = this.namespaceEnd - 1; i >= 0; --i) {
                if (!string.equals(this.namespacePrefix[i])) continue;
                return this.namespaceUri[i];
            }
            if ("xml".equals(string)) {
                return XML_URI;
            }
            if ("xmlns".equals(string)) {
                return XMLNS_URI;
            }
        } else {
            for (int i = this.namespaceEnd - 1; i >= 0; --i) {
                if (this.namespacePrefix[i] != null) continue;
                return this.namespaceUri[i];
            }
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    private static int findFragment(int n, char[] cArray, int n2, int n3) {
        char c;
        if (n2 < n) {
            n2 = n;
            if (n2 > n3) {
                n2 = n3;
            }
            return n2;
        }
        if (n3 - n2 > 65) {
            n2 = n3 - 10;
        }
        int n4 = n2 + 1;
        while (--n4 > n && n3 - n4 <= 65 && ((c = cArray[n4]) != '<' || n2 - n4 <= 10)) {
        }
        return n4;
    }

    public String getPositionDescription() {
        String string = null;
        if (this.posStart <= this.pos) {
            int n = MXParser.findFragment(0, this.buf, this.posStart, this.pos);
            if (n < this.pos) {
                string = new String(this.buf, n, this.pos - n);
            }
            if (this.bufAbsoluteStart > 0 || n > 0) {
                string = "..." + string;
            }
        }
        return " " + XmlPullParser.TYPES[this.eventType] + (string != null ? " seen " + this.printable(string) + "..." : "") + " " + (this.location != null ? this.location : "") + "@" + this.getLineNumber() + ":" + this.getColumnNumber();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        if (this.eventType == 4 || this.eventType == 5) {
            if (this.usePC) {
                for (int i = this.pcStart; i < this.pcEnd; ++i) {
                    if (this.isS(this.pc[i])) continue;
                    return false;
                }
                return true;
            }
            for (int i = this.posStart; i < this.posEnd; ++i) {
                if (this.isS(this.buf[i])) continue;
                return false;
            }
            return true;
        }
        if (this.eventType == 7) {
            return true;
        }
        throw new XmlPullParserException("no content available to check for white spaces");
    }

    public String getText() {
        if (this.eventType == 0 || this.eventType == 1) {
            return null;
        }
        if (this.eventType == 6) {
            return this.text;
        }
        if (this.text == null) {
            this.text = !this.usePC || this.eventType == 2 || this.eventType == 3 ? new String(this.buf, this.posStart, this.posEnd - this.posStart) : new String(this.pc, this.pcStart, this.pcEnd - this.pcStart);
        }
        return this.text;
    }

    public char[] getTextCharacters(int[] nArray) {
        if (this.eventType == 4) {
            if (this.usePC) {
                nArray[0] = this.pcStart;
                nArray[1] = this.pcEnd - this.pcStart;
                return this.pc;
            }
            nArray[0] = this.posStart;
            nArray[1] = this.posEnd - this.posStart;
            return this.buf;
        }
        if (this.eventType == 2 || this.eventType == 3 || this.eventType == 5 || this.eventType == 9 || this.eventType == 6 || this.eventType == 8 || this.eventType == 7 || this.eventType == 10) {
            nArray[0] = this.posStart;
            nArray[1] = this.posEnd - this.posStart;
            return this.buf;
        }
        if (this.eventType == 0 || this.eventType == 1) {
            nArray[1] = -1;
            nArray[0] = -1;
            return null;
        }
        throw new IllegalArgumentException("unknown text eventType: " + this.eventType);
    }

    public String getNamespace() {
        if (this.eventType == 2) {
            return this.processNamespaces ? this.elUri[this.depth] : "";
        }
        if (this.eventType == 3) {
            return this.processNamespaces ? this.elUri[this.depth] : "";
        }
        return null;
    }

    public String getName() {
        if (this.eventType == 2) {
            return this.elName[this.depth];
        }
        if (this.eventType == 3) {
            return this.elName[this.depth];
        }
        if (this.eventType == 6) {
            if (this.entityRefName == null) {
                this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
            }
            return this.entityRefName;
        }
        return null;
    }

    public String getPrefix() {
        if (this.eventType == 2) {
            return this.elPrefix[this.depth];
        }
        if (this.eventType == 3) {
            return this.elPrefix[this.depth];
        }
        return null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.eventType != 2) {
            throw new XmlPullParserException("parser must be on START_TAG to check for empty element", this, null);
        }
        return this.emptyElementTag;
    }

    public int getAttributeCount() {
        if (this.eventType != 2) {
            return -1;
        }
        return this.attributeCount;
    }

    public String getAttributeNamespace(int n) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (!this.processNamespaces) {
            return "";
        }
        if (n < 0 || n >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
        }
        return this.attributeUri[n];
    }

    public String getAttributeName(int n) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (n < 0 || n >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
        }
        return this.attributeName[n];
    }

    public String getAttributePrefix(int n) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (!this.processNamespaces) {
            return null;
        }
        if (n < 0 || n >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
        }
        return this.attributePrefix[n];
    }

    public String getAttributeType(int n) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (n < 0 || n >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
        }
        return "CDATA";
    }

    public boolean isAttributeDefault(int n) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (n < 0 || n >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
        }
        return false;
    }

    public String getAttributeValue(int n) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (n < 0 || n >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n);
        }
        return this.attributeValue[n];
    }

    public String getAttributeValue(String string, String string2) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes" + this.getPositionDescription());
        }
        if (string2 == null) {
            throw new IllegalArgumentException("attribute name can not be null");
        }
        if (this.processNamespaces) {
            if (string == null) {
                string = "";
            }
            for (int i = 0; i < this.attributeCount; ++i) {
                if (string != this.attributeUri[i] && !string.equals(this.attributeUri[i]) || !string2.equals(this.attributeName[i])) continue;
                return this.attributeValue[i];
            }
        } else {
            if (string != null && string.length() == 0) {
                string = null;
            }
            if (string != null) {
                throw new IllegalArgumentException("when namespaces processing is disabled attribute namespace must be null");
            }
            for (int i = 0; i < this.attributeCount; ++i) {
                if (!string2.equals(this.attributeName[i])) continue;
                return this.attributeValue[i];
            }
        }
        return null;
    }

    public int getEventType() throws XmlPullParserException {
        return this.eventType;
    }

    public void require(int n, String string, String string2) throws XmlPullParserException, IOException {
        if (!this.processNamespaces && string != null) {
            throw new XmlPullParserException("processing namespaces must be enabled on parser (or factory) to have possible namespaces declared on elements" + " (position:" + this.getPositionDescription() + ")");
        }
        if (n != this.getEventType() || string != null && !string.equals(this.getNamespace()) || string2 != null && !string2.equals(this.getName())) {
            throw new XmlPullParserException("expected event " + XmlPullParser.TYPES[n] + (string2 != null ? " with name '" + string2 + "'" : "") + (string != null && string2 != null ? " and" : "") + (string != null ? " with namespace '" + string + "'" : "") + " but got" + (n != this.getEventType() ? " " + XmlPullParser.TYPES[this.getEventType()] : "") + (string2 != null && this.getName() != null && !string2.equals(this.getName()) ? " name '" + this.getName() + "'" : "") + (string != null && string2 != null && this.getName() != null && !string2.equals(this.getName()) && this.getNamespace() != null && !string.equals(this.getNamespace()) ? " and" : "") + (string != null && this.getNamespace() != null && !string.equals(this.getNamespace()) ? " namespace '" + this.getNamespace() + "'" : "") + " (position:" + this.getPositionDescription() + ")");
        }
    }

    public void skipSubTree() throws XmlPullParserException, IOException {
        this.require(2, null, null);
        int n = 1;
        while (n > 0) {
            int n2 = this.next();
            if (n2 == 3) {
                --n;
                continue;
            }
            if (n2 != 2) continue;
            ++n;
        }
    }

    public String nextText() throws XmlPullParserException, IOException {
        if (this.getEventType() != 2) {
            throw new XmlPullParserException("parser must be on START_TAG to read next text", this, null);
        }
        int n = this.next();
        if (n == 4) {
            String string = this.getText();
            n = this.next();
            if (n != 3) {
                throw new XmlPullParserException("TEXT must be immediately followed by END_TAG and not " + XmlPullParser.TYPES[this.getEventType()], this, null);
            }
            return string;
        }
        if (n == 3) {
            return "";
        }
        throw new XmlPullParserException("parser must be on START_TAG or TEXT to read text", this, null);
    }

    public int nextTag() throws XmlPullParserException, IOException {
        this.next();
        if (this.eventType == 4 && this.isWhitespace()) {
            this.next();
        }
        if (this.eventType != 2 && this.eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[this.getEventType()], this, null);
        }
        return this.eventType;
    }

    public int next() throws XmlPullParserException, IOException {
        this.tokenize = false;
        return this.nextImpl();
    }

    public int nextToken() throws XmlPullParserException, IOException {
        this.tokenize = true;
        return this.nextImpl();
    }

    /*
     * Unable to fully structure code
     */
    protected int nextImpl() throws XmlPullParserException, IOException {
        block53: {
            this.text = null;
            this.pcStart = 0;
            this.pcEnd = 0;
            this.usePC = false;
            this.bufStart = this.posEnd;
            if (this.pastEndTag) {
                this.pastEndTag = false;
                --this.depth;
                this.namespaceEnd = this.elNamespaceCount[this.depth];
            }
            if (this.emptyElementTag) {
                this.emptyElementTag = false;
                this.pastEndTag = true;
                this.eventType = 3;
                return 3;
            }
            if (this.depth <= 0) break block53;
            if (this.seenStartTag) {
                this.seenStartTag = false;
                this.eventType = this.parseStartTag();
                return this.eventType;
            }
            if (this.seenEndTag) {
                this.seenEndTag = false;
                this.eventType = this.parseEndTag();
                return this.eventType;
            }
            if (this.seenMarkup) {
                this.seenMarkup = false;
                var1_1 = '<';
            } else if (this.seenAmpersand) {
                this.seenAmpersand = false;
                var1_1 = '&';
            } else {
                var1_1 = this.more();
            }
            this.posStart = this.pos - 1;
            var2_2 = false;
            var3_3 = false;
            while (true) {
                block56: {
                    block54: {
                        block57: {
                            block55: {
                                if (var1_1 != 60) ** GOTO lbl98
                                if (var2_2 && this.tokenize) {
                                    this.seenMarkup = true;
                                    this.eventType = 4;
                                    return 4;
                                }
                                var1_1 = this.more();
                                if (var1_1 == '/') {
                                    if (!this.tokenize && var2_2) {
                                        this.seenEndTag = true;
                                        this.eventType = 4;
                                        return 4;
                                    }
                                    this.eventType = this.parseEndTag();
                                    return this.eventType;
                                }
                                if (var1_1 != 33) break block54;
                                var1_1 = this.more();
                                if (var1_1 != 45) break block55;
                                this.parseComment();
                                if (this.tokenize) {
                                    this.eventType = 9;
                                    return 9;
                                }
                                if (!this.usePC && var2_2) {
                                    var3_3 = true;
                                } else {
                                    this.posStart = this.pos;
                                }
                                break block56;
                            }
                            if (var1_1 != 91) break block57;
                            this.parseCDSect(var2_2);
                            if (this.tokenize) {
                                this.eventType = 5;
                                return 5;
                            }
                            var5_5 = this.posEnd;
                            var4_4 = this.posStart;
                            var6_6 = var5_5 - var4_4;
                            if (var6_6 <= 0) break block56;
                            var2_2 = true;
                            if (this.usePC) break block56;
                            var3_3 = true;
                            break block56;
                        }
                        throw new XmlPullParserException("unexpected character in markup " + this.printable(var1_1), this, null);
                    }
                    if (var1_1 == '?') {
                        this.parsePI();
                        if (this.tokenize) {
                            this.eventType = 8;
                            return 8;
                        }
                        if (!this.usePC && var2_2) {
                            var3_3 = true;
                        } else {
                            this.posStart = this.pos;
                        }
                    } else {
                        if (this.isNameStartChar(var1_1)) {
                            if (!this.tokenize && var2_2) {
                                this.seenStartTag = true;
                                this.eventType = 4;
                                return 4;
                            }
                            this.eventType = this.parseStartTag();
                            return this.eventType;
                        }
                        throw new XmlPullParserException("unexpected character in markup " + this.printable(var1_1), this, null);
lbl98:
                        // 1 sources

                        if (var1_1 == '&') {
                            if (this.tokenize && var2_2) {
                                this.seenAmpersand = true;
                                this.eventType = 4;
                                return 4;
                            }
                            var4_4 = this.posStart + this.bufAbsoluteStart;
                            var5_5 = this.posEnd + this.bufAbsoluteStart;
                            var6_7 = this.parseEntityRef();
                            if (this.tokenize) {
                                this.eventType = 6;
                                return 6;
                            }
                            if (var6_7 == null) {
                                if (this.entityRefName == null) {
                                    this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
                                }
                                throw new XmlPullParserException("could not resolve entity named '" + this.printable(this.entityRefName) + "'", this, null);
                            }
                            this.posStart = var4_4 - this.bufAbsoluteStart;
                            this.posEnd = var5_5 - this.bufAbsoluteStart;
                            if (!this.usePC) {
                                if (var2_2) {
                                    this.joinPC();
                                    var3_3 = false;
                                } else {
                                    this.usePC = true;
                                    this.pcEnd = 0;
                                    this.pcStart = 0;
                                }
                            }
                            for (var7_8 = 0; var7_8 < var6_7.length; ++var7_8) {
                                if (this.pcEnd >= this.pc.length) {
                                    this.ensurePC(this.pcEnd);
                                }
                                this.pc[this.pcEnd++] = var6_7[var7_8];
                            }
                            var2_2 = true;
                        } else {
                            if (var3_3) {
                                this.joinPC();
                                var3_3 = false;
                            }
                            var2_2 = true;
                            var4_4 = 0;
                            var5_5 = this.tokenize == false || this.roundtripSupported == false ? 1 : 0;
                            var6_6 = 0;
                            var7_8 = 0;
                            do {
                                if (var1_1 == ']') {
                                    if (var6_6 != 0) {
                                        var7_8 = 1;
                                    } else {
                                        var6_6 = 1;
                                    }
                                } else {
                                    if (var7_8 != 0 && var1_1 == '>') {
                                        throw new XmlPullParserException("characters ]]> are not allowed in content", this, null);
                                    }
                                    if (var6_6 != 0) {
                                        var6_6 = 0;
                                        var7_8 = 0;
                                    }
                                }
                                if (var5_5 == 0) continue;
                                if (var1_1 == '\r') {
                                    var4_4 = 1;
                                    this.posEnd = this.pos - 1;
                                    if (!this.usePC) {
                                        if (this.posEnd > this.posStart) {
                                            this.joinPC();
                                        } else {
                                            this.usePC = true;
                                            this.pcEnd = 0;
                                            this.pcStart = 0;
                                        }
                                    }
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = 10;
                                    continue;
                                }
                                if (var1_1 == '\n') {
                                    if (var4_4 == 0 && this.usePC) {
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC(this.pcEnd);
                                        }
                                        this.pc[this.pcEnd++] = 10;
                                    }
                                    var4_4 = 0;
                                    continue;
                                }
                                if (this.usePC) {
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = var1_1;
                                }
                                var4_4 = 0;
                            } while ((var1_1 = this.more()) != '<' && var1_1 != 38);
                            this.posEnd = this.pos - 1;
                            continue;
                        }
                    }
                }
                var1_1 = this.more();
            }
        }
        if (this.seenRoot) {
            return this.parseEpilog();
        }
        return this.parseProlog();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int parseProlog() throws XmlPullParserException, IOException {
        char c = this.seenMarkup ? this.buf[this.pos - 1] : this.more();
        if (this.eventType == 0) {
            if (c == '\ufffe') {
                throw new XmlPullParserException("first character in input was UNICODE noncharacter (0xFFFE)- input requires int swapping", this, null);
            }
            if (c == '\ufeff') {
                c = this.more();
            }
        }
        this.seenMarkup = false;
        boolean bl = false;
        this.posStart = this.pos - 1;
        boolean bl2 = this.tokenize && !this.roundtripSupported;
        boolean bl3 = false;
        while (true) {
            block32: {
                block33: {
                    block34: {
                        if (c != '<') break block33;
                        if (bl && this.tokenize) {
                            this.posEnd = this.pos - 1;
                            this.seenMarkup = true;
                            this.eventType = 7;
                            return 7;
                        }
                        c = this.more();
                        if (c != '?') break block34;
                        if (this.parsePI()) {
                            if (this.tokenize) {
                                this.eventType = 8;
                                return 8;
                            }
                            break block32;
                        } else {
                            this.posStart = this.pos;
                            bl = false;
                        }
                        break block32;
                    }
                    if (c == '!') {
                        c = this.more();
                        if (c == 'D') {
                            if (this.seenDocdecl) {
                                throw new XmlPullParserException("only one docdecl allowed in XML document", this, null);
                            }
                            this.seenDocdecl = true;
                            this.parseDocdecl();
                            if (this.tokenize) {
                                this.eventType = 10;
                                return 10;
                            }
                            break block32;
                        } else {
                            if (c != '-') {
                                throw new XmlPullParserException("unexpected markup <!" + this.printable(c), this, null);
                            }
                            this.parseComment();
                            if (this.tokenize) {
                                this.eventType = 9;
                                return 9;
                            }
                        }
                        break block32;
                    } else {
                        if (c == '/') {
                            throw new XmlPullParserException("expected start tag name and not " + this.printable(c), this, null);
                        }
                        if (this.isNameStartChar(c)) {
                            this.seenRoot = true;
                            return this.parseStartTag();
                        }
                        throw new XmlPullParserException("expected start tag name and not " + this.printable(c), this, null);
                    }
                }
                if (!this.isS(c)) {
                    throw new XmlPullParserException("only whitespace content allowed before start tag and not " + this.printable(c), this, null);
                }
                bl = true;
                if (bl2) {
                    if (c == '\r') {
                        bl3 = true;
                        if (!this.usePC) {
                            this.posEnd = this.pos - 1;
                            if (this.posEnd > this.posStart) {
                                this.joinPC();
                            } else {
                                this.usePC = true;
                                this.pcEnd = 0;
                                this.pcStart = 0;
                            }
                        }
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                    } else if (c == '\n') {
                        if (!bl3 && this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = 10;
                        }
                        bl3 = false;
                    } else {
                        if (this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = c;
                        }
                        bl3 = false;
                    }
                }
            }
            c = this.more();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int parseEpilog() throws XmlPullParserException, IOException {
        boolean bl;
        block32: {
            if (this.eventType == 1) {
                throw new XmlPullParserException("already reached end of XML input", this, null);
            }
            if (this.reachedEnd) {
                this.eventType = 1;
                return 1;
            }
            bl = false;
            boolean bl2 = this.tokenize && !this.roundtripSupported;
            boolean bl3 = false;
            try {
                char c = this.seenMarkup ? this.buf[this.pos - 1] : this.more();
                this.seenMarkup = false;
                this.posStart = this.pos - 1;
                if (this.reachedEnd) break block32;
                do {
                    block33: {
                        block34: {
                            block35: {
                                if (c != '<') break block34;
                                if (bl && this.tokenize) {
                                    this.posEnd = this.pos - 1;
                                    this.seenMarkup = true;
                                    this.eventType = 7;
                                    return 7;
                                }
                                c = this.more();
                                if (this.reachedEnd) break block32;
                                if (c != '?') break block35;
                                this.parsePI();
                                if (this.tokenize) {
                                    this.eventType = 8;
                                    return 8;
                                }
                                break block33;
                            }
                            if (c == '!') {
                                c = this.more();
                                if (this.reachedEnd) break block32;
                                if (c == 'D') {
                                    this.parseDocdecl();
                                    if (this.tokenize) {
                                        this.eventType = 10;
                                        return 10;
                                    }
                                    break block33;
                                } else {
                                    if (c != '-') {
                                        throw new XmlPullParserException("unexpected markup <!" + this.printable(c), this, null);
                                    }
                                    this.parseComment();
                                    if (this.tokenize) {
                                        this.eventType = 9;
                                        return 9;
                                    }
                                }
                                break block33;
                            } else {
                                if (c == '/') {
                                    throw new XmlPullParserException("end tag not allowed in epilog but got " + this.printable(c), this, null);
                                }
                                if (this.isNameStartChar(c)) {
                                    throw new XmlPullParserException("start tag not allowed in epilog but got " + this.printable(c), this, null);
                                }
                                throw new XmlPullParserException("in epilog expected ignorable content and not " + this.printable(c), this, null);
                            }
                        }
                        if (!this.isS(c)) {
                            throw new XmlPullParserException("in epilog non whitespace content is not allowed but got " + this.printable(c), this, null);
                        }
                        bl = true;
                        if (bl2) {
                            if (c == '\r') {
                                bl3 = true;
                                if (!this.usePC) {
                                    this.posEnd = this.pos - 1;
                                    if (this.posEnd > this.posStart) {
                                        this.joinPC();
                                    } else {
                                        this.usePC = true;
                                        this.pcEnd = 0;
                                        this.pcStart = 0;
                                    }
                                }
                                if (this.pcEnd >= this.pc.length) {
                                    this.ensurePC(this.pcEnd);
                                }
                                this.pc[this.pcEnd++] = 10;
                            } else if (c == '\n') {
                                if (!bl3 && this.usePC) {
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = 10;
                                }
                                bl3 = false;
                            } else {
                                if (this.usePC) {
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = c;
                                }
                                bl3 = false;
                            }
                        }
                    }
                    c = this.more();
                } while (!this.reachedEnd);
            }
            catch (EOFException eOFException) {
                this.reachedEnd = true;
            }
        }
        if (!this.reachedEnd) {
            throw new XmlPullParserException("internal error in parseEpilog");
        }
        if (this.tokenize && bl) {
            this.posEnd = this.pos;
            this.eventType = 7;
            return 7;
        }
        this.eventType = 1;
        return 1;
    }

    public int parseEndTag() throws XmlPullParserException, IOException {
        char c = this.more();
        if (!this.isNameStartChar(c)) {
            throw new XmlPullParserException("expected name start and not " + this.printable(c), this, null);
        }
        this.posStart = this.pos - 3;
        int n = this.pos - 1 + this.bufAbsoluteStart;
        while (this.isNameChar(c = this.more())) {
        }
        int n2 = n - this.bufAbsoluteStart;
        int n3 = this.pos - 1 - n2;
        char[] cArray = this.elRawName[this.depth];
        if (this.elRawNameEnd[this.depth] != n3) {
            String string = new String(cArray, 0, this.elRawNameEnd[this.depth]);
            String string2 = new String(this.buf, n2, n3);
            throw new XmlPullParserException("end tag name </" + string2 + "> must match start tag name <" + string + ">" + " from line " + this.elRawNameLine[this.depth], this, null);
        }
        for (int i = 0; i < n3; ++i) {
            if (this.buf[n2++] == cArray[i]) continue;
            String string = new String(cArray, 0, n3);
            String string3 = new String(this.buf, n2 - i - 1, n3);
            throw new XmlPullParserException("end tag name </" + string3 + "> must be the same as start tag <" + string + ">" + " from line " + this.elRawNameLine[this.depth], this, null);
        }
        while (this.isS(c)) {
            c = this.more();
        }
        if (c != '>') {
            throw new XmlPullParserException("expected > to finish end tag not " + this.printable(c) + " from line " + this.elRawNameLine[this.depth], this, null);
        }
        this.posEnd = this.pos;
        this.pastEndTag = true;
        this.eventType = 3;
        return 3;
    }

    public int parseStartTag() throws XmlPullParserException, IOException {
        String string;
        block27: {
            ++this.depth;
            this.posStart = this.pos - 2;
            this.emptyElementTag = false;
            this.attributeCount = 0;
            int n = this.pos - 1 + this.bufAbsoluteStart;
            int n2 = -1;
            char c = this.buf[this.pos - 1];
            if (c == ':' && this.processNamespaces) {
                throw new XmlPullParserException("when namespaces processing enabled colon can not be at element name start", this, null);
            }
            while (this.isNameChar(c = this.more())) {
                if (c != ':' || !this.processNamespaces) continue;
                if (n2 != -1) {
                    throw new XmlPullParserException("only one colon is allowed in name of element when namespaces are enabled", this, null);
                }
                n2 = this.pos - 1 + this.bufAbsoluteStart;
            }
            this.ensureElementsCapacity();
            int n3 = this.pos - 1 - (n - this.bufAbsoluteStart);
            if (this.elRawName[this.depth] == null || this.elRawName[this.depth].length < n3) {
                this.elRawName[this.depth] = new char[2 * n3];
            }
            System.arraycopy(this.buf, n - this.bufAbsoluteStart, this.elRawName[this.depth], 0, n3);
            this.elRawNameEnd[this.depth] = n3;
            this.elRawNameLine[this.depth] = this.lineNumber;
            String string2 = null;
            string = null;
            if (this.processNamespaces) {
                if (n2 != -1) {
                    string = this.elPrefix[this.depth] = this.newString(this.buf, n - this.bufAbsoluteStart, n2 - n);
                    string2 = this.elName[this.depth] = this.newString(this.buf, n2 + 1 - this.bufAbsoluteStart, this.pos - 2 - (n2 - this.bufAbsoluteStart));
                } else {
                    this.elPrefix[this.depth] = null;
                    string = null;
                    string2 = this.elName[this.depth] = this.newString(this.buf, n - this.bufAbsoluteStart, n3);
                }
            } else {
                string2 = this.elName[this.depth] = this.newString(this.buf, n - this.bufAbsoluteStart, n3);
            }
            while (true) {
                if (this.isS(c)) {
                    c = this.more();
                    continue;
                }
                if (c == '>') break block27;
                if (c == '/') {
                    if (this.emptyElementTag) {
                        throw new XmlPullParserException("repeated / in tag declaration", this, null);
                    }
                    this.emptyElementTag = true;
                    c = this.more();
                    if (c != '>') {
                        throw new XmlPullParserException("expected > to end empty tag not " + this.printable(c), this, null);
                    }
                    break block27;
                }
                if (!this.isNameStartChar(c)) break;
                c = this.parseAttribute();
                c = this.more();
            }
            throw new XmlPullParserException("start tag unexpected character " + this.printable(c), this, null);
        }
        if (this.processNamespaces) {
            String string3;
            int n;
            String string4 = this.getNamespace(string);
            if (string4 == null) {
                if (string == null) {
                    string4 = "";
                } else {
                    throw new XmlPullParserException("could not determine namespace bound to element prefix " + string, this, null);
                }
            }
            this.elUri[this.depth] = string4;
            for (n = 0; n < this.attributeCount; ++n) {
                String string5 = this.attributePrefix[n];
                if (string5 != null) {
                    string3 = this.getNamespace(string5);
                    if (string3 == null) {
                        throw new XmlPullParserException("could not determine namespace bound to attribute prefix " + string5, this, null);
                    }
                    this.attributeUri[n] = string3;
                    continue;
                }
                this.attributeUri[n] = "";
            }
            for (n = 1; n < this.attributeCount; ++n) {
                for (int i = 0; i < n; ++i) {
                    if (this.attributeUri[i] != this.attributeUri[n] || (!this.allStringsInterned || !this.attributeName[i].equals(this.attributeName[n])) && (this.allStringsInterned || this.attributeNameHash[i] != this.attributeNameHash[n] || !this.attributeName[i].equals(this.attributeName[n]))) continue;
                    string3 = this.attributeName[i];
                    if (this.attributeUri[i] != null) {
                        string3 = this.attributeUri[i] + ":" + string3;
                    }
                    String string6 = this.attributeName[n];
                    if (this.attributeUri[n] != null) {
                        string6 = this.attributeUri[n] + ":" + string6;
                    }
                    throw new XmlPullParserException("duplicated attributes " + string3 + " and " + string6, this, null);
                }
            }
        } else {
            for (int i = 1; i < this.attributeCount; ++i) {
                for (int j = 0; j < i; ++j) {
                    if ((!this.allStringsInterned || !this.attributeName[j].equals(this.attributeName[i])) && (this.allStringsInterned || this.attributeNameHash[j] != this.attributeNameHash[i] || !this.attributeName[j].equals(this.attributeName[i]))) continue;
                    String string7 = this.attributeName[j];
                    String string8 = this.attributeName[i];
                    throw new XmlPullParserException("duplicated attributes " + string7 + " and " + string8, this, null);
                }
            }
        }
        this.elNamespaceCount[this.depth] = this.namespaceEnd;
        this.posEnd = this.pos;
        this.eventType = 2;
        return 2;
    }

    protected char parseAttribute() throws XmlPullParserException, IOException {
        int n;
        Object object;
        int n2;
        char c;
        int n3 = this.posStart + this.bufAbsoluteStart;
        int n4 = this.pos - 1 + this.bufAbsoluteStart;
        int n5 = -1;
        char c2 = this.buf[this.pos - 1];
        if (c2 == ':' && this.processNamespaces) {
            throw new XmlPullParserException("when namespaces processing enabled colon can not be at attribute name start", this, null);
        }
        boolean bl = this.processNamespaces && c2 == 'x';
        int n6 = 0;
        c2 = this.more();
        while (this.isNameChar(c2)) {
            if (this.processNamespaces) {
                if (bl && n6 < 5) {
                    if (++n6 == 1) {
                        if (c2 != 'm') {
                            bl = false;
                        }
                    } else if (n6 == 2) {
                        if (c2 != 'l') {
                            bl = false;
                        }
                    } else if (n6 == 3) {
                        if (c2 != 'n') {
                            bl = false;
                        }
                    } else if (n6 == 4) {
                        if (c2 != 's') {
                            bl = false;
                        }
                    } else if (n6 == 5 && c2 != ':') {
                        throw new XmlPullParserException("after xmlns in attribute name must be colonwhen namespaces are enabled", this, null);
                    }
                }
                if (c2 == ':') {
                    if (n5 != -1) {
                        throw new XmlPullParserException("only one colon is allowed in attribute name when namespaces are enabled", this, null);
                    }
                    n5 = this.pos - 1 + this.bufAbsoluteStart;
                }
            }
            c2 = this.more();
        }
        this.ensureAttributesCapacity(this.attributeCount);
        String string = null;
        String string2 = null;
        if (this.processNamespaces) {
            if (n6 < 4) {
                bl = false;
            }
            if (bl) {
                if (n5 != -1) {
                    c = this.pos - 2 - (n5 - this.bufAbsoluteStart);
                    if (c == '\u0000') {
                        throw new XmlPullParserException("namespace prefix is required after xmlns:  when namespaces are enabled", this, null);
                    }
                    string = this.newString(this.buf, n5 - this.bufAbsoluteStart + 1, c);
                }
            } else {
                if (n5 != -1) {
                    c = n5 - n4;
                    string2 = this.attributePrefix[this.attributeCount] = this.newString(this.buf, n4 - this.bufAbsoluteStart, c);
                    n2 = this.pos - 2 - (n5 - this.bufAbsoluteStart);
                    string = this.attributeName[this.attributeCount] = this.newString(this.buf, n5 - this.bufAbsoluteStart + 1, n2);
                } else {
                    this.attributePrefix[this.attributeCount] = null;
                    string2 = null;
                    string = this.attributeName[this.attributeCount] = this.newString(this.buf, n4 - this.bufAbsoluteStart, this.pos - 1 - (n4 - this.bufAbsoluteStart));
                }
                if (!this.allStringsInterned) {
                    this.attributeNameHash[this.attributeCount] = string.hashCode();
                }
            }
        } else {
            string = this.attributeName[this.attributeCount] = this.newString(this.buf, n4 - this.bufAbsoluteStart, this.pos - 1 - (n4 - this.bufAbsoluteStart));
            if (!this.allStringsInterned) {
                this.attributeNameHash[this.attributeCount] = string.hashCode();
            }
        }
        while (this.isS(c2)) {
            c2 = this.more();
        }
        if (c2 != '=') {
            throw new XmlPullParserException("expected = after attribute name", this, null);
        }
        c2 = this.more();
        while (this.isS(c2)) {
            c2 = this.more();
        }
        c = c2;
        if (c != '\"' && c != '\'') {
            throw new XmlPullParserException("attribute value must start with quotation or apostrophe not " + this.printable(c), this, null);
        }
        n2 = 0;
        this.usePC = false;
        this.pcStart = this.pcEnd;
        this.posStart = this.pos;
        while ((c2 = this.more()) != c) {
            if (c2 == '<') {
                throw new XmlPullParserException("markup not allowed inside attribute value - illegal < ", this, null);
            }
            if (c2 == '&') {
                this.posEnd = this.pos - 1;
                if (!this.usePC) {
                    boolean bl2;
                    boolean bl3 = bl2 = this.posEnd > this.posStart;
                    if (bl2) {
                        this.joinPC();
                    } else {
                        this.usePC = true;
                        this.pcEnd = 0;
                        this.pcStart = 0;
                    }
                }
                if ((object = this.parseEntityRef()) == null) {
                    if (this.entityRefName == null) {
                        this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
                    }
                    throw new XmlPullParserException("could not resolve entity named '" + this.printable(this.entityRefName) + "'", this, null);
                }
                for (n = 0; n < ((char[])object).length; ++n) {
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = (char)object[n];
                }
            } else if (c2 == '\t' || c2 == '\n' || c2 == '\r') {
                if (!this.usePC) {
                    this.posEnd = this.pos - 1;
                    if (this.posEnd > this.posStart) {
                        this.joinPC();
                    } else {
                        this.usePC = true;
                        this.pcStart = 0;
                        this.pcEnd = 0;
                    }
                }
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                if (c2 != '\n' || n2 == 0) {
                    this.pc[this.pcEnd++] = 32;
                }
            } else if (this.usePC) {
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                this.pc[this.pcEnd++] = c2;
            }
            n2 = c2 == '\r' ? 1 : 0;
        }
        if (this.processNamespaces && bl) {
            object = null;
            object = !this.usePC ? (Object)this.newStringIntern(this.buf, this.posStart, this.pos - 1 - this.posStart) : (Object)this.newStringIntern(this.pc, this.pcStart, this.pcEnd - this.pcStart);
            this.ensureNamespacesCapacity(this.namespaceEnd);
            n = -1;
            if (n5 != -1) {
                if (((String)object).length() == 0) {
                    throw new XmlPullParserException("non-default namespace can not be declared to be empty string", this, null);
                }
                this.namespacePrefix[this.namespaceEnd] = string;
                if (!this.allStringsInterned) {
                    n = this.namespacePrefixHash[this.namespaceEnd] = string.hashCode();
                }
            } else {
                this.namespacePrefix[this.namespaceEnd] = null;
                if (!this.allStringsInterned) {
                    this.namespacePrefixHash[this.namespaceEnd] = -1;
                    n = -1;
                }
            }
            this.namespaceUri[this.namespaceEnd] = object;
            int n7 = this.elNamespaceCount[this.depth - 1];
            for (int i = this.namespaceEnd - 1; i >= n7; --i) {
                if ((!this.allStringsInterned && string != null || this.namespacePrefix[i] != string) && (this.allStringsInterned || string == null || this.namespacePrefixHash[i] != n || !string.equals(this.namespacePrefix[i]))) continue;
                String string3 = string == null ? "default" : "'" + string + "'";
                throw new XmlPullParserException("duplicated namespace declaration for " + string3 + " prefix", this, null);
            }
            ++this.namespaceEnd;
        } else {
            this.attributeValue[this.attributeCount] = !this.usePC ? new String(this.buf, this.posStart, this.pos - 1 - this.posStart) : new String(this.pc, this.pcStart, this.pcEnd - this.pcStart);
            ++this.attributeCount;
        }
        this.posStart = n3 - this.bufAbsoluteStart;
        return c2;
    }

    protected char[] parseEntityRef() throws XmlPullParserException, IOException {
        this.entityRefName = null;
        this.posStart = this.pos;
        char c = this.more();
        if (c == '#') {
            int n = 0;
            c = this.more();
            if (c == 'x') {
                while (true) {
                    if ((c = this.more()) >= '0' && c <= '9') {
                        n = (char)(n * 16 + (c - 48));
                        continue;
                    }
                    if (c >= 'a' && c <= 'f') {
                        n = (char)(n * 16 + (c - 87));
                        continue;
                    }
                    if (c < 'A' || c > 'F') break;
                    n = (char)(n * 16 + (c - 55));
                }
                if (c != ';') {
                    throw new XmlPullParserException("character reference (with hex value) may not contain " + this.printable(c), this, null);
                }
            } else {
                while (true) {
                    if (c < '0' || c > '9') {
                        if (c == ';') break;
                        throw new XmlPullParserException("character reference (with decimal value) may not contain " + this.printable(c), this, null);
                    }
                    n = (char)(n * 10 + (c - 48));
                    c = this.more();
                }
            }
            this.posEnd = this.pos - 1;
            this.charRefOneCharBuf[0] = n;
            if (this.tokenize) {
                this.text = this.newString(this.charRefOneCharBuf, 0, 1);
            }
            return this.charRefOneCharBuf;
        }
        if (!this.isNameStartChar(c)) {
            throw new XmlPullParserException("entity reference names can not start with character '" + this.printable(c) + "'", this, null);
        }
        while ((c = this.more()) != ';') {
            if (this.isNameChar(c)) continue;
            throw new XmlPullParserException("entity reference name can not contain character " + this.printable(c) + "'", this, null);
        }
        this.posEnd = this.pos - 1;
        int n = this.posEnd - this.posStart;
        if (n == 2 && this.buf[this.posStart] == 'l' && this.buf[this.posStart + 1] == 't') {
            if (this.tokenize) {
                this.text = "<";
            }
            this.charRefOneCharBuf[0] = 60;
            return this.charRefOneCharBuf;
        }
        if (n == 3 && this.buf[this.posStart] == 'a' && this.buf[this.posStart + 1] == 'm' && this.buf[this.posStart + 2] == 'p') {
            if (this.tokenize) {
                this.text = "&";
            }
            this.charRefOneCharBuf[0] = 38;
            return this.charRefOneCharBuf;
        }
        if (n == 2 && this.buf[this.posStart] == 'g' && this.buf[this.posStart + 1] == 't') {
            if (this.tokenize) {
                this.text = ">";
            }
            this.charRefOneCharBuf[0] = 62;
            return this.charRefOneCharBuf;
        }
        if (n == 4 && this.buf[this.posStart] == 'a' && this.buf[this.posStart + 1] == 'p' && this.buf[this.posStart + 2] == 'o' && this.buf[this.posStart + 3] == 's') {
            if (this.tokenize) {
                this.text = "'";
            }
            this.charRefOneCharBuf[0] = 39;
            return this.charRefOneCharBuf;
        }
        if (n == 4 && this.buf[this.posStart] == 'q' && this.buf[this.posStart + 1] == 'u' && this.buf[this.posStart + 2] == 'o' && this.buf[this.posStart + 3] == 't') {
            if (this.tokenize) {
                this.text = "\"";
            }
            this.charRefOneCharBuf[0] = 34;
            return this.charRefOneCharBuf;
        }
        char[] cArray = this.lookuEntityReplacement(n);
        if (cArray != null) {
            return cArray;
        }
        if (this.tokenize) {
            this.text = null;
        }
        return null;
    }

    protected char[] lookuEntityReplacement(int n) throws XmlPullParserException, IOException {
        if (!this.allStringsInterned) {
            int n2 = MXParser.fastHash(this.buf, this.posStart, this.posEnd - this.posStart);
            block0: for (int i = this.entityEnd - 1; i >= 0; --i) {
                if (n2 != this.entityNameHash[i] || n != this.entityNameBuf[i].length) continue;
                char[] cArray = this.entityNameBuf[i];
                for (int j = 0; j < n; ++j) {
                    if (this.buf[this.posStart + j] != cArray[j]) continue block0;
                }
                if (this.tokenize) {
                    this.text = this.entityReplacement[i];
                }
                return this.entityReplacementBuf[i];
            }
        } else {
            this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
            for (int i = this.entityEnd - 1; i >= 0; --i) {
                if (this.entityRefName != this.entityName[i]) continue;
                if (this.tokenize) {
                    this.text = this.entityReplacement[i];
                }
                return this.entityReplacementBuf[i];
            }
        }
        return null;
    }

    protected void parseComment() throws XmlPullParserException, IOException {
        char c = this.more();
        if (c != '-') {
            throw new XmlPullParserException("expected <!-- for comment start", this, null);
        }
        if (this.tokenize) {
            this.posStart = this.pos;
        }
        int n = this.lineNumber;
        int n2 = this.columnNumber;
        try {
            boolean bl = this.tokenize && !this.roundtripSupported;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            while (true) {
                c = this.more();
                if (bl4 && c != '>') {
                    throw new XmlPullParserException("in comment after two dashes (--) next character must be > not " + this.printable(c), this, null);
                }
                if (c == '-') {
                    if (!bl3) {
                        bl3 = true;
                    } else {
                        bl4 = true;
                        bl3 = false;
                    }
                } else if (c == '>') {
                    if (bl4) break;
                    bl4 = false;
                    bl3 = false;
                } else {
                    bl3 = false;
                }
                if (!bl) continue;
                if (c == '\r') {
                    bl2 = true;
                    if (!this.usePC) {
                        this.posEnd = this.pos - 1;
                        if (this.posEnd > this.posStart) {
                            this.joinPC();
                        } else {
                            this.usePC = true;
                            this.pcEnd = 0;
                            this.pcStart = 0;
                        }
                    }
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = 10;
                    continue;
                }
                if (c == '\n') {
                    if (!bl2 && this.usePC) {
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                    }
                    bl2 = false;
                    continue;
                }
                if (this.usePC) {
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = c;
                }
                bl2 = false;
            }
        }
        catch (EOFException eOFException) {
            throw new XmlPullParserException("comment started on line " + n + " and column " + n2 + " was not closed", this, eOFException);
        }
        if (this.tokenize) {
            this.posEnd = this.pos - 3;
            if (this.usePC) {
                this.pcEnd -= 2;
            }
        }
    }

    protected boolean parsePI() throws XmlPullParserException, IOException {
        if (this.tokenize) {
            this.posStart = this.pos;
        }
        int n = this.lineNumber;
        int n2 = this.columnNumber;
        int n3 = this.pos + this.bufAbsoluteStart;
        int n4 = -1;
        boolean bl = this.tokenize && !this.roundtripSupported;
        boolean bl2 = false;
        try {
            boolean bl3 = false;
            char c = this.more();
            if (this.isS(c)) {
                throw new XmlPullParserException("processing instruction PITarget must be exactly after <? and not white space character", this, null);
            }
            while (true) {
                if (c == '?') {
                    bl3 = true;
                } else if (c == '>') {
                    if (bl3) break;
                    bl3 = false;
                } else {
                    if (!(n4 != -1 || !this.isS(c) || (n4 = this.pos - 1 + this.bufAbsoluteStart) - n3 != 3 || this.buf[n3] != 'x' && this.buf[n3] != 'X' || this.buf[n3 + 1] != 'm' && this.buf[n3 + 1] != 'M' || this.buf[n3 + 2] != 'l' && this.buf[n3 + 2] != 'L')) {
                        if (n3 > 3) {
                            throw new XmlPullParserException("processing instruction can not have PITarget with reserveld xml name", this, null);
                        }
                        if (this.buf[n3] != 'x' && this.buf[n3 + 1] != 'm' && this.buf[n3 + 2] != 'l') {
                            throw new XmlPullParserException("XMLDecl must have xml name in lowercase", this, null);
                        }
                        this.parseXmlDecl(c);
                        if (this.tokenize) {
                            this.posEnd = this.pos - 2;
                        }
                        int n5 = n3 - this.bufAbsoluteStart + 3;
                        int n6 = this.pos - 2 - n5;
                        this.xmlDeclContent = this.newString(this.buf, n5, n6);
                        return false;
                    }
                    bl3 = false;
                }
                if (bl) {
                    if (c == '\r') {
                        bl2 = true;
                        if (!this.usePC) {
                            this.posEnd = this.pos - 1;
                            if (this.posEnd > this.posStart) {
                                this.joinPC();
                            } else {
                                this.usePC = true;
                                this.pcEnd = 0;
                                this.pcStart = 0;
                            }
                        }
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                    } else if (c == '\n') {
                        if (!bl2 && this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = 10;
                        }
                        bl2 = false;
                    } else {
                        if (this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = c;
                        }
                        bl2 = false;
                    }
                }
                c = this.more();
            }
        }
        catch (EOFException eOFException) {
            throw new XmlPullParserException("processing instruction started on line " + n + " and column " + n2 + " was not closed", this, eOFException);
        }
        if (n4 == -1) {
            n4 = this.pos - 2 + this.bufAbsoluteStart;
        }
        n3 -= this.bufAbsoluteStart;
        n4 -= this.bufAbsoluteStart;
        if (this.tokenize) {
            this.posEnd = this.pos - 2;
            if (bl) {
                --this.pcEnd;
            }
        }
        return true;
    }

    protected void parseXmlDecl(char c) throws XmlPullParserException, IOException {
        this.preventBufferCompaction = true;
        this.bufStart = 0;
        c = this.skipS(c);
        c = this.requireInput(c, VERSION);
        if ((c = this.skipS(c)) != '=') {
            throw new XmlPullParserException("expected equals sign (=) after version and not " + this.printable(c), this, null);
        }
        c = this.more();
        if ((c = this.skipS(c)) != '\'' && c != '\"') {
            throw new XmlPullParserException("expected apostrophe (') or quotation mark (\") after version and not " + this.printable(c), this, null);
        }
        char c2 = c;
        int n = this.pos;
        c = this.more();
        while (c != c2) {
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == ':' || c == '-')) {
                throw new XmlPullParserException("<?xml version value expected to be in ([a-zA-Z0-9_.:] | '-') not " + this.printable(c), this, null);
            }
            c = this.more();
        }
        int n2 = this.pos - 1;
        this.parseXmlDeclWithVersion(n, n2);
        this.preventBufferCompaction = false;
    }

    protected void parseXmlDeclWithVersion(int n, int n2) throws XmlPullParserException, IOException {
        int n3;
        char c;
        String string = this.inputEncoding;
        if (n2 - n != 3 || this.buf[n] != '1' || this.buf[n + 1] != '.' || this.buf[n + 2] != '0') {
            throw new XmlPullParserException("only 1.0 is supported as <?xml version not '" + this.printable(new String(this.buf, n, n2 - n)) + "'", this, null);
        }
        this.xmlDeclVersion = this.newString(this.buf, n, n2 - n);
        char c2 = this.more();
        if ((c2 = this.skipS(c2)) == 'e') {
            c2 = this.more();
            c2 = this.requireInput(c2, NCODING);
            if ((c2 = this.skipS(c2)) != '=') {
                throw new XmlPullParserException("expected equals sign (=) after encoding and not " + this.printable(c2), this, null);
            }
            c2 = this.more();
            if ((c2 = this.skipS(c2)) != '\'' && c2 != '\"') {
                throw new XmlPullParserException("expected apostrophe (') or quotation mark (\") after encoding and not " + this.printable(c2), this, null);
            }
            c = c2;
            n3 = this.pos;
            c2 = this.more();
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                throw new XmlPullParserException("<?xml encoding name expected to start with [A-Za-z] not " + this.printable(c2), this, null);
            }
            c2 = this.more();
            while (c2 != c) {
                if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '_' || c2 == '-')) {
                    throw new XmlPullParserException("<?xml encoding value expected to be in ([A-Za-z0-9._] | '-') not " + this.printable(c2), this, null);
                }
                c2 = this.more();
            }
            int n4 = this.pos - 1;
            this.inputEncoding = this.newString(this.buf, n3, n4 - n3);
            c2 = this.more();
        }
        if ((c2 = this.skipS(c2)) == 's') {
            c2 = this.more();
            c2 = this.requireInput(c2, TANDALONE);
            if ((c2 = this.skipS(c2)) != '=') {
                throw new XmlPullParserException("expected equals sign (=) after standalone and not " + this.printable(c2), this, null);
            }
            c2 = this.more();
            if ((c2 = this.skipS(c2)) != '\'' && c2 != '\"') {
                throw new XmlPullParserException("expected apostrophe (') or quotation mark (\") after encoding and not " + this.printable(c2), this, null);
            }
            c = c2;
            n3 = this.pos;
            c2 = this.more();
            if (c2 == 'y') {
                c2 = this.requireInput(c2, YES);
                this.xmlDeclStandalone = new Boolean(true);
            } else if (c2 == 'n') {
                c2 = this.requireInput(c2, NO);
                this.xmlDeclStandalone = new Boolean(false);
            } else {
                throw new XmlPullParserException("expected 'yes' or 'no' after standalone and not " + this.printable(c2), this, null);
            }
            if (c2 != c) {
                throw new XmlPullParserException("expected " + c + " after standalone value not " + this.printable(c2), this, null);
            }
            c2 = this.more();
        }
        if ((c2 = this.skipS(c2)) != '?') {
            throw new XmlPullParserException("expected ?> as last part of <?xml not " + this.printable(c2), this, null);
        }
        c2 = this.more();
        if (c2 != '>') {
            throw new XmlPullParserException("expected ?> as last part of <?xml not " + this.printable(c2), this, null);
        }
    }

    protected void parseDocdecl() throws XmlPullParserException, IOException {
        char c = this.more();
        if (c != 'O') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        c = this.more();
        if (c != 'C') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        c = this.more();
        if (c != 'T') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        c = this.more();
        if (c != 'Y') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        c = this.more();
        if (c != 'P') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        c = this.more();
        if (c != 'E') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        this.posStart = this.pos;
        int n = 0;
        boolean bl = this.tokenize && !this.roundtripSupported;
        boolean bl2 = false;
        while (true) {
            if ((c = this.more()) == '[') {
                ++n;
            }
            if (c == ']') {
                --n;
            }
            if (c == '>' && n == 0) break;
            if (!bl) continue;
            if (c == '\r') {
                bl2 = true;
                if (!this.usePC) {
                    this.posEnd = this.pos - 1;
                    if (this.posEnd > this.posStart) {
                        this.joinPC();
                    } else {
                        this.usePC = true;
                        this.pcEnd = 0;
                        this.pcStart = 0;
                    }
                }
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                this.pc[this.pcEnd++] = 10;
                continue;
            }
            if (c == '\n') {
                if (!bl2 && this.usePC) {
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = 10;
                }
                bl2 = false;
                continue;
            }
            if (this.usePC) {
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                this.pc[this.pcEnd++] = c;
            }
            bl2 = false;
        }
        this.posEnd = this.pos - 1;
    }

    protected void parseCDSect(boolean bl) throws XmlPullParserException, IOException {
        char c = this.more();
        if (c != 'C') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        c = this.more();
        if (c != 'D') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        c = this.more();
        if (c != 'A') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        c = this.more();
        if (c != 'T') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        c = this.more();
        if (c != 'A') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        c = this.more();
        if (c != '[') {
            throw new XmlPullParserException("expected <![CDATA[ for comment start", this, null);
        }
        int n = this.pos + this.bufAbsoluteStart;
        int n2 = this.lineNumber;
        int n3 = this.columnNumber;
        boolean bl2 = !this.tokenize || !this.roundtripSupported;
        try {
            if (bl2 && bl && !this.usePC) {
                if (this.posEnd > this.posStart) {
                    this.joinPC();
                } else {
                    this.usePC = true;
                    this.pcEnd = 0;
                    this.pcStart = 0;
                }
            }
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            while (true) {
                if ((c = this.more()) == ']') {
                    if (!bl3) {
                        bl3 = true;
                    } else {
                        bl4 = true;
                    }
                } else if (c == '>') {
                    if (bl3 && bl4) break;
                    bl4 = false;
                    bl3 = false;
                } else if (bl3) {
                    bl3 = false;
                }
                if (!bl2) continue;
                if (c == '\r') {
                    bl5 = true;
                    this.posStart = n - this.bufAbsoluteStart;
                    this.posEnd = this.pos - 1;
                    if (!this.usePC) {
                        if (this.posEnd > this.posStart) {
                            this.joinPC();
                        } else {
                            this.usePC = true;
                            this.pcEnd = 0;
                            this.pcStart = 0;
                        }
                    }
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = 10;
                    continue;
                }
                if (c == '\n') {
                    if (!bl5 && this.usePC) {
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                    }
                    bl5 = false;
                    continue;
                }
                if (this.usePC) {
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = c;
                }
                bl5 = false;
            }
        }
        catch (EOFException eOFException) {
            throw new XmlPullParserException("CDATA section started on line " + n2 + " and column " + n3 + " was not closed", this, eOFException);
        }
        if (bl2 && this.usePC) {
            this.pcEnd -= 2;
        }
        this.posStart = n - this.bufAbsoluteStart;
        this.posEnd = this.pos - 3;
    }

    protected void fillBuf() throws IOException, XmlPullParserException {
        int n;
        int n2;
        if (this.reader == null) {
            throw new XmlPullParserException("reader must be set before parsing is started");
        }
        if (this.bufEnd > this.bufSoftLimit) {
            n2 = this.bufStart > this.bufSoftLimit ? 1 : 0;
            n = 0;
            if (this.preventBufferCompaction) {
                n2 = 0;
                n = 1;
            } else if (n2 == 0) {
                if (this.bufStart < this.buf.length / 2) {
                    n = 1;
                } else {
                    n2 = 1;
                }
            }
            if (n2 != 0) {
                System.arraycopy(this.buf, this.bufStart, this.buf, 0, this.bufEnd - this.bufStart);
            } else if (n != 0) {
                int n3 = 2 * this.buf.length;
                char[] cArray = new char[n3];
                System.arraycopy(this.buf, this.bufStart, cArray, 0, this.bufEnd - this.bufStart);
                this.buf = cArray;
                if (this.bufLoadFactor > 0) {
                    this.bufSoftLimit = (int)((long)this.bufLoadFactor * (long)this.buf.length / 100L);
                }
            } else {
                throw new XmlPullParserException("internal error in fillBuffer()");
            }
            this.bufEnd -= this.bufStart;
            this.pos -= this.bufStart;
            this.posStart -= this.bufStart;
            this.posEnd -= this.bufStart;
            this.bufAbsoluteStart += this.bufStart;
            this.bufStart = 0;
        }
        if ((n = this.reader.read(this.buf, this.bufEnd, n2 = this.buf.length - this.bufEnd > 8192 ? 8192 : this.buf.length - this.bufEnd)) > 0) {
            this.bufEnd += n;
            return;
        }
        if (n == -1) {
            if (this.bufAbsoluteStart == 0 && this.pos == 0) {
                throw new EOFException("input contained no data");
            }
            if (this.seenRoot && this.depth == 0) {
                this.reachedEnd = true;
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this.depth > 0) {
                String string;
                int n4;
                stringBuffer.append(" - expected end tag");
                if (this.depth > 1) {
                    stringBuffer.append("s");
                }
                stringBuffer.append(" ");
                for (n4 = this.depth; n4 > 0; --n4) {
                    string = new String(this.elRawName[n4], 0, this.elRawNameEnd[n4]);
                    stringBuffer.append("</").append(string).append('>');
                }
                stringBuffer.append(" to close");
                for (n4 = this.depth; n4 > 0; --n4) {
                    if (n4 != this.depth) {
                        stringBuffer.append(" and");
                    }
                    string = new String(this.elRawName[n4], 0, this.elRawNameEnd[n4]);
                    stringBuffer.append(" start tag <" + string + ">");
                    stringBuffer.append(" from line " + this.elRawNameLine[n4]);
                }
                stringBuffer.append(", parser stopped on");
            }
            throw new EOFException("no more data available" + stringBuffer.toString() + this.getPositionDescription());
        }
        throw new IOException("error reading input, returned " + n);
    }

    protected char more() throws IOException, XmlPullParserException {
        char c;
        if (this.pos >= this.bufEnd) {
            this.fillBuf();
            if (this.reachedEnd) {
                return '\uffff';
            }
        }
        if ((c = this.buf[this.pos++]) == '\n') {
            ++this.lineNumber;
            this.columnNumber = 1;
        } else {
            ++this.columnNumber;
        }
        return c;
    }

    protected void ensurePC(int n) {
        int n2 = n > 8192 ? 2 * n : 16384;
        char[] cArray = new char[n2];
        System.arraycopy(this.pc, 0, cArray, 0, this.pcEnd);
        this.pc = cArray;
    }

    protected void joinPC() {
        int n = this.posEnd - this.posStart;
        int n2 = this.pcEnd + n + 1;
        if (n2 >= this.pc.length) {
            this.ensurePC(n2);
        }
        System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n);
        this.pcEnd += n;
        this.usePC = true;
    }

    protected char requireInput(char c, char[] cArray) throws XmlPullParserException, IOException {
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) {
                throw new XmlPullParserException("expected " + this.printable(cArray[i]) + " in " + new String(cArray) + " and not " + this.printable(c), this, null);
            }
            c = this.more();
        }
        return c;
    }

    protected char requireNextS() throws XmlPullParserException, IOException {
        char c = this.more();
        if (!this.isS(c)) {
            throw new XmlPullParserException("white space is required and not " + this.printable(c), this, null);
        }
        return this.skipS(c);
    }

    protected char skipS(char c) throws XmlPullParserException, IOException {
        while (this.isS(c)) {
            c = this.more();
        }
        return c;
    }

    private static final void setName(char c) {
        MXParser.lookupNameChar[c] = true;
    }

    private static final void setNameStart(char c) {
        MXParser.lookupNameStartChar[c] = true;
        MXParser.setName(c);
    }

    protected boolean isNameStartChar(char c) {
        return c < '\u0400' && lookupNameStartChar[c] || c >= '\u0400' && c <= '\u2027' || c >= '\u202a' && c <= '\u218f' || c >= '\u2800' && c <= '\uffef';
    }

    protected boolean isNameChar(char c) {
        return c < '\u0400' && lookupNameChar[c] || c >= '\u0400' && c <= '\u2027' || c >= '\u202a' && c <= '\u218f' || c >= '\u2800' && c <= '\uffef';
    }

    protected boolean isS(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    protected String printable(char c) {
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\'') {
            return "\\'";
        }
        if (c > '\u007f' || c < ' ') {
            return "\\u" + Integer.toHexString(c);
        }
        return "" + c;
    }

    protected String printable(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 10);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.printable(string.charAt(i)));
        }
        string = stringBuffer.toString();
        return string;
    }

    static {
        char c;
        VERSION = "version".toCharArray();
        NCODING = "ncoding".toCharArray();
        TANDALONE = "tandalone".toCharArray();
        YES = "yes".toCharArray();
        NO = "no".toCharArray();
        lookupNameStartChar = new boolean[1024];
        lookupNameChar = new boolean[1024];
        MXParser.setNameStart(':');
        for (c = 'A'; c <= 'Z'; c = (char)((char)(c + 1))) {
            MXParser.setNameStart(c);
        }
        MXParser.setNameStart('_');
        for (c = 'a'; c <= 'z'; c = (char)((char)(c + 1))) {
            MXParser.setNameStart(c);
        }
        for (c = '\u00c0'; c <= '\u02ff'; c = (char)((char)(c + 1))) {
            MXParser.setNameStart(c);
        }
        for (c = '\u0370'; c <= '\u037d'; c = (char)((char)(c + 1))) {
            MXParser.setNameStart(c);
        }
        for (c = '\u037f'; c < '\u0400'; c = (char)((char)(c + '\u0001'))) {
            MXParser.setNameStart(c);
        }
        MXParser.setName('-');
        MXParser.setName('.');
        for (c = '0'; c <= '9'; c = (char)((char)(c + 1))) {
            MXParser.setName(c);
        }
        MXParser.setName('\u00b7');
        for (c = '\u0300'; c <= '\u036f'; c = (char)(c + '\u0001')) {
            MXParser.setName(c);
        }
    }
}

