/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.builder.Iterable;
import org.xmlpull.v1.builder.XmlAttribute;
import org.xmlpull.v1.builder.XmlBuilderException;
import org.xmlpull.v1.builder.XmlCharacters;
import org.xmlpull.v1.builder.XmlContained;
import org.xmlpull.v1.builder.XmlContainer;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlNamespace;
import org.xmlpull.v1.builder.impl.XmlAttributeImpl;
import org.xmlpull.v1.builder.impl.XmlNamespaceImpl;

public class XmlElementImpl
implements XmlElement {
    private XmlContainer parent;
    private XmlNamespace namespace;
    private String name;
    private List attrs;
    private List nsList;
    private List children;
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    private static final Iterable EMPTY_ITERABLE = new Iterable(){

        public Iterator iterator() {
            return EMPTY_ITERATOR;
        }
    };

    public Object clone() throws CloneNotSupportedException {
        XmlElementImpl xmlElementImpl = (XmlElementImpl)super.clone();
        xmlElementImpl.parent = null;
        xmlElementImpl.attrs = this.cloneList(xmlElementImpl, this.attrs);
        xmlElementImpl.nsList = this.cloneList(xmlElementImpl, this.nsList);
        xmlElementImpl.children = this.cloneList(xmlElementImpl, this.children);
        if (xmlElementImpl.children != null) {
            for (int i = 0; i < xmlElementImpl.children.size(); ++i) {
                XmlContained xmlContained;
                Object e = xmlElementImpl.children.get(i);
                if (!(e instanceof XmlContained) || (xmlContained = (XmlContained)e).getParent() != this) continue;
                xmlContained.setParent(null);
                xmlContained.setParent(xmlElementImpl);
            }
        }
        return xmlElementImpl;
    }

    private List cloneList(XmlElementImpl xmlElementImpl, List list) throws CloneNotSupportedException {
        if (list == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Cloneable cloneable;
            Object object;
            Object e = list.get(i);
            if (e instanceof XmlNamespace || e instanceof String) {
                object = e;
            } else if (e instanceof XmlElement) {
                cloneable = (XmlElement)e;
                object = cloneable.clone();
            } else if (e instanceof XmlAttribute) {
                cloneable = (XmlAttribute)e;
                object = new XmlAttributeImpl(xmlElementImpl, cloneable.getType(), cloneable.getNamespace(), cloneable.getName(), cloneable.getValue(), cloneable.isSpecified());
            } else if (e instanceof Cloneable) {
                try {
                    object = e.getClass().getMethod("clone", null).invoke(e, null);
                }
                catch (Exception exception) {
                    throw new CloneNotSupportedException("failed to call clone() on  " + e + exception);
                }
            } else {
                throw new CloneNotSupportedException();
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    XmlElementImpl(String string) {
        this.name = string;
    }

    XmlElementImpl(XmlNamespace xmlNamespace, String string) {
        this.namespace = xmlNamespace;
        this.name = string;
    }

    XmlElementImpl(String string, String string2) {
        if (string != null) {
            this.namespace = new XmlNamespaceImpl(null, string);
        }
        this.name = string2;
    }

    public XmlContainer getRoot() {
        XmlElement xmlElement;
        XmlContainer xmlContainer = this;
        while (xmlContainer instanceof XmlElement && (xmlElement = (XmlElement)xmlContainer).getParent() != null) {
            xmlContainer = xmlElement.getParent();
        }
        return xmlContainer;
    }

    public XmlContainer getParent() {
        return this.parent;
    }

    public void setParent(XmlContainer xmlContainer) {
        XmlDocument xmlDocument;
        if (xmlContainer != null && xmlContainer instanceof XmlDocument && (xmlDocument = (XmlDocument)xmlContainer).getDocumentElement() != this) {
            throw new XmlBuilderException("this element must be root document element to have document set as parent but already different element is set as root document element");
        }
        this.parent = xmlContainer;
    }

    public XmlNamespace getNamespace() {
        return this.namespace;
    }

    public String getNamespaceName() {
        return this.namespace != null ? this.namespace.getNamespaceName() : null;
    }

    public void setNamespace(XmlNamespace xmlNamespace) {
        this.namespace = xmlNamespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return "name[" + this.name + "]" + (this.namespace != null ? " namespace[" + this.namespace.getNamespaceName() + "]" : "");
    }

    public String getBaseUri() {
        throw new XmlBuilderException("not implemented");
    }

    public void setBaseUri(String string) {
        throw new XmlBuilderException("not implemented");
    }

    public Iterator attributes() {
        if (this.attrs == null) {
            return EMPTY_ITERATOR;
        }
        return this.attrs.iterator();
    }

    public XmlAttribute addAttribute(XmlAttribute xmlAttribute) {
        if (this.attrs == null) {
            this.ensureAttributeCapacity(5);
        }
        this.attrs.add(xmlAttribute);
        return xmlAttribute;
    }

    public XmlAttribute addAttribute(XmlNamespace xmlNamespace, String string, String string2) {
        return this.addAttribute("CDATA", xmlNamespace, string, string2, false);
    }

    public XmlAttribute addAttribute(String string, String string2) {
        return this.addAttribute("CDATA", null, string, string2, false);
    }

    public XmlAttribute addAttribute(String string, XmlNamespace xmlNamespace, String string2, String string3) {
        return this.addAttribute(string, xmlNamespace, string2, string3, false);
    }

    public XmlAttribute addAttribute(String string, XmlNamespace xmlNamespace, String string2, String string3, boolean bl) {
        XmlAttributeImpl xmlAttributeImpl = new XmlAttributeImpl(this, string, xmlNamespace, string2, string3, bl);
        return this.addAttribute(xmlAttributeImpl);
    }

    public XmlAttribute addAttribute(String string, String string2, String string3, String string4, String string5, boolean bl) {
        XmlNamespace xmlNamespace = this.newNamespace(string2, string3);
        return this.addAttribute(string, xmlNamespace, string4, string5, bl);
    }

    public void ensureAttributeCapacity(int n) {
        if (this.attrs == null) {
            this.attrs = new ArrayList(n);
        } else {
            ((ArrayList)this.attrs).ensureCapacity(n);
        }
    }

    public String getAttributeValue(String string, String string2) {
        XmlAttribute xmlAttribute = this.findAttribute(string, string2);
        if (xmlAttribute != null) {
            return xmlAttribute.getValue();
        }
        return null;
    }

    public boolean hasAttributes() {
        return this.attrs != null && this.attrs.size() > 0;
    }

    public XmlAttribute attribute(String string) {
        return this.attribute(null, string);
    }

    public XmlAttribute attribute(XmlNamespace xmlNamespace, String string) {
        return this.findAttribute(xmlNamespace != null ? xmlNamespace.getNamespaceName() : null, string);
    }

    public XmlAttribute findAttribute(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("attribute name ca not ber null");
        }
        if (this.attrs == null) {
            return null;
        }
        int n = this.attrs.size();
        for (int i = 0; i < n; ++i) {
            XmlAttribute xmlAttribute = (XmlAttribute)this.attrs.get(i);
            String string3 = xmlAttribute.getName();
            if (string3 != string2 && !string2.equals(string3)) continue;
            if (string != null) {
                String string4 = xmlAttribute.getNamespaceName();
                if (string.equals(string4)) {
                    return xmlAttribute;
                }
                if (string != "" || string4 != null) continue;
                return xmlAttribute;
            }
            if (xmlAttribute.getNamespace() == null) {
                return xmlAttribute;
            }
            if (xmlAttribute.getNamespace().getNamespaceName() != "") continue;
            return xmlAttribute;
        }
        return null;
    }

    public void removeAllAttributes() {
        this.attrs = null;
    }

    public void removeAttribute(XmlAttribute xmlAttribute) {
        if (this.attrs == null) {
            throw new XmlBuilderException("this element has no attributes to remove");
        }
        for (int i = 0; i < this.attrs.size(); ++i) {
            if (!this.attrs.get(i).equals(xmlAttribute)) continue;
            this.attrs.remove(i);
            break;
        }
    }

    public XmlNamespace declareNamespace(String string, String string2) {
        if (string == null) {
            throw new XmlBuilderException("namespace added to element must have not null prefix");
        }
        XmlNamespace xmlNamespace = this.newNamespace(string, string2);
        return this.declareNamespace(xmlNamespace);
    }

    public XmlNamespace declareNamespace(XmlNamespace xmlNamespace) {
        if (xmlNamespace.getPrefix() == null) {
            throw new XmlBuilderException("namespace added to element must have not null prefix");
        }
        if (this.nsList == null) {
            this.ensureNamespaceDeclarationsCapacity(5);
        }
        this.nsList.add(xmlNamespace);
        return xmlNamespace;
    }

    public boolean hasNamespaceDeclarations() {
        return this.nsList != null && this.nsList.size() > 0;
    }

    public XmlNamespace lookupNamespaceByPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("namespace prefix can not be null");
        }
        if (this.hasNamespaceDeclarations()) {
            int n = this.nsList.size();
            for (int i = 0; i < n; ++i) {
                XmlNamespace xmlNamespace = (XmlNamespace)this.nsList.get(i);
                if (!string.equals(xmlNamespace.getPrefix())) continue;
                return xmlNamespace;
            }
        }
        if (this.parent != null && this.parent instanceof XmlElement) {
            return ((XmlElement)this.parent).lookupNamespaceByPrefix(string);
        }
        return null;
    }

    public XmlNamespace lookupNamespaceByName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("namespace name can not ber null");
        }
        if (this.hasNamespaceDeclarations()) {
            int n = this.nsList.size();
            for (int i = 0; i < n; ++i) {
                XmlNamespace xmlNamespace = (XmlNamespace)this.nsList.get(i);
                if (!string.equals(xmlNamespace.getNamespaceName())) continue;
                return xmlNamespace;
            }
        }
        if (this.parent != null && this.parent instanceof XmlElement) {
            return ((XmlElement)this.parent).lookupNamespaceByName(string);
        }
        return null;
    }

    public Iterator namespaces() {
        if (this.nsList == null) {
            return EMPTY_ITERATOR;
        }
        return this.nsList.iterator();
    }

    public XmlNamespace newNamespace(String string) {
        return this.newNamespace(null, string);
    }

    public XmlNamespace newNamespace(String string, String string2) {
        return new XmlNamespaceImpl(string, string2);
    }

    public void ensureNamespaceDeclarationsCapacity(int n) {
        if (this.nsList == null) {
            this.nsList = new ArrayList(n);
        } else {
            ((ArrayList)this.nsList).ensureCapacity(n);
        }
    }

    public void removeAllNamespaceDeclarations() {
        this.nsList = null;
    }

    public void addChild(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.children == null) {
            this.ensureChildrenCapacity(1);
        }
        this.children.add(object);
    }

    public void addChild(int n, Object object) {
        if (this.children == null) {
            this.ensureChildrenCapacity(1);
        }
        this.children.add(n, object);
    }

    private void checkChildParent(Object object) {
        if (object instanceof XmlContainer) {
            if (object instanceof XmlElement) {
                XmlElement xmlElement = (XmlElement)object;
                XmlContainer xmlContainer = xmlElement.getParent();
                if (xmlContainer != null && xmlContainer != this.parent) {
                    throw new XmlBuilderException("child must have no parent to be added to this node");
                }
            } else if (object instanceof XmlDocument) {
                throw new XmlBuilderException("docuemet can not be stored as element child");
            }
        }
    }

    private void setChildParent(Object object) {
        if (object instanceof XmlElement) {
            XmlElement xmlElement = (XmlElement)object;
            xmlElement.setParent(this);
        }
    }

    public XmlElement addElement(XmlElement xmlElement) {
        this.checkChildParent(xmlElement);
        this.addChild(xmlElement);
        this.setChildParent(xmlElement);
        return xmlElement;
    }

    public XmlElement addElement(int n, XmlElement xmlElement) {
        this.checkChildParent(xmlElement);
        this.addChild(n, xmlElement);
        this.setChildParent(xmlElement);
        return xmlElement;
    }

    public XmlElement addElement(XmlNamespace xmlNamespace, String string) {
        XmlElement xmlElement = this.newElement(xmlNamespace, string);
        this.addChild(xmlElement);
        this.setChildParent(xmlElement);
        return xmlElement;
    }

    public XmlElement addElement(String string) {
        return this.addElement(null, string);
    }

    public Iterator children() {
        if (this.children == null) {
            return EMPTY_ITERATOR;
        }
        return this.children.iterator();
    }

    public Iterable requiredElementContent() {
        if (this.children == null) {
            return EMPTY_ITERABLE;
        }
        return new Iterable(){

            public Iterator iterator() {
                return new RequiredElementContentIterator(XmlElementImpl.this.children.iterator());
            }
        };
    }

    public String requiredTextContent() {
        if (this.children == null) {
            return "";
        }
        if (this.children.size() == 0) {
            return "";
        }
        if (this.children.size() == 1) {
            Object e = this.children.get(0);
            if (e instanceof String) {
                return e.toString();
            }
            if (e instanceof XmlCharacters) {
                return ((XmlCharacters)e).getText();
            }
            throw new XmlBuilderException("expected text content and not " + (e != null ? e.getClass() : null) + " with '" + e + "'");
        }
        Iterator iterator = this.children();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof String) {
                stringBuffer.append(e.toString());
                continue;
            }
            if (e instanceof XmlCharacters) {
                stringBuffer.append(((XmlCharacters)e).getText());
                continue;
            }
            throw new XmlBuilderException("expected text content and not " + e.getClass() + " with '" + e + "'");
        }
        return stringBuffer.toString();
    }

    public void ensureChildrenCapacity(int n) {
        if (this.children == null) {
            this.children = new ArrayList(n);
        } else {
            ((ArrayList)this.children).ensureCapacity(n);
        }
    }

    public XmlElement element(int n) {
        if (this.children == null) {
            return null;
        }
        int n2 = this.children.size();
        int n3 = 0;
        if (n >= 0 && n < n2 + 1) {
            for (int i = 0; i < n2; ++i) {
                Object e = this.children.get(i);
                if (!(e instanceof XmlElement) || ++n3 != n) continue;
                return (XmlElement)e;
            }
        } else {
            throw new IndexOutOfBoundsException("position " + n + " bigger or equal to " + n2 + " children");
        }
        throw new IndexOutOfBoundsException("position " + n + " too big as only " + n3 + " element(s) available");
    }

    public XmlElement requiredElement(XmlNamespace xmlNamespace, String string) throws XmlBuilderException {
        XmlElement xmlElement = this.element(xmlNamespace, string);
        if (xmlElement == null) {
            throw new XmlBuilderException("could not find element with name " + string + " in namespace " + (xmlNamespace != null ? xmlNamespace.getNamespaceName() : null));
        }
        return xmlElement;
    }

    public XmlElement element(XmlNamespace xmlNamespace, String string) {
        return this.element(xmlNamespace, string, false);
    }

    public XmlElement element(XmlNamespace xmlNamespace, String string, boolean bl) {
        XmlElement xmlElement;
        XmlElement xmlElement2 = xmlElement = xmlNamespace != null ? this.findElementByName(xmlNamespace.getNamespaceName(), string) : this.findElementByName(string);
        if (xmlElement != null) {
            return xmlElement;
        }
        if (bl) {
            return this.addElement(xmlNamespace, string);
        }
        return null;
    }

    public Iterable elements(final XmlNamespace xmlNamespace, final String string) {
        return new Iterable(){

            public Iterator iterator() {
                return new ElementsSimpleIterator(xmlNamespace, string, XmlElementImpl.this.children());
            }
        };
    }

    public XmlElement findElementByName(String string) {
        if (this.children == null) {
            return null;
        }
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            XmlElement xmlElement;
            Object e = this.children.get(i);
            if (!(e instanceof XmlElement) || !string.equals((xmlElement = (XmlElement)e).getName())) continue;
            return xmlElement;
        }
        return null;
    }

    public XmlElement findElementByName(String string, String string2, XmlElement xmlElement) {
        throw new UnsupportedOperationException();
    }

    public XmlElement findElementByName(String string, XmlElement xmlElement) {
        throw new UnsupportedOperationException();
    }

    public XmlElement findElementByName(String string, String string2) {
        if (this.children == null) {
            return null;
        }
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            XmlElement xmlElement;
            XmlNamespace xmlNamespace;
            Object e = this.children.get(i);
            if (!(e instanceof XmlElement) || !((xmlNamespace = (xmlElement = (XmlElement)e).getNamespace()) != null ? string2.equals(xmlElement.getName()) && string.equals(xmlNamespace.getNamespaceName()) : string2.equals(xmlElement.getName()) && string == null)) continue;
            return xmlElement;
        }
        return null;
    }

    public boolean hasChild(Object object) {
        if (this.children == null) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != object) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public void insertChild(int n, Object object) {
        if (this.children == null) {
            this.ensureChildrenCapacity(1);
        }
        this.children.add(n, object);
    }

    public XmlElement newElement(String string) {
        return this.newElement((XmlNamespace)null, string);
    }

    public XmlElement newElement(String string, String string2) {
        return new XmlElementImpl(string, string2);
    }

    public XmlElement newElement(XmlNamespace xmlNamespace, String string) {
        return new XmlElementImpl(xmlNamespace, string);
    }

    public void replaceChild(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("new child to replace can not be null");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("old child to replace can not be null");
        }
        if (!this.hasChildren()) {
            throw new XmlBuilderException("no children available for replacement");
        }
        int n = this.children.indexOf(object2);
        if (n == -1) {
            throw new XmlBuilderException("could not find child to replace");
        }
        this.children.set(n, object);
    }

    public void removeAllChildren() {
        this.children = null;
    }

    public void removeChild(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("child to remove can not be null");
        }
        if (!this.hasChildren()) {
            throw new XmlBuilderException("no children to remove");
        }
        int n = this.children.indexOf(object);
        if (n != -1) {
            this.children.remove(n);
        }
    }

    public void replaceChildrenWithText(String string) {
        this.removeAllChildren();
        this.addChild(string);
    }

    private static final boolean isWhiteSpace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ' || string.charAt(i) == '\n' || string.charAt(i) == '\t' || string.charAt(i) == '\r') continue;
            return false;
        }
        return true;
    }

    private class ElementsSimpleIterator
    implements Iterator {
        private Iterator children;
        private XmlElement currentEl;
        private XmlNamespace n;
        private String name;

        ElementsSimpleIterator(XmlNamespace xmlNamespace, String string, Iterator iterator) {
            this.children = iterator;
            this.n = xmlNamespace;
            this.name = string;
            this.findNextEl();
        }

        private void findNextEl() {
            this.currentEl = null;
            while (this.children.hasNext()) {
                Object e = this.children.next();
                if (!(e instanceof XmlElement)) continue;
                XmlElement xmlElement = (XmlElement)e;
                if (this.name != null && xmlElement.getName() != this.name && !this.name.equals(xmlElement.getName()) || this.n != null && xmlElement.getNamespace() != this.n && !this.n.equals(xmlElement.getNamespace())) continue;
                this.currentEl = xmlElement;
                break;
            }
        }

        public boolean hasNext() {
            return this.currentEl != null;
        }

        public Object next() {
            if (this.currentEl == null) {
                throw new XmlBuilderException("this iterator has no content and next() is not allowed");
            }
            XmlElement xmlElement = this.currentEl;
            this.findNextEl();
            return xmlElement;
        }

        public void remove() {
            throw new XmlBuilderException("this element iterator does nto support remove()");
        }
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new XmlBuilderException("this iterator has no content and next() is not allowed");
        }

        public void remove() {
            throw new XmlBuilderException("this iterator has no content and remove() is not allowed");
        }
    }

    private static class RequiredElementContentIterator
    implements Iterator {
        private Iterator children;
        private XmlElement currentEl;

        RequiredElementContentIterator(Iterator iterator) {
            this.children = iterator;
            this.findNextEl();
        }

        private void findNextEl() {
            this.currentEl = null;
            while (this.children.hasNext()) {
                Object object;
                Object e = this.children.next();
                if (e instanceof XmlElement) {
                    this.currentEl = (XmlElement)e;
                    break;
                }
                if (e instanceof String) {
                    object = e.toString();
                    if (XmlElementImpl.isWhiteSpace((String)object)) continue;
                    throw new XmlBuilderException("only whitespace string children allowed for non mixed element content");
                }
                if (e instanceof XmlCharacters) {
                    object = (XmlCharacters)e;
                    if (Boolean.TRUE.equals(object.isWhitespaceContent()) && XmlElementImpl.isWhiteSpace(object.getText())) continue;
                    throw new XmlBuilderException("only whitespace characters children allowed for non mixed element content");
                }
                throw new XmlBuilderException("only whitespace characters and element children allowed for non mixed element content and not " + e.getClass());
            }
        }

        public boolean hasNext() {
            return this.currentEl != null;
        }

        public Object next() {
            if (this.currentEl == null) {
                throw new XmlBuilderException("this iterator has no content and next() is not allowed");
            }
            XmlElement xmlElement = this.currentEl;
            this.findNextEl();
            return xmlElement;
        }

        public void remove() {
            throw new XmlBuilderException("this iterator does nto support remove()");
        }
    }
}

