/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.slidinglayout;

import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLTransition;
import aurelienribon.tweenengine.TweenManager;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLayeredPane;

public class SLPanel
extends JLayeredPane {
    private TweenManager tweenManager;
    SLConfig currentCfg;
    boolean isTransitionPlaying = false;

    public SLPanel() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (SLPanel.this.currentCfg != null) {
                    SLPanel.this.initialize(SLPanel.this.currentCfg);
                }
            }
        });
    }

    public void setTweenManager(TweenManager tweenManager) {
        this.tweenManager = tweenManager;
    }

    public void initialize(SLConfig cfg) {
        this.currentCfg = cfg;
        if (this.getWidth() != 0 || this.getHeight() != 0) {
            cfg.placeAndRoute();
            this.removeAll();
            for (Component c : cfg.getCmps()) {
                SLConfig.Tile t = cfg.getTile(c);
                c.setBounds(t.x, t.y, t.w, t.h);
                c.validate();
                this.add(c, new Integer(1));
            }
        }
    }

    public SLTransition createTransition() {
        return new SLTransition(this, this.tweenManager);
    }
}

